/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.binding;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.OperationSelectorType;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.JavaOperationSelectorType;
import org.switchyard.tools.models.switchyard1_0.switchyard.RegexOperationSelectorType;
import org.switchyard.tools.models.switchyard1_0.switchyard.StaticOperationSelectorType;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchyardFactory;
import org.switchyard.tools.models.switchyard1_0.switchyard.XPathOperationSelectorType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.RegexValidator;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.util.InterfaceOpsUtil;

public class OperationSelectorComposite
extends Composite {
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private Binding _binding = null;
    private ListenerList _changeListeners;
    private Combo _operationSelectionCombo;
    private Text _xpathText;
    private Text _regexText;
    private Text _javaText;
    private Composite _operationSelectionComposite;
    private Composite _xpathComposite;
    private Composite _regexComposite;
    private Composite _javaComposite;
    private Composite _panel;
    private ComboViewer _typeCombo;
    private Composite _contentPanel = null;
    private StackLayout _stackLayout = null;
    private Button _browseClassBtn = null;
    private WritableValue _bindingValue;
    private IObservableValue _selectorValue;

    public OperationSelectorComposite(Composite parent, int style, AbstractSYBindingComposite container) {
        this(parent, style, container, false);
    }

    public OperationSelectorComposite(Composite parent, int style, AbstractSYBindingComposite container, boolean isReadOnly) {
        super(parent, style);
        this._panel = parent;
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Group opGroup = new Group((Composite)this, additionalStyles);
        opGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        opGroup.setLayout((Layout)layout);
        opGroup.setText(Messages.OperationSelectorComposite_OperationSelectorGroup_label);
        this._typeCombo = new ComboViewer(this.createCombo((Composite)opGroup, null, true));
        this._typeCombo.getControl().setLayoutData((Object)new GridData());
        this._typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._typeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof SelectorType) {
                    return ((SelectorType)((Object)element)).getLabel();
                }
                return super.getText(element);
            }
        });
        this._typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                OperationSelectorComposite.this.handleSelectorTypeChanged((SelectorType)((Object)((IStructuredSelection)event.getSelection()).getFirstElement()));
            }
        });
        this._typeCombo.setInput((Object)SelectorType.values());
        this._contentPanel = new Composite((Composite)opGroup, 0);
        this._stackLayout = new StackLayout();
        this._contentPanel.setLayout((Layout)this._stackLayout);
        this._contentPanel.setLayoutData((Object)new GridData(4, 4, true, true));
        this._operationSelectionComposite = new Composite(this._contentPanel, 0);
        this._operationSelectionCombo = this.createCombo(this._operationSelectionComposite, Messages.label_operationName, false);
        this._operationSelectionComposite.setLayout((Layout)new GridLayout());
        this._operationSelectionCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this._xpathComposite = new Composite(this._contentPanel, 0);
        this._xpathText = this.createText(this._xpathComposite);
        this._xpathComposite.setLayout((Layout)new GridLayout());
        this._xpathText.setLayoutData((Object)new GridData(4, 0, true, false));
        this._regexComposite = new Composite(this._contentPanel, 0);
        this._regexText = this.createText(this._regexComposite);
        this._regexComposite.setLayout((Layout)new GridLayout());
        this._regexText.setLayoutData((Object)new GridData(4, 0, true, false));
        this._javaComposite = new Composite(this._contentPanel, 0);
        this._javaText = this.createText(this._javaComposite);
        this._javaComposite.setLayout((Layout)new GridLayout(2, false));
        this._browseClassBtn = new Button(this._javaComposite, 8);
        this._browseClassBtn.setText("...");
        this._browseClassBtn.setEnabled(this._isReadOnly);
        this._javaText.setLayoutData((Object)new GridData(4, 0, true, false));
        this._browseClassBtn.setLayoutData((Object)new GridData(4, 0, false, false));
        this._browseClassBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IType selected = OperationSelectorComposite.this.selectType(OperationSelectorComposite.this._panel.getShell(), "org.switchyard.selector.OperationSelector", null);
                    if (selected != null) {
                        OperationSelectorComposite.this._javaText.setText(selected.getFullyQualifiedName());
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this._typeCombo.setSelection((ISelection)new StructuredSelection((Object)SelectorType.STATIC_TYPE));
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
        this.populateOperationCombo();
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    protected Binding getBinding() {
        return this._binding;
    }

    public void setBinding(Binding binding) {
        this._binding = binding;
        this.populateOperationCombo();
        this._bindingValue.setValue((Object)binding);
    }

    public void bindControls(EditingDomain domain, DataBindingContext context) {
        Realm realm = SWTObservables.getRealm((Display)this.getDisplay());
        this._bindingValue = new WritableValue(realm, null, Binding.class);
        WritableValue selectorTypeValue = new WritableValue(realm, null, SelectorType.class);
        WritableValue staticValue = new WritableValue(realm, null, String.class);
        WritableValue regexValue = new WritableValue(realm, null, String.class);
        WritableValue xpathValue = new WritableValue(realm, null, String.class);
        WritableValue javaValue = new WritableValue(realm, null, String.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._typeCombo), (IObservableValue)selectorTypeValue, new UpdateValueStrategy(), null);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._operationSelectionCombo), (IObservableValue)staticValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._regexText, (int)24), (IObservableValue)regexValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator((IValidator)new RegexValidator()), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._xpathText, (int)24), (IObservableValue)xpathValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._javaText, (int)24), (IObservableValue)javaValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        this._selectorValue = new ComputedValue(realm, OperationSelectorType.class, (IObservableValue)selectorTypeValue, (IObservableValue)staticValue, (IObservableValue)xpathValue, (IObservableValue)regexValue, (IObservableValue)javaValue){
            private final /* synthetic */ IObservableValue val$selectorTypeValue;
            private final /* synthetic */ IObservableValue val$staticValue;
            private final /* synthetic */ IObservableValue val$xpathValue;
            private final /* synthetic */ IObservableValue val$regexValue;
            private final /* synthetic */ IObservableValue val$javaValue;
            {
                this.val$selectorTypeValue = iObservableValue;
                this.val$staticValue = iObservableValue2;
                this.val$xpathValue = iObservableValue3;
                this.val$regexValue = iObservableValue4;
                this.val$javaValue = iObservableValue5;
                super($anonymous0, $anonymous1);
            }

            protected Object calculate() {
                SelectorType selectedType = (SelectorType)((Object)this.val$selectorTypeValue.getValue());
                String operationText = (String)this.val$staticValue.getValue();
                String xpathText = (String)this.val$xpathValue.getValue();
                String regexText = (String)this.val$regexValue.getValue();
                String javaText = (String)this.val$javaValue.getValue();
                if (selectedType == null) {
                    return null;
                }
                switch (selectedType) {
                    case STATIC_TYPE: {
                        return selectedType.createOperationSelector(operationText);
                    }
                    case XPATH_TYPE: {
                        return selectedType.createOperationSelector(xpathText);
                    }
                    case REGEX_TYPE: {
                        return selectedType.createOperationSelector(regexText);
                    }
                    case JAVA_TYPE: {
                        return selectedType.createOperationSelector(javaText);
                    }
                }
                return null;
            }

            protected void doSetValue(Object value) {
                if (value == null) {
                    this.val$selectorTypeValue.setValue((Object)SelectorType.STATIC_TYPE);
                    this.val$staticValue.setValue((Object)"");
                } else if (value instanceof OperationSelectorType) {
                    SelectorType selectorType = SelectorType.valueOf((OperationSelectorType)value);
                    this.val$selectorTypeValue.setValue((Object)selectorType);
                    switch (selectorType) {
                        case STATIC_TYPE: {
                            this.val$staticValue.setValue((Object)((StaticOperationSelectorType)value).getOperationName());
                            break;
                        }
                        case XPATH_TYPE: {
                            this.val$xpathValue.setValue((Object)((XPathOperationSelectorType)value).getExpression());
                            break;
                        }
                        case REGEX_TYPE: {
                            this.val$regexValue.setValue((Object)((RegexOperationSelectorType)value).getExpression());
                            break;
                        }
                        case JAVA_TYPE: {
                            this.val$javaValue.setValue((Object)((JavaOperationSelectorType)value).getClass_());
                        }
                    }
                } else {
                    throw new IllegalArgumentException("Unknown selector type: " + value.getClass().getCanonicalName());
                }
                this.getValue();
            }
        };
        context.bindValue(this._selectorValue, ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_OperationSelector()));
        this._selectorValue.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                OperationSelectorComposite.this.fireChangedEvent((Object)OperationSelectorComposite.this);
            }
        });
    }

    protected Combo createLabelAndCombo(Composite parent, String label) {
        return this.createLabelAndCombo(parent, label, false);
    }

    protected Combo createLabelAndCombo(Composite parent, String label, boolean readOnly) {
        if (label != null && !label.trim().isEmpty()) {
            Label labelControl = new Label(parent, 0);
            labelControl.setText(label);
            TabbedPropertySheetWidgetFactory factory = new TabbedPropertySheetWidgetFactory();
            factory.adapt((Control)labelControl, false, false);
        }
        int styles = 2052;
        if (readOnly) {
            styles = 2060;
        }
        Combo combo = new Combo(parent, styles);
        combo.setLayoutData((Object)new GridData(4, 0, true, false));
        if (!readOnly) {
            this.addEnterNextListener((Control)combo);
        }
        return combo;
    }

    protected Combo createCombo(Composite parent, String label, boolean readOnly) {
        int styles = 2052;
        if (readOnly) {
            styles = 2060;
        }
        Combo combo = new Combo(parent, styles);
        combo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.addEnterNextListener((Control)combo);
        return combo;
    }

    protected Text createText(Composite parent) {
        int styles = 2048;
        Text textfield = new Text(parent, styles);
        textfield.setLayoutData((Object)new GridData(4, 0, true, false));
        this.addEnterNextListener((Control)textfield);
        return textfield;
    }

    private void addEnterNextListener(final Control control) {
        control.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\r') {
                    control.traverse(16);
                }
            }
        });
    }

    public void populateOperationCombo() {
        if (this._operationSelectionCombo != null && !this._operationSelectionCombo.isDisposed()) {
            EObject target = null;
            if (this.getBinding() != null && this.getTargetObject() == null) {
                EObject parent = this.getBinding().eContainer();
                if (parent != null && !(parent instanceof Contract)) {
                    parent = parent.eContainer();
                }
                if (parent instanceof Contract) {
                    target = parent;
                    this.setTargetObject(target);
                }
            }
            String selection = this._operationSelectionCombo.getText();
            if (this.getTargetObject() != null && this.getTargetObject() instanceof Contract) {
                String[] operations = InterfaceOpsUtil.gatherOperations((Contract)this.getTargetObject());
                this._operationSelectionCombo.setItems(operations);
            }
            if (selection != null && selection.length() > 0) {
                int index = this._operationSelectionCombo.indexOf(selection);
                if (index < 0) {
                    this._operationSelectionCombo.setText(selection);
                } else {
                    this._operationSelectionCombo.select(index);
                }
            }
        }
    }

    private void handleSelectorTypeChanged(SelectorType typeToSelect) {
        this._xpathText.setEnabled(false);
        this._regexText.setEnabled(false);
        this._javaText.setEnabled(false);
        this._browseClassBtn.setEnabled(false);
        switch (typeToSelect) {
            case STATIC_TYPE: {
                this._operationSelectionCombo.setEnabled(true);
                this._stackLayout.topControl = this._operationSelectionComposite;
                break;
            }
            case XPATH_TYPE: {
                this._xpathText.setEnabled(true);
                this._stackLayout.topControl = this._xpathComposite;
                break;
            }
            case REGEX_TYPE: {
                this._regexText.setEnabled(true);
                this._stackLayout.topControl = this._regexComposite;
                break;
            }
            case JAVA_TYPE: {
                this._javaText.setEnabled(true);
                this._browseClassBtn.setEnabled(true);
                this._stackLayout.topControl = this._javaComposite;
            }
        }
        this._contentPanel.layout();
    }

    public IType selectType(Shell shell, String superTypeName, IProject project) throws JavaModelException {
        IJavaSearchScope searchScope = null;
        if (project == null) {
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            StructuredSelection selectionToPass = StructuredSelection.EMPTY;
            if (selection instanceof IStructuredSelection && (selectionToPass = (IStructuredSelection)selection).getFirstElement() instanceof IFile) {
                project = ((IFile)selectionToPass.getFirstElement()).getProject();
            }
        }
        if (superTypeName != null) {
            IJavaProject javaProject;
            IType superType;
            if (project == null) {
                project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
            }
            if ((superType = (javaProject = JavaCore.create((IProject)project)).findType(superTypeName)) != null) {
                searchScope = SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)superType, (boolean)true, (boolean)false, null);
            }
        } else {
            searchScope = SearchEngine.createWorkspaceScope();
        }
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)searchScope, (int)512, (boolean)false);
        dialog.setTitle(Messages.label_selectEntries);
        dialog.setMessage(Messages.label_matchingItems);
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types == null || types.length == 0) {
            return null;
        }
        return (IType)types[0];
    }

    private static enum SelectorType {
        STATIC_TYPE(Messages.label_operationName){

            @Override
            public OperationSelectorType createOperationSelector(String selectorText) {
                if (selectorText == null || selectorText.trim().length() == 0) {
                    return null;
                }
                StaticOperationSelectorType selector = SwitchyardFactory.eINSTANCE.createStaticOperationSelectorType();
                selector.setOperationName(selectorText);
                return selector;
            }
        }
        ,
        XPATH_TYPE(Messages.label_xpath){

            @Override
            public OperationSelectorType createOperationSelector(String selectorText) {
                if (selectorText == null || selectorText.trim().length() == 0) {
                    return null;
                }
                XPathOperationSelectorType selector = SwitchyardFactory.eINSTANCE.createXPathOperationSelectorType();
                selector.setExpression(selectorText);
                return selector;
            }
        }
        ,
        REGEX_TYPE(Messages.label_regex){

            @Override
            public OperationSelectorType createOperationSelector(String selectorText) {
                if (selectorText == null || selectorText.trim().length() == 0) {
                    return null;
                }
                RegexOperationSelectorType selector = SwitchyardFactory.eINSTANCE.createRegexOperationSelectorType();
                selector.setExpression(selectorText);
                return selector;
            }
        }
        ,
        JAVA_TYPE(Messages.label_javaClass){

            @Override
            public OperationSelectorType createOperationSelector(String selectorText) {
                if (selectorText == null || selectorText.trim().length() == 0) {
                    return null;
                }
                JavaOperationSelectorType selector = SwitchyardFactory.eINSTANCE.createJavaOperationSelectorType();
                selector.setClass(selectorText);
                return selector;
            }
        };

        private final String _label;

        private SelectorType(String label) {
            this._label = label;
        }

        public String getLabel() {
            return this._label;
        }

        public abstract OperationSelectorType createOperationSelector(String var1);

        public static SelectorType valueOf(String string) {
            return Enum.valueOf(SelectorType.class, string);
        }
    }
}

