/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.binding;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.CellEditorProperties;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.diagram.binding.PropertyObject;

public class AdvancedBindingPropertyTable
extends Composite {
    private TableViewer _propertyTreeTable;
    public static final String NAME_COLUMN = "name";
    public static final String VALUE_COLUMN = "value";
    private static final String[] TREE_COLUMNS = new String[]{"name", "value"};
    private EObject _targetObj = null;
    private ListenerList _changeListeners = new ListenerList();

    AdvancedBindingPropertyTable(Composite parent, int style, DataBindingContext context) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this._propertyTreeTable = new TableViewer((Composite)this, 68096);
        GridData gd11 = new GridData(4, 4, true, true, 2, 2);
        gd11.heightHint = 100;
        this._propertyTreeTable.getTable().setLayoutData((Object)gd11);
        this._propertyTreeTable.getTable().setHeaderVisible(true);
        TableViewerColumn nameColumn = new TableViewerColumn(this._propertyTreeTable, 16384);
        nameColumn.getColumn().setText(Messages.label_name);
        nameColumn.getColumn().setWidth(200);
        TableViewerColumn valueColumn = new TableViewerColumn(this._propertyTreeTable, 16384);
        valueColumn.getColumn().setText(Messages.label_value);
        valueColumn.getColumn().setWidth(200);
        valueColumn.setEditingSupport((EditingSupport)new PropertyValueEditingSupport(this._propertyTreeTable, context));
        FocusCellOwnerDrawHighlighter h = new FocusCellOwnerDrawHighlighter((ColumnViewer)this._propertyTreeTable){

            protected Color getSelectedCellBackgroundColorNoFocus(ViewerCell cell) {
                return Display.getCurrent().getSystemColor(22);
            }

            protected Color getSelectedCellForegroundColorNoFocus(ViewerCell cell) {
                return Display.getCurrent().getSystemColor(21);
            }
        };
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this._propertyTreeTable, (FocusCellHighlighter)h);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this._propertyTreeTable){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        actSupport.setEnableEditorActivationWithKeyboard(true);
        TableViewerEditor.create((TableViewer)this._propertyTreeTable, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        this._propertyTreeTable.getControl().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                IStructuredSelection ssel;
                if (e.detail == 4 && !AdvancedBindingPropertyTable.this._propertyTreeTable.isCellEditorActive() && (ssel = (IStructuredSelection)AdvancedBindingPropertyTable.this._propertyTreeTable.getSelection()) != null && !ssel.isEmpty()) {
                    AdvancedBindingPropertyTable.this._propertyTreeTable.editElement(ssel.getFirstElement(), 1);
                }
            }
        });
        this._propertyTreeTable.setComparator((ViewerComparator)new PropertyObjectViewerComparator());
        this._propertyTreeTable.setColumnProperties(TREE_COLUMNS);
        this._propertyTreeTable.setLabelProvider((IBaseLabelProvider)new PropertyTreeLabelProvider());
        this._propertyTreeTable.setContentProvider((IContentProvider)new PropertyTreeContentProvider());
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    protected TableViewer getTreeViewer() {
        return this._propertyTreeTable;
    }

    protected Object getFeatureValue(EObject eObject, String featureId) {
        EClass eClass = eObject.eClass();
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(featureId);
        if (eStructuralFeature.isChangeable() && eStructuralFeature.getName().equalsIgnoreCase(featureId)) {
            return eObject.eGet(eStructuralFeature);
        }
        return null;
    }

    protected EStructuralFeature getFeature(EObject eObject, String featureId) {
        EClass eClass = eObject.eClass();
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(featureId);
        if (eStructuralFeature.isChangeable() && eStructuralFeature.getName().equalsIgnoreCase(featureId)) {
            return eStructuralFeature;
        }
        return null;
    }

    class PropertyObjectViewerComparator
    extends ViewerComparator {
        PropertyObjectViewerComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof PropertyObject && e2 instanceof PropertyObject) {
                PropertyObject p1 = (PropertyObject)e1;
                PropertyObject p2 = (PropertyObject)e2;
                return p1.getFeatureName().compareTo(p2.getFeatureName());
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class PropertyTreeContentProvider
    implements ITreeContentProvider {
        private List<PropertyObject> _properties;

        private PropertyTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                this._properties = (List)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return this._properties.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof PropertyObject) {
                return ((PropertyObject)element).getEObject().eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof List) {
                return ((List)element).size() > 0;
            }
            return false;
        }
    }

    private class PropertyTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof PropertyObject && property.equalsIgnoreCase(AdvancedBindingPropertyTable.NAME_COLUMN)) {
                return true;
            }
            return element instanceof PropertyObject && property.equalsIgnoreCase(AdvancedBindingPropertyTable.VALUE_COLUMN);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PropertyObject && columnIndex == 0) {
                if (element instanceof PropertyObject) {
                    PropertyObject po = (PropertyObject)element;
                    return po.getFeatureName();
                }
                return null;
            }
            if (element instanceof PropertyObject && columnIndex == 1 && element instanceof PropertyObject) {
                boolean isEnum;
                PropertyObject po = (PropertyObject)element;
                Object value = AdvancedBindingPropertyTable.this.getFeatureValue(po.getEObject(), po.getFeatureName());
                if (value == null) {
                    return "";
                }
                if (value instanceof String) {
                    return (String)value;
                }
                if (value instanceof Boolean) {
                    return ((Boolean)value).toString();
                }
                if (value instanceof Integer) {
                    return ((Integer)value).toString();
                }
                if (value instanceof Long) {
                    return ((Long)value).toString();
                }
                if (value instanceof BigInteger) {
                    return ((BigInteger)value).toString();
                }
                if (value instanceof Double) {
                    return ((Double)value).toString();
                }
                if (value instanceof Float) {
                    return ((Float)value).toString();
                }
                EStructuralFeature feature = AdvancedBindingPropertyTable.this.getFeature(po.getEObject(), po.getFeatureName());
                if (feature != null && (isEnum = feature.getEType().getInstanceClass().isEnum())) {
                    T[] enums = feature.getEType().getInstanceClass().getEnumConstants();
                    int i = 0;
                    while (i < enums.length) {
                        if (value.equals(enums[i])) {
                            return enums[i].toString();
                        }
                        ++i;
                    }
                }
            }
            return null;
        }
    }

    private class PropertyValueEditingSupport
    extends ObservableValueEditingSupport {
        private final TableViewer _viewer;
        private final DataBindingContext _context;
        private PropertyObject _lastPO;

        public PropertyValueEditingSupport(TableViewer viewer, DataBindingContext context) {
            super((ColumnViewer)viewer, context);
            this._viewer = viewer;
            this._context = context;
        }

        protected CellEditor getCellEditor(Object element) {
            PropertyObject po;
            EStructuralFeature feature;
            if (element instanceof PropertyObject && (feature = AdvancedBindingPropertyTable.this.getFeature((po = (PropertyObject)element).getEObject(), po.getFeatureName())) != null) {
                TextCellEditor ce = null;
                String type = feature.getEType().getName();
                System.out.println("Creating cell editor for: " + type);
                boolean isEnum = feature.getEType().getInstanceClass().isEnum();
                if (type.equalsIgnoreCase("String") || type.equalsIgnoreCase("AnyURI") || type.equalsIgnoreCase("PropInteger") || type.equalsIgnoreCase("PropDouble") || type.equalsIgnoreCase("PropFloat") || type.equalsIgnoreCase("PropLong")) {
                    ce = new TextCellEditor((Composite)this._viewer.getTable());
                } else if (type.equalsIgnoreCase("BooleanObject") || type.equalsIgnoreCase("Boolean")) {
                    ce = feature.getDefaultValueLiteral() == null ? new ComboBoxCellEditor((Composite)this._viewer.getTable(), new String[]{"false", "true", ""}, 8) : new ComboBoxCellEditor((Composite)this._viewer.getTable(), new String[]{"false", "true"}, 8);
                } else if (type.equalsIgnoreCase("Integer") || type.equalsIgnoreCase("IntObject") || type.equalsIgnoreCase("Int")) {
                    ce = new TextCellEditor((Composite)this._viewer.getTable());
                    ce.setValidator(new ICellEditorValidator(){

                        public String isValid(Object value) {
                            if (value instanceof String) {
                                String string = (String)value;
                                char[] chars = new char[string.length()];
                                string.getChars(0, chars.length, chars, 0);
                                int i = 0;
                                while (i < chars.length) {
                                    if ('0' > chars[i] || chars[i] > '9') {
                                        return Messages.error_invalidInteger;
                                    }
                                    ++i;
                                }
                            }
                            return null;
                        }
                    });
                } else if (type.equalsIgnoreCase("BigInteger")) {
                    ce = new TextCellEditor((Composite)this._viewer.getTable());
                    ce.setValidator(new ICellEditorValidator(){

                        public String isValid(Object value) {
                            if (value instanceof String) {
                                String string = (String)value;
                                char[] chars = new char[string.length()];
                                string.getChars(0, chars.length, chars, 0);
                                int i = 0;
                                while (i < chars.length) {
                                    if ('0' > chars[i] || chars[i] > '9') {
                                        return Messages.error_invalidBigInteger;
                                    }
                                    ++i;
                                }
                            }
                            return null;
                        }
                    });
                } else if (type.equalsIgnoreCase("LongObject") || type.equalsIgnoreCase("Long")) {
                    ce = new TextCellEditor((Composite)this._viewer.getTable());
                    ce.setValidator(new ICellEditorValidator(){

                        public String isValid(Object value) {
                            if (value instanceof String) {
                                String string = (String)value;
                                char[] chars = new char[string.length()];
                                string.getChars(0, chars.length, chars, 0);
                                int i = 0;
                                while (i < chars.length) {
                                    if ('0' > chars[i] || chars[i] > '9') {
                                        return Messages.error_invalidLongValue;
                                    }
                                    ++i;
                                }
                            }
                            return null;
                        }
                    });
                } else if (isEnum) {
                    T[] enums;
                    ArrayList<String> values = new ArrayList<String>();
                    T[] TArray = enums = feature.getEType().getInstanceClass().getEnumConstants();
                    int n = enums.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object enumItem = TArray[n2];
                        values.add(enumItem.toString());
                        ++n2;
                    }
                    ce = new ComboBoxCellEditor((Composite)this._viewer.getTable(), values.toArray(new String[values.size()]), 8);
                }
                return ce;
            }
            return null;
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            if (cellEditor.getControl() instanceof CCombo) {
                ISWTObservableValue ccomboObservable = SWTObservables.observeSelection((Control)cellEditor.getControl());
                return ccomboObservable;
            }
            return CellEditorProperties.control().value((IValueProperty)WidgetProperties.text((int[])new int[]{14, 16, 24})).observe((Object)cellEditor);
        }

        protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
            this._lastPO = (PropertyObject)element;
            EStructuralFeature feature = this._lastPO.getEObject().eClass().getEStructuralFeature(this._lastPO.getFeatureName());
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this._lastPO.getEObject());
            if (domain == null) {
                return EMFProperties.value((EStructuralFeature)feature).observe((Object)this._lastPO.getEObject());
            }
            return EMFEditProperties.value((EditingDomain)domain, (EStructuralFeature)feature).observe((Object)this._lastPO.getEObject());
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            Binding binding = this._context.bindValue(target, model, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
            model.addChangeListener(new IChangeListener(){

                public void handleChange(org.eclipse.core.databinding.observable.ChangeEvent event) {
                    AdvancedBindingPropertyTable.this._propertyTreeTable.update((Object)PropertyValueEditingSupport.this._lastPO, TREE_COLUMNS);
                    PropertyValueEditingSupport.this._lastPO = null;
                }
            });
            return binding;
        }
    }
}

