/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.binding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.ui.editor.diagram.shared.AbstractSwitchyardComposite;
import org.switchyard.tools.ui.editor.diagram.shared.IBindingComposite;
import org.switchyard.tools.ui.editor.diagram.shared.ModelOperation;

public abstract class AbstractSYBindingComposite
extends AbstractSwitchyardComposite
implements IBindingComposite {
    private Binding _binding;
    private EObject _targetObj = null;
    private boolean _didSomething = false;

    protected AbstractSYBindingComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public void setDidSomething(boolean flag) {
        this._didSomething = flag;
    }

    @Override
    public boolean getDidSomething() {
        return this._didSomething;
    }

    @Override
    public void setBinding(Binding binding) {
        this._binding = binding;
    }

    @Override
    public Binding getBinding() {
        return this._binding;
    }

    @Override
    protected void handleModify(Control control) {
    }

    protected void wrapOperation(List<ModelOperation> ops) {
        this.wrapOperation((EObject)this.getBinding(), ops);
    }

    protected boolean validChange(String objectpath, String featureId, Object value) {
        String[] path = this.parseString(objectpath, "/");
        Binding object = this._binding;
        int i = 0;
        while (i < path.length) {
            object = (EObject)this.getFeatureValue((EObject)object, path[i]);
            ++i;
        }
        if (object == null) {
            return false;
        }
        Object oldvalue = this.getFeatureValue((EObject)object, featureId);
        return oldvalue != value;
    }

    protected void updateControlEditable(Control control) {
        if (control != null && !control.isDisposed()) {
            control.setEnabled(this.canEdit());
        }
    }

    @Override
    public void setTargetObject(EObject target) {
        this._targetObj = target;
    }

    @Override
    public EObject getTargetObject() {
        return this._targetObj;
    }

    protected void updateFeature(EObject eObject, String[] featureId, Object[] value) {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        if (featureId != null && featureId.length > 0 && value != null && value.length > 0 && featureId.length == value.length) {
            int i = 0;
            while (i < featureId.length) {
                ops.add(new AbstractSwitchyardComposite.BasicEObjectOperation(this, eObject, featureId[i], value[i]));
                ++i;
            }
        }
        this.wrapOperation(ops);
    }

    @Override
    protected TransactionalEditingDomain getDomain(EObject object) {
        TransactionalEditingDomain domain = super.getDomain(object);
        if (domain == null) {
            return super.getDomain(this._targetObj);
        }
        return domain;
    }

    @Override
    protected boolean validate() {
        return this.getErrorMessage() == null;
    }

    protected void setTextValueAndNotify(Text control, String value, boolean setFocus) {
        control.setText(value);
        control.notifyListeners(24, null);
        control.notifyListeners(14, null);
        if (setFocus) {
            control.setFocus();
        }
    }

    protected void setComboValueAndNotify(Combo control, String value, boolean setFocus) {
        control.setText(value);
        control.notifyListeners(24, null);
        control.notifyListeners(14, null);
        if (setFocus) {
            control.setFocus();
        }
    }

    public class BasicOperation
    extends ModelOperation {
        private String _localObjectPath;
        private String _localFeature;
        private Object _localValue;

        public BasicOperation(String objectpath, String featureId, Object value) {
            this._localObjectPath = objectpath;
            this._localFeature = featureId;
            this._localValue = value;
        }

        @Override
        public void run() throws Exception {
            String[] path = AbstractSYBindingComposite.this.parseString(this._localObjectPath, "/");
            Binding object = AbstractSYBindingComposite.this.getBinding();
            int i = 0;
            while (i < path.length) {
                object = (EObject)AbstractSYBindingComposite.this.getFeatureValue((EObject)object, path[i]);
                ++i;
            }
            if (object != null) {
                if (this._localValue instanceof String && ((String)this._localValue).length() == 0) {
                    AbstractSYBindingComposite.this.setFeatureValue((EObject)object, this._localFeature, null);
                } else {
                    AbstractSYBindingComposite.this.setFeatureValue((EObject)object, this._localFeature, this._localValue);
                }
            } else {
                throw new Exception();
            }
        }
    }
}

