/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.binding;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.ui.editor.diagram.binding.IBindingWizard;
import org.switchyard.tools.ui.editor.diagram.internal.wizards.LinkedWizardBase;
import org.switchyard.tools.ui.editor.diagram.shared.IBindingComposite;

public abstract class AbstractBindingWizard
extends LinkedWizardBase
implements IBindingWizard {
    private List<IBindingComposite> _composites;
    private Contract _container;
    private Binding _newBinding;
    private final FormToolkit _toolkit;

    public AbstractBindingWizard() {
        FormColors colors = new FormColors(Display.getCurrent());
        colors.setBackground(null);
        colors.setForeground(null);
        this._toolkit = new FormToolkit(colors);
    }

    @Override
    public void dispose() {
        this._toolkit.dispose();
        super.dispose();
    }

    public void addPages() {
        for (IBindingComposite composite : this._composites) {
            this.addPage((IWizardPage)new BindingCompositeWizardPage(composite));
        }
    }

    @Override
    public Binding getCreatedObject() {
        return this._newBinding;
    }

    @Override
    public void init(Contract container) {
        this._container = container;
        this._newBinding = this.createBinding();
        this._composites = this.createComposites();
    }

    protected Contract getTargetContainer() {
        return this._container;
    }

    protected abstract Binding createBinding();

    protected abstract List<IBindingComposite> createComposites();

    protected String makeUniqueName(String baseName) {
        int index = 1;
        String name = String.valueOf(baseName) + index++;
        block0: while (true) {
            for (Binding test : this.getTargetContainer().getBinding()) {
                if (!name.equals(test.getName())) continue;
                name = String.valueOf(baseName) + index++;
                continue block0;
            }
            break;
        }
        return name;
    }

    @Override
    public boolean doFinish() {
        return true;
    }

    protected FormToolkit getToolkit() {
        return this._toolkit;
    }

    protected class BindingCompositeWizardPage
    extends WizardPage {
        private final IBindingComposite _composite;
        private final DataBindingContext _context;
        private final ObservablesManager _observablesManager;
        private WizardPageSupport _support;

        protected BindingCompositeWizardPage(IBindingComposite composite) {
            super("BindingWizard.page." + AbstractBindingWizard.this.getPageCount());
            this._context = new EMFDataBindingContext(SWTObservables.getRealm((Display)Display.getCurrent()));
            this._observablesManager = new ObservablesManager();
            this.setTitle(composite.getTitle());
            this.setDescription(composite.getDescription());
            this._composite = composite;
            this._observablesManager.addObservablesFromContext(this._context, true, true);
        }

        public void createControl(final Composite parent) {
            this._composite.setTargetObject((EObject)AbstractBindingWizard.this._container);
            this._observablesManager.runAndCollect(new Runnable(){

                @Override
                public void run() {
                    BindingCompositeWizardPage.this._composite.createContents(parent, 0, BindingCompositeWizardPage.this._context);
                }
            });
            this._composite.setBinding(AbstractBindingWizard.this._newBinding);
            this._composite.setTargetObject((EObject)AbstractBindingWizard.this._container);
            this.setControl((Control)this._composite.getPanel());
            this.setPageComplete(this._composite.getErrorMessage() == null);
            this._support = WizardPageSupport.create((WizardPage)this, (DataBindingContext)this._context);
            this.setErrorMessage(null);
        }

        public void dispose() {
            if (this._support != null) {
                this._support.dispose();
                this._support = null;
            }
            this._observablesManager.dispose();
            this._context.dispose();
            super.dispose();
        }
    }
}

