/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.WSDLPortType;
import org.eclipse.ui.PlatformUI;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.wizards.WSDL2JavaWizard;

public class WSDL2JavaCustomFeature
extends AbstractCustomFeature
implements ICustomFeature {
    public WSDL2JavaCustomFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getDescription() {
        return Messages.featureDescription_wsdlToJava;
    }

    public boolean isAvailable(IContext context) {
        PictogramElement[] pes = ((ICustomContext)context).getPictogramElements();
        if (pes == null || pes.length != 1) {
            return false;
        }
        Object bo = this.getBusinessObjectForPictogramElement(pes[0]);
        if (!(bo instanceof Contract)) {
            return false;
        }
        Interface intf = ((Contract)bo).getInterface();
        if (!(intf instanceof WSDLPortType)) {
            return false;
        }
        String wsdlIntf = ((WSDLPortType)intf).getInterface();
        return wsdlIntf != null && wsdlIntf.length() > 0;
    }

    public String getName() {
        return Messages.featureName_wsdlToJava;
    }

    public boolean hasDoneChanges() {
        return false;
    }

    public boolean canExecute(ICustomContext context) {
        return this.isAvailable((IContext)context);
    }

    public void execute(ICustomContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
        WSDLPortType wsdlIntf = (WSDLPortType)((Contract)bo).getInterface();
        WSDL2JavaWizard wizard = new WSDL2JavaWizard();
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wizard.init(PlatformUI.getWorkbench(), this.getResourceForInterface(wsdlIntf));
        dialog.open();
    }

    private IStructuredSelection getResourceForInterface(WSDLPortType wsdlIntf) {
        IResource file = (IResource)Platform.getAdapterManager().loadAdapter((Object)wsdlIntf, IResource.class.getCanonicalName());
        if (file == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)file);
    }

    public String getImageId() {
        return ImageProvider.IMG_16_WSDL_2_JAVA;
    }
}

