/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.switchyard.tools.ui.debug.SwitchYardDebugUtil;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class ToggleTransformBreakpointFeature
extends AbstractCustomFeature
implements ICustomFeature {
    private IBreakpoint _toDelete;
    private final PictogramElement _pe;
    private final Composite _composite;

    public ToggleTransformBreakpointFeature(IFeatureProvider fp, ICustomContext context) {
        super(fp);
        this._pe = context.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement(this._pe);
        IProject project = this.getProject();
        if (bo instanceof Composite) {
            IBreakpoint[] breakpoints;
            this._composite = (Composite)bo;
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.switchyard.tools.ui.debug");
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                IMarker marker = breakpoint.getMarker();
                String markerType = null;
                try {
                    markerType = marker.getType();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (marker != null && project.equals((Object)marker.getResource()) && "org.switchyard.tools.ui.debug.switchYardTransformerBreakpointMarker".equals(markerType)) {
                    this._toDelete = breakpoint;
                    break;
                }
                ++n2;
            }
        } else {
            this._composite = null;
        }
    }

    public void execute(ICustomContext context) {
        IProject project = this.getProject();
        if (this._toDelete != null) {
            try {
                this._toDelete.delete();
            }
            catch (CoreException e) {
                IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
                Shell shell = container instanceof SwitchyardSCAEditor ? ((SwitchyardSCAEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Error Removing Breakpoint", (String)e.getStatus().getMessage());
                return;
            }
        }
        try {
            SwitchYardDebugUtil.createTransformBreakpoint((IProject)project);
        }
        catch (CoreException e) {
            IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
            Shell shell = container instanceof SwitchyardSCAEditor ? ((SwitchyardSCAEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
            MessageDialog.openError((Shell)shell, (String)"Error Adding Breakpoint", (String)e.getStatus().getMessage());
            return;
        }
        this.getDiagramBehavior().refreshRenderingDecorators(this._pe);
    }

    public String getDescription() {
        return String.valueOf(this._toDelete == null ? "Set" : "Clear") + " a transform breakpoint.";
    }

    public String getImageId() {
        return ImageProvider.IMG_16_TRANSFORM_WATCH;
    }

    public boolean canExecute(ICustomContext context) {
        return this.isAvailable((IContext)context);
    }

    public boolean isAvailable(IContext context) {
        return this.getProject() != null && this._composite != null;
    }

    public boolean hasDoneChanges() {
        return false;
    }

    public String getName() {
        return String.valueOf(this._toDelete == null ? "Enable " : "Disable") + " Transform Breakpoint";
    }

    private IProject getProject() {
        IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
        if (container instanceof SwitchyardSCAEditor) {
            return ((SwitchyardSCAEditor)container).getModelFile().getProject();
        }
        return null;
    }
}

