/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram;

import javax.xml.namespace.QName;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramContainer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.switchyard.tools.models.switchyard1_0.switchyard.SwitchYardType;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;
import org.switchyard.tools.ui.debug.ServiceInteractionBreakpoint;
import org.switchyard.tools.ui.debug.SwitchYardDebugUtil;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class ToggleServiceBreakpointFeature
extends AbstractCustomFeature
implements ICustomFeature {
    private IBreakpoint _toDelete;
    private final PictogramElement _pe;
    private final Contract _contract;

    public ToggleServiceBreakpointFeature(IFeatureProvider fp, ICustomContext context) {
        super(fp);
        this._pe = context.getPictogramElements()[0] instanceof Connection ? ((Connection)context.getPictogramElements()[0]).getStart().getParent() : context.getPictogramElements()[0];
        Object bo = this.getBusinessObjectForPictogramElement(this._pe);
        IProject project = this.getProject();
        if (bo instanceof Contract) {
            IBreakpoint[] breakpoints;
            this._contract = (Contract)bo;
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.switchyard.tools.ui.debug");
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint breakpoint = iBreakpointArray[n2];
                IMarker marker = breakpoint.getMarker();
                String markerType = null;
                try {
                    markerType = marker.getType();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (marker != null && project.equals((Object)marker.getResource()) && "org.switchyard.tools.ui.debug.switchYardServiceBreakpointMarker".equals(markerType) && this.breakpointMatchesSelection((ServiceInteractionBreakpoint)breakpoint, (Contract)bo)) {
                    this._toDelete = breakpoint;
                    break;
                }
                ++n2;
            }
        } else {
            this._contract = null;
        }
    }

    public void execute(ICustomContext context) {
        IProject project = this.getProject();
        if (this._toDelete != null) {
            try {
                this._toDelete.delete();
            }
            catch (CoreException e) {
                IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
                Shell shell = container instanceof SwitchyardSCAEditor ? ((SwitchyardSCAEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
                MessageDialog.openError((Shell)shell, (String)"Error Removing Breakpoint", (String)e.getStatus().getMessage());
                return;
            }
        }
        URI uri = URI.createGenericURI((String)"switchyard", (String)"generated", (String)EcoreUtil.getURI((EObject)this._contract).fragment());
        try {
            SwitchYardDebugUtil.createServiceBreakpoint((IResource)project, (QName)this.getServiceName(this._contract), (String)uri.toString(), (SwitchYardDebugUtil.ServiceType)SwitchYardDebugUtil.ServiceType.fromContract((Contract)this._contract));
        }
        catch (CoreException e) {
            IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
            Shell shell = container instanceof SwitchyardSCAEditor ? ((SwitchyardSCAEditor)container).getEditorSite().getShell() : Display.getCurrent().getActiveShell();
            MessageDialog.openError((Shell)shell, (String)"Error Adding Breakpoint", (String)e.getStatus().getMessage());
            return;
        }
        this.getDiagramBehavior().refreshRenderingDecorators(this._pe);
    }

    private boolean breakpointMatchesSelection(ServiceInteractionBreakpoint breakpoint, Contract contract) {
        IInteractionConfiguration config = breakpoint.getInteractionConfiguration();
        if (config == null) {
            return false;
        }
        QName name = this.getServiceName(contract);
        if (contract instanceof Service || contract instanceof ComponentReference) {
            return config.getProviderName() == null && name.equals(config.getConsumerName());
        }
        return config.getConsumerName() == null && name.equals(config.getProviderName());
    }

    public String getDescription() {
        return String.valueOf(this._toDelete == null ? "Set" : "Clear") + " a breakpoint on the selected service.";
    }

    public String getImageId() {
        return ImageProvider.IMG_16_SERVICE_WATCH;
    }

    public boolean canExecute(ICustomContext context) {
        return this.isAvailable((IContext)context);
    }

    public boolean isAvailable(IContext context) {
        if (this._contract == null || this.getProject() == null) {
            return false;
        }
        QName serviceName = this.getServiceName(this._contract);
        return serviceName != null && serviceName.getLocalPart() != null;
    }

    public boolean hasDoneChanges() {
        return false;
    }

    public String getName() {
        return String.valueOf(this._toDelete == null ? "Enable " : "Disable") + " Breakpoint";
    }

    private QName getServiceName(Contract contract) {
        if (contract.getName() == null) {
            return null;
        }
        String targetNamespace = null;
        EObject container = contract.eContainer();
        while (container != null && targetNamespace == null) {
            if (container instanceof Composite) {
                targetNamespace = ((Composite)container).getTargetNamespace();
            } else if (container instanceof SwitchYardType) {
                targetNamespace = ((SwitchYardType)container).getTargetNamespace();
            }
            container = container.eContainer();
        }
        if (contract instanceof Service) {
            return new QName(targetNamespace, contract.getName());
        }
        if (contract instanceof ComponentReference) {
            String componentName = ((Component)contract.eContainer()).getName();
            return new QName(targetNamespace, componentName == null ? contract.getName() : String.valueOf(componentName) + "/" + contract.getName());
        }
        return new QName(targetNamespace, contract.getName());
    }

    private IProject getProject() {
        IDiagramContainer container = this.getDiagramBehavior().getDiagramContainer();
        if (container instanceof SwitchyardSCAEditor) {
            return ((SwitchyardSCAEditor)container).getModelFile().getProject();
        }
        return null;
    }
}

