/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutBendPoint;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.exampleStructures.SimpleNode;
import org.eclipse.zest.layouts.exampleStructures.SimpleRelationship;
import org.switchyard.tools.ui.editor.ImageProvider;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.CascadingRemoveFeature;

public class AutoLayoutFeature
extends AbstractCustomFeature {
    public AutoLayoutFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getDescription() {
        return Messages.featureDescription_layoutDiagram;
    }

    public String getName() {
        return Messages.featureName_layoutDiagram;
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] elements = context.getPictogramElements();
        return elements != null && elements.length == 1 && this.getBusinessObjectForPictogramElement(elements[0]) instanceof Composite;
    }

    public void execute(ICustomContext context) {
        Shape shape = (Shape)context.getPictogramElements()[0];
        ArrayList<SimpleRelationship> relationships = new ArrayList<SimpleRelationship>();
        LinkedHashMap<Shape, SimpleNode> shapes = new LinkedHashMap<Shape, SimpleNode>();
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        this.getLayoutEntities(shape, shapes, relationships);
        try {
            int width = ga.getWidth() - 60;
            int height = ga.getHeight() - 60;
            HorizontalTreeLayoutAlgorithm layoutAlgo = new HorizontalTreeLayoutAlgorithm(1);
            layoutAlgo.applyLayout(shapes.values().toArray(new LayoutEntity[shapes.size()]), relationships.toArray(new LayoutRelationship[relationships.size()]), (double)ga.getX(), (double)ga.getY(), (double)width, (double)height, false, false);
        }
        catch (InvalidLayoutConfiguration e) {
            e.printStackTrace();
            return;
        }
        this.updateCoordinates(ga, shapes, relationships);
        this.updateLayout((ContainerShape)context.getPictogramElements()[0]);
    }

    private void updateLayout(ContainerShape shape) {
        for (PictogramElement pe : shape.getChildren()) {
            if (!(pe instanceof ContainerShape)) continue;
            this.updateLayout((ContainerShape)pe);
        }
        this.layoutPictogramElement((PictogramElement)shape);
    }

    private void getLayoutEntities(Shape shape, Map<Shape, SimpleNode> map, List<SimpleRelationship> relationships) {
        if (map.containsKey(shape)) {
            return;
        }
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
        if (bo instanceof Composite) {
            PictogramElement pe;
            Composite composite = (Composite)bo;
            for (Component component : this.getSortedComponents(composite)) {
                pe = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)component);
                if (!(pe instanceof Shape)) continue;
                this.getLayoutEntities((Shape)pe, map, relationships);
            }
            for (Service service : composite.getService()) {
                pe = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)service);
                if (!(pe instanceof Shape)) continue;
                this.getLayoutEntities((Shape)pe, map, relationships);
            }
            for (Reference reference : composite.getReference()) {
                pe = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)reference);
                if (!(pe instanceof Shape)) continue;
                this.getLayoutEntities((Shape)pe, map, relationships);
            }
        } else if (bo instanceof Service) {
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            SimpleNode node = new SimpleNode((Object)shape, (double)ga.getX(), (double)ga.getY(), (double)ga.getWidth(), (double)ga.getHeight());
            map.put(shape, node);
            for (Anchor anchor : shape.getAnchors()) {
                for (Connection connection : anchor.getOutgoingConnections()) {
                    ContainerShape container = ((Shape)connection.getEnd().getParent()).getContainer();
                    this.getLayoutEntities((Shape)container, map, relationships);
                    relationships.add(new ConnectionRelationship((LayoutEntity)node, (LayoutEntity)map.get(container), false, connection));
                }
            }
        } else if (bo instanceof Component) {
            Shape container;
            PictogramElement pe;
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            SimpleNode node = new SimpleNode((Object)shape, (double)ga.getX(), (double)ga.getY(), (double)ga.getWidth(), (double)ga.getHeight());
            map.put(shape, node);
            for (ComponentService service : ((Component)bo).getService()) {
                pe = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)service);
                if (!(pe instanceof Shape)) continue;
                for (Anchor anchor : ((Shape)pe).getAnchors()) {
                    for (Connection connection : anchor.getIncomingConnections()) {
                        container = (Shape)connection.getStart().getParent();
                        if (!(this.getBusinessObjectForPictogramElement((PictogramElement)container) instanceof Service)) continue;
                        this.getLayoutEntities(container, map, relationships);
                    }
                }
            }
            for (ComponentReference reference : ((Component)bo).getReference()) {
                pe = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)reference);
                if (!(pe instanceof Shape)) continue;
                for (Anchor anchor : ((Shape)pe).getAnchors()) {
                    for (Connection connection : anchor.getOutgoingConnections()) {
                        container = (Shape)connection.getEnd().getParent();
                        if (this.getBusinessObjectForPictogramElement((PictogramElement)container) instanceof ComponentService) {
                            container = container.getContainer();
                        }
                        this.getLayoutEntities(container, map, relationships);
                        relationships.add(new ConnectionRelationship((LayoutEntity)node, (LayoutEntity)map.get(container), false, connection));
                    }
                }
            }
        } else if (bo instanceof Reference) {
            GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
            SimpleNode node = new SimpleNode((Object)shape, (double)ga.getX(), (double)ga.getY(), (double)ga.getWidth(), (double)ga.getHeight());
            map.put(shape, node);
        }
    }

    private void updateCoordinates(GraphicsAlgorithm compositeGA, Map<Shape, SimpleNode> shapes, List<SimpleRelationship> relationships) {
        int minY = compositeGA.getY() + 30 + 30;
        int delta = 0;
        for (SimpleNode simpleNode : shapes.values()) {
            int tmpDelta;
            if ((int)simpleNode.getY() >= minY || (tmpDelta = minY - (int)simpleNode.getY()) <= delta) continue;
            delta = tmpDelta;
        }
        for (Map.Entry entry : shapes.entrySet()) {
            SimpleNode node = (SimpleNode)entry.getValue();
            GraphicsAlgorithm ga = ((Shape)entry.getKey()).getGraphicsAlgorithm();
            ga.setX((int)node.getX());
            ga.setY((int)node.getY() + delta);
        }
        IGaService iGaService = Graphiti.getGaService();
        for (SimpleRelationship relationship : relationships) {
            FreeFormConnection connection = (FreeFormConnection)relationship.getGraphData();
            LayoutBendPoint[] bendPoints = relationship.getBendPoints();
            connection.getBendpoints().clear();
            LayoutBendPoint[] layoutBendPointArray = bendPoints;
            int n = bendPoints.length;
            int n2 = 0;
            while (n2 < n) {
                LayoutBendPoint bendPoint = layoutBendPointArray[n2];
                Point point = iGaService.createPoint((int)bendPoint.getX(), (int)bendPoint.getY() + delta);
                connection.getBendpoints().add((Object)point);
                ++n2;
            }
        }
    }

    private List<Component> getSortedComponents(Composite composite) {
        if (composite == null) {
            return Collections.emptyList();
        }
        ArrayList<Component> components = new ArrayList<Component>((Collection<Component>)composite.getComponent());
        Collections.sort(components, new Comparator<Component>(){

            @Override
            public int compare(Component o1, Component o2) {
                return o2.getReference().size() - o1.getReference().size();
            }
        });
        return components;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_AUTO_LAYOUT;
    }

    private static final class ConnectionRelationship
    extends SimpleRelationship {
        private final Connection _connection;

        private ConnectionRelationship(LayoutEntity sourceEntity, LayoutEntity destinationEntity, boolean bidirectional, Connection connection) {
            super(sourceEntity, destinationEntity, bidirectional);
            this._connection = connection;
        }

        public Object getGraphData() {
            return this._connection;
        }
    }

    public static final class RecreateDiagramFeature
    extends AutoLayoutFeature {
        public RecreateDiagramFeature(IFeatureProvider fp) {
            super(fp);
        }

        @Override
        public void execute(ICustomContext context) {
            ContainerShape shape = (ContainerShape)context.getPictogramElements()[0];
            Composite composite = (Composite)this.getBusinessObjectForPictogramElement((PictogramElement)shape);
            RemoveContext removeContext = new RemoveContext((PictogramElement)shape);
            CascadingRemoveFeature removeFeature = new CascadingRemoveFeature(this.getFeatureProvider());
            if (removeFeature.canExecute((IContext)removeContext)) {
                removeFeature.execute((IContext)removeContext);
                AddContext addContext = new AddContext();
                addContext.setTargetContainer((ContainerShape)this.getDiagram());
                addContext.setNewObject((Object)composite);
                PictogramElement newCompositeShape = this.getFeatureProvider().addIfPossible((IAddContext)addContext);
                super.execute((ICustomContext)new CustomContext(new PictogramElement[]{newCompositeShape}));
            } else {
                super.execute(context);
            }
        }
    }
}

