/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.databinding;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.jface.databinding.viewers.IViewerObservable;
import org.eclipse.jface.internal.databinding.swt.WidgetListenerUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class SWTValueUpdater
implements Listener,
IDisposeListener,
IValueChangeListener {
    private Control _control;
    private final Binding _binding;
    private final IObservable _target;
    private boolean _dirty;
    private boolean _updating;

    public static Binding attach(Binding binding) {
        new SWTValueUpdater(binding);
        return binding;
    }

    private SWTValueUpdater(Binding binding) {
        this._binding = binding;
        this._target = this._binding.getTarget();
        if (this._target instanceof ISWTObservable && ((ISWTObservable)this._binding.getTarget()).getWidget() instanceof Control) {
            this._control = (Control)((ISWTObservable)this._binding.getTarget()).getWidget();
        } else if (this._target instanceof IViewerObservable) {
            this._control = ((IViewerObservable)this._target).getViewer().getControl();
        } else {
            throw new IllegalArgumentException("target of binding must be an ISWTObservable whose widget is a Control.");
        }
        this.addListeners();
    }

    private void addListeners() {
        WidgetListenerUtil.asyncAddListener((Widget)this._control, (int)2, (Listener)this);
        WidgetListenerUtil.asyncAddListener((Widget)this._control, (int)16, (Listener)this);
        WidgetListenerUtil.asyncAddListener((Widget)this._control, (int)15, (Listener)this);
        WidgetListenerUtil.asyncAddListener((Widget)this._control, (int)14, (Listener)this);
        WidgetListenerUtil.asyncAddListener((Widget)this._control, (int)13, (Listener)this);
        WidgetListenerUtil.asyncAddListener((Widget)this._control, (int)12, (Listener)this);
        this._target.addDisposeListener((IDisposeListener)this);
        ((IObservableValue)this._target).addValueChangeListener((IValueChangeListener)this);
    }

    public void handleEvent(Event event) {
        if (this._updating) {
            return;
        }
        if (event.type == 2) {
            if (event.keyCode == 27) {
                if (this._binding.isDisposed()) {
                    this.dispose();
                    return;
                }
                this._updating = true;
                try {
                    this._binding.updateModelToTarget();
                }
                finally {
                    this._updating = false;
                }
                if (this._control instanceof Text) {
                    ((Text)this._control).setSelection(0, ((Text)this._control).getCharCount());
                }
                this._dirty = false;
            }
        } else if (event.type == 16 || event.type == 14 || event.type == 13) {
            if (this._binding.isDisposed()) {
                this.dispose();
                return;
            }
            if (((IStatus)this._binding.getValidationStatus().getValue()).getSeverity() == 4) {
                this._control.setFocus();
                return;
            }
            if (this._dirty) {
                this._updating = true;
                try {
                    this._binding.updateTargetToModel();
                }
                finally {
                    this._updating = false;
                }
                this._dirty = false;
            }
        } else if (event.type == 15) {
            this._dirty = false;
        } else if (event.type == 12) {
            this.dispose();
        }
    }

    public void handleValueChange(ValueChangeEvent event) {
        if (this._updating) {
            return;
        }
        this._dirty = true;
    }

    public void handleDispose(DisposeEvent event) {
        this.dispose();
    }

    private synchronized void dispose() {
        if (this._control != null) {
            WidgetListenerUtil.asyncRemoveListener((Widget)this._control, (int)2, (Listener)this);
            WidgetListenerUtil.asyncRemoveListener((Widget)this._control, (int)16, (Listener)this);
            WidgetListenerUtil.asyncRemoveListener((Widget)this._control, (int)15, (Listener)this);
            WidgetListenerUtil.asyncRemoveListener((Widget)this._control, (int)14, (Listener)this);
            WidgetListenerUtil.asyncRemoveListener((Widget)this._control, (int)13, (Listener)this);
            WidgetListenerUtil.asyncRemoveListener((Widget)this._control, (int)12, (Listener)this);
            this._control = null;
            this._target.removeDisposeListener((IDisposeListener)this);
            ((IObservableValue)this._target).removeValueChangeListener((IValueChangeListener)this);
        }
    }
}

