/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.rules;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.switchyard.tools.models.switchyard1_0.rules.ResourceDetailType;
import org.switchyard.tools.models.switchyard1_0.rules.ResourceType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesFactory;
import org.switchyard.tools.models.switchyard1_0.rules.RulesImplementationType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.rules.ResourceDetailInputDialog;
import org.switchyard.tools.ui.editor.diagram.shared.TableColumnLayout;

public class RulesResourceTable
extends Composite {
    private TableViewer _propertyTreeTable;
    public static final String LOCATION_COLUMN = "location";
    public static final String TYPE_COLUMN = "type";
    private static final String[] TREE_COLUMNS = new String[]{"location", "type"};
    private Button _mAddButton;
    private Button _mRemoveButton;
    private Button _mAdvancedButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private String _mWarning = null;
    private ListenerList _changeListeners;
    private String[] _resourceTypeList = new String[]{"BPMN", "BPMN2", "BRL", "DESCR", "DRF", "DRL", "DSL", "DSLR", "DTABLE", "PMML", "PKG", "WID", "XDRL"};

    public RulesResourceTable(Composite parent, int style) {
        this(parent, style, false);
    }

    public RulesResourceTable(Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Composite tableComposite = new Composite((Composite)this, additionalStyles);
        GridData gd11 = new GridData(4, 4, true, true, 1, 3);
        gd11.heightHint = 100;
        tableComposite.setLayoutData((Object)gd11);
        this._propertyTreeTable = new TableViewer(tableComposite, 0x10A40 | additionalStyles);
        this._propertyTreeTable.getTable().setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        TableViewerColumn locationColumn = new TableViewerColumn(this._propertyTreeTable, 16384);
        locationColumn.getColumn().setText(Messages.label_resource);
        tableLayout.setColumnData((Widget)locationColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(300, 150, true));
        locationColumn.setEditingSupport((EditingSupport)new ResourceColumnEditingSupport(this._propertyTreeTable));
        TableViewerColumn typeColumn = new TableViewerColumn(this._propertyTreeTable, 16384);
        typeColumn.getColumn().setText(Messages.label_type);
        typeColumn.setEditingSupport((EditingSupport)new TypeColumnEditingSupport(this._propertyTreeTable));
        tableLayout.setColumnData((Widget)typeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 50, true));
        this._propertyTreeTable.setColumnProperties(TREE_COLUMNS);
        this._propertyTreeTable.setLabelProvider((IBaseLabelProvider)new PropertyTreeLabelProvider());
        this._propertyTreeTable.setContentProvider((IContentProvider)new PropertyTreeContentProvider());
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesResourceTable.this.addPropertyToList(true);
                if (RulesResourceTable.this._propertyTreeTable.getInput() == null) {
                    RulesResourceTable.this._propertyTreeTable.setInput((Object)RulesResourceTable.this._targetObj);
                }
                RulesResourceTable.this._propertyTreeTable.refresh();
                RulesResourceTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesResourceTable.this.updatePropertyButtons();
            }
        });
        this._mAdvancedButton = new Button((Composite)this, 0);
        this._mAdvancedButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mAdvancedButton.setText(Messages.button_advanced);
        this._mAdvancedButton.setEnabled(false);
        this._mAdvancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int rtn = RulesResourceTable.this.handleAdvancedResourceDetails();
                if (rtn == 0) {
                    RulesResourceTable.this.fireChangedEvent(e.getSource());
                }
            }
        });
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesResourceTable.this.removeFromList();
                RulesResourceTable.this._propertyTreeTable.refresh();
                RulesResourceTable.this.fireChangedEvent(e.getSource());
            }
        });
        this.updatePropertyButtons();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected void addPropertyToList(boolean isRules) {
        if (this.getTargetObject() instanceof RulesImplementationType) {
            final RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
            final ResourceType newAction = RulesFactory.eINSTANCE.createResourceType();
            if (isRules) {
                newAction.setLocation("rules.drl");
                newAction.setType("DRL");
            } else {
                newAction.setLocation("process.bpmn2");
                newAction.setType("BPMN2");
            }
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)impl);
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        if (impl.getManifest() == null) {
                            impl.setManifest(RulesFactory.eINSTANCE.createManifestType());
                            impl.getManifest().setResources(RulesFactory.eINSTANCE.createResourcesType());
                        } else if (impl.getManifest().getResources() == null) {
                            impl.getManifest().setResources(RulesFactory.eINSTANCE.createResourcesType());
                        }
                        impl.getManifest().getResources().getResource().add((Object)newAction);
                        RulesResourceTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                if (impl.getManifest() == null) {
                    impl.setManifest(RulesFactory.eINSTANCE.createManifestType());
                    impl.getManifest().setResources(RulesFactory.eINSTANCE.createResourcesType());
                } else if (impl.getManifest().getResources() == null) {
                    impl.getManifest().setResources(RulesFactory.eINSTANCE.createResourcesType());
                }
                impl.getManifest().getResources().getResource().add((Object)newAction);
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    private String getNullOrValue(String input) {
        if (input != null) {
            if (input.trim().isEmpty()) {
                return null;
            }
            return input;
        }
        return null;
    }

    protected int handleAdvancedResourceDetails() {
        if (this.getTargetObject() instanceof RulesImplementationType) {
            int rtn_code;
            RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
            final ResourceType resourceToAddDetailsTo = this.getTableSelection();
            final ResourceDetailInputDialog dialog = new ResourceDetailInputDialog(this.getShell());
            dialog.setResourceType(resourceToAddDetailsTo);
            if (resourceToAddDetailsTo.getResourceDetail() != null) {
                if (resourceToAddDetailsTo.getResourceDetail().getInputType() != null) {
                    dialog.setInputType(resourceToAddDetailsTo.getResourceDetail().getInputType());
                }
                if (resourceToAddDetailsTo.getResourceDetail().getWorksheetName() != null) {
                    dialog.setWorksheetName(resourceToAddDetailsTo.getResourceDetail().getWorksheetName());
                }
                if (resourceToAddDetailsTo.getResourceDetail().isSetUsingExternalTypes()) {
                    dialog.setUsingExternalTypes(resourceToAddDetailsTo.getResourceDetail().isUsingExternalTypes());
                }
            }
            if ((rtn_code = dialog.open()) == 0) {
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)impl);
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            ResourceDetailType detailType = null;
                            if (resourceToAddDetailsTo.getResourceDetail() == null) {
                                detailType = RulesFactory.eINSTANCE.createResourceDetailType();
                                resourceToAddDetailsTo.setResourceDetail(detailType);
                            } else {
                                detailType = resourceToAddDetailsTo.getResourceDetail();
                            }
                            boolean inputTypeIsEmpty = false;
                            detailType.setInputType(RulesResourceTable.this.getNullOrValue(dialog.getInputType()));
                            if (detailType.getInputType() == null || detailType.getInputType().trim().isEmpty()) {
                                inputTypeIsEmpty = true;
                            }
                            boolean worksheetNameIsEmpty = false;
                            detailType.setWorksheetName(RulesResourceTable.this.getNullOrValue(dialog.getWorksheetName()));
                            if (detailType.getWorksheetName() == null || detailType.getWorksheetName().trim().isEmpty()) {
                                worksheetNameIsEmpty = true;
                            }
                            boolean usesExternalTypesIsDefault = true;
                            if (dialog.getUsingExternalTypes()) {
                                usesExternalTypesIsDefault = false;
                                detailType.setUsingExternalTypes(dialog.getUsingExternalTypes());
                            } else {
                                detailType.unsetUsingExternalTypes();
                            }
                            if (inputTypeIsEmpty && worksheetNameIsEmpty && usesExternalTypesIsDefault) {
                                resourceToAddDetailsTo.setResourceDetail(null);
                            }
                            RulesResourceTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    ResourceDetailType detailType = null;
                    if (resourceToAddDetailsTo.getResourceDetail() == null) {
                        detailType = RulesFactory.eINSTANCE.createResourceDetailType();
                        resourceToAddDetailsTo.setResourceDetail(detailType);
                    } else {
                        detailType = resourceToAddDetailsTo.getResourceDetail();
                    }
                    boolean inputTypeIsEmpty = false;
                    detailType.setInputType(this.getNullOrValue(dialog.getInputType()));
                    if (detailType.getInputType() == null || detailType.getInputType().trim().isEmpty()) {
                        inputTypeIsEmpty = true;
                    }
                    boolean worksheetNameIsEmpty = false;
                    detailType.setWorksheetName(this.getNullOrValue(dialog.getWorksheetName()));
                    if (detailType.getWorksheetName() == null || detailType.getWorksheetName().trim().isEmpty()) {
                        worksheetNameIsEmpty = true;
                    }
                    boolean usesExternalTypesIsDefault = true;
                    if (dialog.getUsingExternalTypes()) {
                        usesExternalTypesIsDefault = false;
                        detailType.setUsingExternalTypes(dialog.getUsingExternalTypes());
                    } else {
                        detailType.unsetUsingExternalTypes();
                    }
                    if (inputTypeIsEmpty && worksheetNameIsEmpty && usesExternalTypesIsDefault) {
                        resourceToAddDetailsTo.setResourceDetail(null);
                    }
                    this.getTableViewer().refresh(true);
                }
                this.fireChangedEvent((Object)this);
            }
            return rtn_code;
        }
        return 1;
    }

    protected void removeFromList() {
        if (this.getTargetObject() instanceof RulesImplementationType) {
            final RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
            final ResourceType actionToRemove = this.getTableSelection();
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)impl);
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        impl.getManifest().getResources().getResource().remove((Object)actionToRemove);
                        if (impl.getManifest().getResources().getResource().isEmpty()) {
                            impl.getManifest().setResources(null);
                        }
                        RulesResourceTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                impl.getManifest().getResources().getResource().remove((Object)actionToRemove);
                if (impl.getManifest().getResources().getResource().isEmpty()) {
                    impl.getManifest().setResources(null);
                }
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected ResourceType getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof ResourceType) {
            return (ResourceType)ssel.getFirstElement();
        }
        return null;
    }

    public void updatePropertyButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
            this._mAdvancedButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            this._mRemoveButton.setEnabled(false);
            this._mAdvancedButton.setEnabled(false);
            if (this.getTableSelection() != null) {
                String rType;
                this._mRemoveButton.setEnabled(true);
                if (this.getTableSelection().getType() != null && (rType = this.getTableSelection().getType()).equalsIgnoreCase("DTABLE")) {
                    this._mAdvancedButton.setEnabled(true);
                }
            }
        }
    }

    public String getWarning() {
        return this._mWarning;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
        this._propertyTreeTable.setInput((Object)target);
        this.updatePropertyButtons();
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    protected TableViewer getTableViewer() {
        return this._propertyTreeTable;
    }

    private class PropertyTreeContentProvider
    implements IStructuredContentProvider {
        private PropertyTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            RulesImplementationType bpmImpl;
            if (inputElement instanceof RulesImplementationType && (bpmImpl = (RulesImplementationType)inputElement).getManifest() != null && bpmImpl.getManifest().getResources() != null) {
                return bpmImpl.getManifest().getResources().getResource().toArray();
            }
            return new Object[0];
        }
    }

    private class PropertyTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof ResourceType && property.equalsIgnoreCase(RulesResourceTable.LOCATION_COLUMN)) {
                return true;
            }
            return element instanceof ResourceType && property.equalsIgnoreCase(RulesResourceTable.TYPE_COLUMN);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ResourceType && columnIndex == 0) {
                return ((ResourceType)element).getLocation();
            }
            if (element instanceof ResourceType && columnIndex == 1) {
                return ((ResourceType)element).getType();
            }
            return null;
        }
    }

    private class ResourceColumnEditingSupport
    extends EditingSupport {
        public ResourceColumnEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof ResourceType) {
                return new TextCellEditor((Composite)RulesResourceTable.this._propertyTreeTable.getTable());
            }
            return null;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            if (element instanceof ResourceType) {
                ResourceType resType = (ResourceType)element;
                return resType.getLocation();
            }
            return null;
        }

        protected void setValue(final Object element, final Object value) {
            TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((Object)element);
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    ResourceType parm = (ResourceType)element;
                    String strVal = (String)value;
                    parm.setLocation(strVal);
                }
            });
            RulesResourceTable.this.fireChangedEvent(RulesResourceTable.this._propertyTreeTable);
            RulesResourceTable.this.getTableViewer().refresh(true);
        }
    }

    private class TypeColumnEditingSupport
    extends EditingSupport {
        public TypeColumnEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof ResourceType) {
                return new ComboBoxCellEditor((Composite)RulesResourceTable.this._propertyTreeTable.getTable(), RulesResourceTable.this._resourceTypeList, 8);
            }
            return null;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            if (element instanceof ResourceType) {
                ResourceType resType = (ResourceType)element;
                String resTypeStr = resType.getType();
                int i = 0;
                while (i < RulesResourceTable.this._resourceTypeList.length) {
                    String array_element = RulesResourceTable.this._resourceTypeList[i];
                    if (array_element.equalsIgnoreCase(resTypeStr)) {
                        return i;
                    }
                    ++i;
                }
                return 0;
            }
            return null;
        }

        protected void setValue(final Object element, final Object value) {
            TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((Object)element);
            domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                protected void doExecute() {
                    ResourceType parm = (ResourceType)element;
                    Integer intVal = (Integer)value;
                    parm.setType(RulesResourceTable.this._resourceTypeList[intVal]);
                }
            });
            RulesResourceTable.this.fireChangedEvent(RulesResourceTable.this._propertyTreeTable);
            RulesResourceTable.this.getTableViewer().refresh(true);
            RulesResourceTable.this.updatePropertyButtons();
        }
    }
}

