/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.rules;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.switchyard.tools.models.switchyard1_0.rules.ContainerType;
import org.switchyard.tools.models.switchyard1_0.rules.ManifestType;
import org.switchyard.tools.models.switchyard1_0.rules.ResourceType;
import org.switchyard.tools.models.switchyard1_0.rules.ResourcesType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesFactory;
import org.switchyard.tools.models.switchyard1_0.rules.RulesImplementationType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.rules.KIEContainerDetailsComposite;
import org.switchyard.tools.ui.editor.components.rules.NewRulesComponentWizard;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class RulesImplementationWizardPage
extends WizardPage {
    private Component _component;
    private ComponentService _serviceInterface;
    private Link _newRulesLink;
    private Text _rulesFileText;
    private Button _browseRulesButton;
    private IJavaProject _project;
    private RulesImplementationType _implementation;
    private ResourcesType _resources = RulesFactory.eINSTANCE.createResourcesType();
    private ContainerType _container = RulesFactory.eINSTANCE.createContainerType();
    private ComponentService _service;

    public RulesImplementationWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.title_rulesImplementationDetails);
        this.setDescription(Messages.description_rulesImplementationDetails);
        this.setPageComplete(false);
    }

    public RulesImplementationType getImplementation() {
        return this._implementation;
    }

    public ComponentService getService() {
        return this._service;
    }

    public void init(Component component) {
        this._component = component;
        if (component == null) {
            return;
        }
        IProject project = PlatformResourceAdapterFactory.getContainingProject((Object)component);
        IJavaProject iJavaProject = this._project = project == null ? null : JavaCore.create((IProject)project);
        if (component.getService() == null) {
            return;
        }
        Iterator iterator = component.getService().iterator();
        if (iterator.hasNext()) {
            ComponentService service;
            this._serviceInterface = service = (ComponentService)iterator.next();
            return;
        }
    }

    public void createControl(org.eclipse.swt.widgets.Composite parent) {
        org.eclipse.swt.widgets.Composite contents = new org.eclipse.swt.widgets.Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        TabbedPropertySheetWidgetFactory factory = new TabbedPropertySheetWidgetFactory();
        FormColors colors = factory.getColors();
        colors.setBackground(null);
        colors.setForeground(null);
        org.eclipse.swt.widgets.Composite resourceButtonsComposite = factory.createComposite(contents);
        resourceButtonsComposite.setLayout((Layout)new RowLayout());
        resourceButtonsComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        final StackLayout manifestLayout = new StackLayout();
        final Button resourcesRadio = factory.createButton(resourceButtonsComposite, Messages.label_projectResource, 16);
        Button containerRadio = factory.createButton(resourceButtonsComposite, Messages.label_knowledgeContainer, 16);
        org.eclipse.swt.widgets.Composite resourceDetailsComposite = factory.createComposite(contents);
        resourceDetailsComposite.setLayout((Layout)manifestLayout);
        resourceDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        final org.eclipse.swt.widgets.Composite resourceControls = this.createResourceControls(resourceDetailsComposite);
        final KIEContainerDetailsComposite containerControls = new KIEContainerDetailsComposite(resourceDetailsComposite, (FormToolkit)factory);
        containerControls.setContainer(this._container);
        resourcesRadio.setSelection(true);
        manifestLayout.topControl = resourceControls;
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (RulesImplementationWizardPage.this._implementation == null) {
                    RulesImplementationWizardPage.this._implementation = RulesFactory.eINSTANCE.createRulesImplementationType();
                }
                if (RulesImplementationWizardPage.this._implementation.getManifest() == null) {
                    RulesImplementationWizardPage.this._implementation.setManifest(RulesFactory.eINSTANCE.createManifestType());
                }
                if (resourcesRadio.getSelection()) {
                    manifestLayout.topControl = resourceControls;
                    resourceControls.getParent().layout();
                    RulesImplementationWizardPage.this._implementation.getManifest().setContainer(null);
                    RulesImplementationWizardPage.this._implementation.getManifest().setResources(RulesImplementationWizardPage.this._resources);
                } else {
                    manifestLayout.topControl = containerControls;
                    containerControls.getParent().layout();
                    RulesImplementationWizardPage.this._implementation.getManifest().setResources(null);
                    RulesImplementationWizardPage.this._implementation.getManifest().setContainer(RulesImplementationWizardPage.this._container);
                }
                RulesImplementationWizardPage.this.validate();
            }
        };
        resourcesRadio.addSelectionListener((SelectionListener)radioListener);
        containerRadio.addSelectionListener((SelectionListener)radioListener);
        this.setControl((Control)contents);
    }

    private org.eclipse.swt.widgets.Composite createResourceControls(org.eclipse.swt.widgets.Composite parent) {
        org.eclipse.swt.widgets.Composite contents = new org.eclipse.swt.widgets.Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        contents.setLayoutData((Object)new GridData(4, 128, true, false));
        this._newRulesLink = new Link(contents, 0);
        this._newRulesLink.setText(Messages.link_rulesFile);
        this._newRulesLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulesImplementationWizardPage.this.openNewWizard();
            }
        });
        this._rulesFileText = new Text(contents, 2056);
        this._rulesFileText.setLayoutData((Object)new GridData(768));
        this._rulesFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                RulesImplementationWizardPage.this.validate();
            }
        });
        this._browseRulesButton = new Button(contents, 8);
        this._browseRulesButton.setText(Messages.button_browse);
        this._browseRulesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RulesImplementationWizardPage.this.handleBrowse();
            }
        });
        return contents;
    }

    private void validate() {
        this.setErrorMessage(null);
        if (this._implementation == null) {
            this.setErrorMessage(Messages.error_noRulesFile);
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private void handleBrowse() {
        Object[] result;
        Object container = this._project == null ? ResourcesPlugin.getWorkspace().getRoot() : this._project.getProject();
        ClasspathResourceSelectionDialog dialog = new ClasspathResourceSelectionDialog(this.getShell(), (IContainer)container, "drl");
        dialog.setInitialPattern("*.drl");
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IResource) {
            IResource rulesFile = (IResource)result[0];
            String rulesFilePath = JavaUtil.getJavaPathForResource((IResource)rulesFile).toString();
            this._implementation = RulesFactory.eINSTANCE.createRulesImplementationType();
            ManifestType manifest = RulesFactory.eINSTANCE.createManifestType();
            ResourceType resource = NewRulesComponentWizard.createRulesResource(rulesFilePath);
            this._resources.getResource().clear();
            this._resources.getResource().add((Object)resource);
            manifest.setResources(this._resources);
            this._implementation.setManifest(manifest);
            this._service = null;
            this._rulesFileText.setText(rulesFilePath);
        }
    }

    private void openNewWizard() {
        NewRulesComponentWizard wizard = new NewRulesComponentWizard(false);
        SwitchyardSCAEditor editor = SwitchyardSCAEditor.getActiveEditor();
        IResource resource = JavaUtil.getFirstResourceRoot((IJavaProject)this._project);
        StructuredSelection selection = resource == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)resource);
        IWorkbench workbench = editor == null ? PlatformUI.getWorkbench() : editor.getEditorSite().getWorkbenchWindow().getWorkbench();
        wizard.init(workbench, (IStructuredSelection)selection);
        wizard.init(this._component == null ? null : (Composite)this._component.eContainer());
        wizard.forceServiceInterfaceType(this._serviceInterface);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this._implementation = (RulesImplementationType)wizard.getCreatedObject().getImplementation();
            this._service = wizard.getService();
            this._rulesFileText.setText(wizard.getCreatedFilePath());
            this._resources = this._implementation.getManifest().getResources();
        }
    }
}

