/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.rules;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.switchyard.tools.models.switchyard1_0.rules.ChannelType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesFactory;
import org.switchyard.tools.models.switchyard1_0.rules.RulesImplementationType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.ClassDialogCellEditor;
import org.switchyard.tools.ui.editor.diagram.shared.TableColumnLayout;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class RulesChannelTable
extends Composite
implements ICellModifier {
    private TableViewer _propertyTreeTable;
    private static final String NAME_COLUMN = "name";
    private static final String OPERATION_COLUMN = "operation";
    private static final String REFERENCE_COLUMN = "reference";
    private static final String CLASS_COLUMN = "class";
    private static final String[] TREE_COLUMNS = new String[]{"name", "operation", "reference", "class"};
    private Button _mAddButton;
    private Button _mRemoveButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private String _mWarning = null;
    private ListenerList _changeListeners;

    public RulesChannelTable(Composite parent, int style) {
        this(parent, style, false);
    }

    public RulesChannelTable(Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Composite tableComposite = new Composite((Composite)this, additionalStyles);
        GridData gd11 = new GridData(4, 4, true, false, 1, 2);
        gd11.heightHint = 100;
        tableComposite.setLayoutData((Object)gd11);
        this._propertyTreeTable = new TableViewer(tableComposite, 0x10A40 | additionalStyles);
        this._propertyTreeTable.getTable().setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        TableColumn nameColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        nameColumn.setText(Messages.label_name);
        tableLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        TableColumn operationColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        operationColumn.setText(Messages.label_operation);
        tableLayout.setColumnData((Widget)operationColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        TableColumn referenceColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        referenceColumn.setText(Messages.label_reference);
        tableLayout.setColumnData((Widget)referenceColumn, (ColumnLayoutData)new ColumnWeightData(100, 150, true));
        TableColumn valueColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        valueColumn.setText(Messages.label_class);
        tableLayout.setColumnData((Widget)valueColumn, (ColumnLayoutData)new ColumnWeightData(200, 300, true));
        this._propertyTreeTable.setColumnProperties(TREE_COLUMNS);
        this._propertyTreeTable.setLabelProvider((IBaseLabelProvider)new PropertyTreeLabelProvider());
        this._propertyTreeTable.setContentProvider((IContentProvider)new PropertyTreeContentProvider());
        this._propertyTreeTable.setCellModifier((ICellModifier)this);
        this._propertyTreeTable.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this._propertyTreeTable.getTable()), new TextCellEditor((Composite)this._propertyTreeTable.getTable()), new TextCellEditor((Composite)this._propertyTreeTable.getTable()), new ClassDialogCellEditor((Composite)this._propertyTreeTable.getTable(), "org.kie.api.runtime.Channel", Messages.label_channel, Messages.tooltip_channel){

            @Override
            protected Resource getResource() {
                return RulesChannelTable.this._targetObj == null ? null : RulesChannelTable.this._targetObj.eResource();
            }
        }});
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesChannelTable.this.addPropertyToList();
                if (RulesChannelTable.this._propertyTreeTable.getInput() == null) {
                    RulesChannelTable.this._propertyTreeTable.setInput((Object)RulesChannelTable.this._targetObj);
                }
                RulesChannelTable.this._propertyTreeTable.refresh();
                RulesChannelTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesChannelTable.this.updatePropertyButtons();
            }
        });
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RulesChannelTable.this.removeFromList();
                RulesChannelTable.this._propertyTreeTable.refresh();
                RulesChannelTable.this.fireChangedEvent(e.getSource());
            }
        });
        this.updatePropertyButtons();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected void addPropertyToList() {
        if (this.getTargetObject() instanceof RulesImplementationType) {
            final RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
            final ChannelType newAction = RulesFactory.eINSTANCE.createChannelType();
            newAction.setName("ChannelName");
            newAction.setOperation("ChannelOperation");
            newAction.setReference("ChannelReference");
            newAction.setClass("NewChannel");
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        if (impl.getChannels() == null) {
                            impl.setChannels(RulesFactory.eINSTANCE.createChannelsType());
                        }
                        impl.getChannels().getChannel().add((Object)newAction);
                        RulesChannelTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                if (impl.getChannels() == null) {
                    impl.setChannels(RulesFactory.eINSTANCE.createChannelsType());
                }
                impl.getChannels().getChannel().add((Object)newAction);
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected void removeFromList() {
        if (this.getTargetObject() instanceof RulesImplementationType) {
            final RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
            final ChannelType actionToRemove = this.getTableSelection();
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        impl.getChannels().getChannel().remove((Object)actionToRemove);
                        if (impl.getChannels().getChannel().isEmpty()) {
                            impl.setChannels(null);
                        }
                        RulesChannelTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                impl.getChannels().getChannel().remove((Object)actionToRemove);
                if (impl.getChannels().getChannel().isEmpty()) {
                    impl.setChannels(null);
                }
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected ChannelType getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof ChannelType) {
            return (ChannelType)ssel.getFirstElement();
        }
        return null;
    }

    public void updatePropertyButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            if (this.getTableSelection() != null) {
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    public String getWarning() {
        return this._mWarning;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
        this._propertyTreeTable.setInput((Object)target);
        this.updatePropertyButtons();
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof ChannelType && property.equalsIgnoreCase(NAME_COLUMN)) {
            if (((ChannelType)element).getName() != null) {
                return ((ChannelType)element).getName();
            }
            return "";
        }
        if (element instanceof ChannelType && property.equalsIgnoreCase(OPERATION_COLUMN)) {
            if (((ChannelType)element).getOperation() != null) {
                return ((ChannelType)element).getOperation();
            }
            return "";
        }
        if (element instanceof ChannelType && property.equalsIgnoreCase(REFERENCE_COLUMN)) {
            if (((ChannelType)element).getReference() != null) {
                return ((ChannelType)element).getReference();
            }
            return "";
        }
        if (element instanceof ChannelType && property.equalsIgnoreCase(CLASS_COLUMN)) {
            if (((ChannelType)element).getClass_() != null) {
                return ((ChannelType)element).getClass_();
            }
            return "";
        }
        return null;
    }

    public void modify(Object element, String property, final Object value) {
        if (element instanceof TableItem && property.equalsIgnoreCase(NAME_COLUMN)) {
            TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof RulesImplementationType) {
                RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
                final ChannelType parm = (ChannelType)ti.getData();
                if (value == null && parm.getName() == null || value != null && value.equals(parm.getName())) {
                    return;
                }
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            parm.setName((String)value);
                            RulesChannelTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    parm.setName((String)value);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        } else if (element instanceof TableItem && property.equalsIgnoreCase(OPERATION_COLUMN)) {
            final TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof RulesImplementationType) {
                RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
                ChannelType parm = (ChannelType)ti.getData();
                if (value == null && parm.getOperation() == null || value != null && value.equals(parm.getOperation())) {
                    return;
                }
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            ChannelType parm = (ChannelType)ti.getData();
                            parm.setOperation((String)value);
                            RulesChannelTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    parm.setClass((String)value);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        } else if (element instanceof TableItem && property.equalsIgnoreCase(REFERENCE_COLUMN)) {
            final TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof RulesImplementationType) {
                RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
                ChannelType parm = (ChannelType)ti.getData();
                if (value == null && parm.getReference() == null || value != null && value.equals(parm.getReference())) {
                    return;
                }
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            ChannelType parm = (ChannelType)ti.getData();
                            parm.setReference((String)value);
                            RulesChannelTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    parm.setClass((String)value);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        } else if (element instanceof TableItem && property.equalsIgnoreCase(CLASS_COLUMN)) {
            final TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof RulesImplementationType) {
                RulesImplementationType impl = (RulesImplementationType)this.getTargetObject();
                ChannelType parm = (ChannelType)ti.getData();
                if (value == null && parm.getClass_() == null || value != null && value.equals(parm.getClass_())) {
                    return;
                }
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            ChannelType parm = (ChannelType)ti.getData();
                            parm.setClass((String)value);
                            RulesChannelTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    parm.setClass((String)value);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected TableViewer getTableViewer() {
        return this._propertyTreeTable;
    }

    private class PropertyTreeContentProvider
    implements IStructuredContentProvider {
        private PropertyTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            RulesImplementationType bpmImpl;
            if (inputElement instanceof RulesImplementationType && (bpmImpl = (RulesImplementationType)inputElement).getChannels() != null) {
                return bpmImpl.getChannels().getChannel().toArray();
            }
            return new Object[0];
        }
    }

    private class PropertyTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            if (element instanceof ChannelType && property.equalsIgnoreCase(RulesChannelTable.NAME_COLUMN)) {
                return true;
            }
            if (element instanceof ChannelType && property.equalsIgnoreCase(RulesChannelTable.OPERATION_COLUMN)) {
                return true;
            }
            if (element instanceof ChannelType && property.equalsIgnoreCase(RulesChannelTable.REFERENCE_COLUMN)) {
                return true;
            }
            return element instanceof ChannelType && property.equalsIgnoreCase(RulesChannelTable.CLASS_COLUMN);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ChannelType && columnIndex == 0) {
                return ((ChannelType)element).getName();
            }
            if (element instanceof ChannelType && columnIndex == 1) {
                return ((ChannelType)element).getOperation();
            }
            if (element instanceof ChannelType && columnIndex == 2) {
                return ((ChannelType)element).getReference();
            }
            if (element instanceof ChannelType && columnIndex == 3) {
                return ((ChannelType)element).getClass_();
            }
            return null;
        }
    }
}

