/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.rules;

import java.math.BigInteger;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.switchyard.tools.models.switchyard1_0.rules.LoggerType;
import org.switchyard.tools.models.switchyard1_0.rules.LoggerType1;
import org.switchyard.tools.models.switchyard1_0.rules.RulesFactory;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.editor.Messages;

public class NewRulesDetailsWizardPage
extends WizardPage {
    private String _packageName;
    private Text _packageNameText;
    private boolean _agent;
    private Button _agentCheckbox;
    private String _messageName;
    private Text _messageNameText;
    private boolean _auditingEnabled;
    private Button _auditingEnabledCheckbox;
    private LoggerType1 _auditSettings = RulesFactory.eINSTANCE.createLoggerType1();
    private Text _auditLogText;
    private Text _auditIntervalText;
    private ComboViewer _auditTypeList;
    private String _oldPackageName;

    public NewRulesDetailsWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.title_rulesImplementationDetails);
        this.setDescription(Messages.description_rulesImplementationDetails);
    }

    public void createControl(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(2, false));
        this.createLabel(contents, Messages.label_packageName);
        this._packageNameText = new Text(contents, 2052);
        this._packageNameText.setLayoutData((Object)new GridData(768));
        this._packageNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewRulesDetailsWizardPage.this._packageName = NewRulesDetailsWizardPage.this._packageNameText.getText();
                NewRulesDetailsWizardPage.this.validate();
            }
        });
        this.createLabel(contents, Messages.label_inputVariable);
        this._messageNameText = new Text(contents, 2052);
        this._messageNameText.setToolTipText(Messages.tooltip_inputVariable);
        this._messageNameText.setLayoutData((Object)new GridData(768));
        this._messageNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewRulesDetailsWizardPage.this._messageName = NewRulesDetailsWizardPage.this._messageNameText.getText();
                NewRulesDetailsWizardPage.this.validate();
            }
        });
        this.createAuditSettingsGroup(contents);
        this.initControls();
        this.validate();
        this.setErrorMessage(null);
        this.setControl((Control)contents);
    }

    private void createAuditSettingsGroup(Composite contents) {
        Group auditSettingsGroup = new Group(contents, 0);
        auditSettingsGroup.setLayout((Layout)new GridLayout(2, false));
        auditSettingsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        auditSettingsGroup.setText(Messages.label_auditSettings);
        this._auditingEnabledCheckbox = new Button((Composite)auditSettingsGroup, 32);
        this._auditingEnabledCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._auditingEnabledCheckbox.setText(Messages.label_enableAuditing);
        this._auditingEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewRulesDetailsWizardPage.this._auditingEnabled = NewRulesDetailsWizardPage.this._auditingEnabledCheckbox.getSelection();
                NewRulesDetailsWizardPage.this.updateAuditControls();
                NewRulesDetailsWizardPage.this.validate();
            }
        });
        this.createLabel((Composite)auditSettingsGroup, Messages.label_logName);
        this._auditLogText = new Text((Composite)auditSettingsGroup, 2052);
        this._auditLogText.setLayoutData((Object)new GridData(768));
        this._auditLogText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewRulesDetailsWizardPage.this._auditSettings.setLog(NewRulesDetailsWizardPage.this.nullForEmpty(NewRulesDetailsWizardPage.this._auditLogText.getText()));
                NewRulesDetailsWizardPage.this.validate();
            }
        });
        this.createLabel((Composite)auditSettingsGroup, Messages.label_interval);
        this._auditIntervalText = new Text((Composite)auditSettingsGroup, 2052);
        this._auditIntervalText.setLayoutData((Object)new GridData(768));
        this._auditIntervalText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    NewRulesDetailsWizardPage.this._auditSettings.setInterval((Object)BigInteger.valueOf(Integer.parseInt(NewRulesDetailsWizardPage.this._auditIntervalText.getText())));
                }
                catch (NumberFormatException e) {
                    e.fillInStackTrace();
                }
                NewRulesDetailsWizardPage.this.validate();
            }
        });
        this.createLabel((Composite)auditSettingsGroup, Messages.label_logType);
        this._auditTypeList = new ComboViewer((Composite)auditSettingsGroup, 4);
        this._auditTypeList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof LoggerType) {
                    return ((LoggerType)element).getLiteral();
                }
                return super.getText(element);
            }
        });
        this._auditTypeList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._auditTypeList.setInput((Object)LoggerType.values());
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    public String getPackageName() {
        return this.emptyForNull(this._packageName);
    }

    public void setPackageName(String packageName) {
        if (this._packageNameText == null) {
            this._packageName = packageName;
        } else {
            this._packageNameText.setText(packageName);
        }
    }

    public boolean isAgent() {
        return this._agent;
    }

    public void setAgent(boolean agent) {
        if (this._agentCheckbox == null) {
            this._agent = agent;
        } else {
            this._agentCheckbox.setSelection(agent);
        }
    }

    public String getMessageName() {
        return this.nullForEmpty(this._messageName);
    }

    public void setMessageName(String messageName) {
        if (this._messageNameText == null) {
            this._messageName = messageName;
        } else {
            this._messageNameText.setText(messageName);
        }
    }

    public boolean isAuditingEnabled() {
        return this._auditingEnabled;
    }

    public void setAuditingEnabled(boolean auditingEnabled) {
        if (this._auditingEnabledCheckbox == null) {
            this._auditingEnabled = auditingEnabled;
        } else {
            this._auditingEnabledCheckbox.setSelection(auditingEnabled);
            this.updateAuditControls();
        }
    }

    public LoggerType1 getAuditSettings() {
        return this._auditSettings;
    }

    public void setAuditSettings(LoggerType1 auditSettings) {
        if (this._auditingEnabledCheckbox == null) {
            this._auditSettings = auditSettings;
        } else {
            this._auditLogText.setText(this.emptyForNull(auditSettings.getLog()));
            this._auditIntervalText.setText(auditSettings.getInterval() == null ? "" : auditSettings.getInterval().toString());
            this._auditTypeList.setSelection((ISelection)new StructuredSelection((Object)auditSettings.getType()), true);
        }
    }

    public void update(IJavaProject project) {
        IJavaElement element;
        String newPackageName = project == null ? "" : ((element = JavaUtil.getInitialPackageForProject((IJavaProject)project)).getElementType() == 4 ? ((IPackageFragment)element).getElementName() : "");
        if (this.updateDefault(this._oldPackageName, newPackageName, this._packageNameText.getText())) {
            this.setPackageName(newPackageName);
        }
        this._oldPackageName = newPackageName;
    }

    private boolean updateDefault(String oldValue, String newValue, String currentValue) {
        return !currentValue.equals(newValue) && (oldValue == null || oldValue.length() == 0 || currentValue.length() == 0 || oldValue.equals(currentValue));
    }

    private String emptyForNull(String string) {
        return string == null ? "" : string;
    }

    private String nullForEmpty(String string) {
        return string == null ? null : (string.length() == 0 ? null : string);
    }

    private void initControls() {
        this.setAuditSettings(this._auditSettings == null ? RulesFactory.eINSTANCE.createLoggerType1() : this._auditSettings);
        this.setAuditingEnabled(this._auditingEnabled);
        this.setPackageName(this.emptyForNull(this._packageName));
    }

    private void validate() {
        String intervalText;
        this.setErrorMessage(null);
        if (this.isAuditingEnabled() && (intervalText = this._auditIntervalText.getText()).length() != 0) {
            try {
                Integer.parseInt(intervalText);
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(e.getLocalizedMessage());
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private void updateAuditControls() {
        this._auditIntervalText.setEnabled(this._auditingEnabled);
        this._auditLogText.setEnabled(this._auditingEnabled);
        this._auditTypeList.getControl().setEnabled(this._auditingEnabled);
    }
}

