/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.resteasy;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.resteasy.RESTBindingType;
import org.switchyard.tools.models.switchyard1_0.resteasy.ResteasyPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.resteasy.DelimitedStringList;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyIntegerValidator;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;

public class ResteasyBindingComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private Text _nameText;
    private Text _mAddressURLText;
    private Text _contextPathText = null;
    private DelimitedStringList _interfacesList = null;
    private RESTBindingType _binding = null;
    private Text _requestTimeoutText = null;
    private WritableValue _bindingValue;

    ResteasyBindingComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_restBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_restBindingDetails;
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getResteasyControl(this._panel);
        this.bindControls(context);
    }

    private Control getResteasyControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        if (this.getTargetObject() instanceof Reference) {
            this._mAddressURLText = this.createLabelAndText(composite, Messages.label_address);
            this._mAddressURLText.setEnabled(this.canEdit());
            this._requestTimeoutText = this.createLabelAndText(composite, Messages.label_requestTimeout);
            this._requestTimeoutText.setEnabled(this.canEdit());
        } else {
            this._contextPathText = this.createLabelAndText(composite, Messages.label_contextPath);
            this._contextPathText.setEnabled(this.canEdit());
        }
        Label interfacesLabel = new Label(composite, 0);
        interfacesLabel.setText(Messages.label_restfulInterfaces);
        interfacesLabel.setLayoutData((Object)new GridData(4, 1, false, false, 2, 1));
        this._interfacesList = new DelimitedStringList(composite, 0, !this.canEdit());
        GridData ilGD = new GridData(768);
        ilGD.horizontalSpan = 2;
        this._interfacesList.setLayoutData(ilGD);
        return composite;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    public void setBinding(Binding switchYardBindingType) {
        super.setBinding(switchYardBindingType);
        if (switchYardBindingType instanceof RESTBindingType) {
            this.setTargetObject(switchYardBindingType.eContainer());
            this._binding = (RESTBindingType)switchYardBindingType;
            this._bindingValue.setValue((Object)this._binding);
            if (this._interfacesList != null && !this._interfacesList.isDisposed() && this._binding.getInterfaces() != null) {
                this._interfacesList.setSelection(this._binding.getInterfaces());
            }
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, RESTBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("REST binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("REST binding name cannot be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        if (this.getTargetObject() instanceof Reference) {
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._mAddressURLText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ResteasyPackage.Literals.REST_BINDING_TYPE__ADDRESS), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._requestTimeoutText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ResteasyPackage.Literals.REST_BINDING_TYPE__TIMEOUT), new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidator("Request Timeout must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        } else {
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._contextPathText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ResteasyPackage.Literals.REST_BINDING_TYPE__CONTEXT_PATH), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        }
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._interfacesList.getHiddenText(), (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ResteasyPackage.Literals.REST_BINDING_TYPE__INTERFACES), new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator(Messages.error_noRestInterfaceOrClass)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }
}

