/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.switchyard.tools.models.switchyard1_0.jca.ActivationSpec;
import org.switchyard.tools.models.switchyard1_0.jca.Endpoint;
import org.switchyard.tools.models.switchyard1_0.jca.JCABinding;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundConnection;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundInteraction;
import org.switchyard.tools.models.switchyard1_0.jca.Property;
import org.switchyard.tools.models.switchyard1_0.jca.ResourceAdapter;
import org.switchyard.tools.ui.editor.components.jca.IJCAResourceAdapterExtension;

public abstract class AbstractResourceAdapterExtension
implements IJCAResourceAdapterExtension {
    @Override
    public boolean isDefault() {
        return false;
    }

    @Override
    public int score(JCABinding binding) {
        if (binding == null) {
            return 0;
        }
        if (binding.getInboundConnection() != null) {
            return this.inboundConnectionScore(binding) + this.inboundInteractionScore(binding);
        }
        if (binding.getOutboundConnection() != null) {
            return this.outboundConnectionScore(binding) + this.outboundInteractionScore(binding);
        }
        return 0;
    }

    private int inboundConnectionScore(JCABinding binding) {
        ActivationSpec activationSpec;
        int score = 0;
        JCAInboundConnection connection = binding.getInboundConnection();
        if (connection == null) {
            return score;
        }
        IJCAResourceAdapterExtension.IInboundConnectionSettings settings = this.getInboundConnectionSettings();
        if (settings == null) {
            return score;
        }
        ResourceAdapter ra = connection.getResourceAdapter();
        if (ra != null) {
            if (settings.getResourceAdapterName() != null && settings.getResourceAdapterName().equals(ra.getName())) {
                ++score;
            }
            score += this.scoreProperties((List<Property>)ra.getProperty(), settings.getResourceAdapterProperties());
        }
        if ((activationSpec = connection.getActivationSpec()) != null) {
            score += this.scoreProperties((List<Property>)activationSpec.getProperty(), settings.getActivationSpecProperties());
        }
        return score;
    }

    private int inboundInteractionScore(JCABinding binding) {
        Endpoint endpoint;
        int score = 0;
        JCAInboundInteraction interaction = binding.getInboundInteraction();
        if (interaction == null) {
            return score;
        }
        IJCAResourceAdapterExtension.IInboundInteractionSettings settings = this.getInboundInteractionSettings();
        if (settings == null) {
            return score;
        }
        if (settings.getListenerType() != null && settings.getListenerType().equals(interaction.getListener())) {
            ++score;
        }
        if (settings.isTransacted() != null && interaction.isSetTransacted() && settings.isTransacted().booleanValue() == interaction.isTransacted()) {
            ++score;
        }
        if ((endpoint = interaction.getEndpoint()) != null) {
            if (settings.getEndpointType() != null && settings.getEndpointType().equals(endpoint.getType())) {
                ++score;
            }
            score += this.scoreProperties((List<Property>)endpoint.getProperty(), settings.getEndpointProperties());
        }
        return score;
    }

    private int outboundConnectionScore(JCABinding binding) {
        return 0;
    }

    private int outboundInteractionScore(JCABinding binding) {
        return 0;
    }

    private int scoreProperties(List<Property> properties, Map<String, String> defaults) {
        int score = 0;
        if (properties == null || defaults == null) {
            return score;
        }
        defaults = new HashMap<String, String>(defaults);
        for (Property property : properties) {
            if (property.getName() == null) continue;
            String value = defaults.get(property.getName());
            ++score;
            if (value == null || !value.equals(property.getValue())) continue;
            ++score;
        }
        return score;
    }
}

