/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.jca.ActivationSpec;
import org.switchyard.tools.models.switchyard1_0.jca.BatchCommit;
import org.switchyard.tools.models.switchyard1_0.jca.Endpoint;
import org.switchyard.tools.models.switchyard1_0.jca.JCABinding;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundConnection;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundInteraction;
import org.switchyard.tools.models.switchyard1_0.jca.JcaFactory;
import org.switchyard.tools.models.switchyard1_0.jca.Property;
import org.switchyard.tools.models.switchyard1_0.jca.ResourceAdapter;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.shared.ModelOperation;

public abstract class AbstractJCABindingComposite
extends AbstractSYBindingComposite {
    private JCABinding _binding = null;

    public AbstractJCABindingComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public void setBinding(Binding impl) {
        this._binding = impl instanceof JCABinding ? (JCABinding)impl : null;
        this.addObservableListeners();
    }

    @Override
    protected boolean validate() {
        this.setErrorMessage(null);
        return this.getErrorMessage() == null;
    }

    public boolean isValid() {
        return this.validate();
    }

    protected String getResourceAdapterPropertyValue(ActivationSpec as, String propertyName) {
        if (as != null && as.getProperty() != null && as.getProperty().size() > 0) {
            for (Property current : as.getProperty()) {
                if (!current.getName().equals(propertyName)) continue;
                return (String)current.getValue();
            }
        }
        return null;
    }

    protected void updateInboundConnectionFeature(String featureId, Object value) {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new InboundConnectionOp());
        ops.add(new AbstractSYBindingComposite.BasicOperation("inboundConnection", featureId, value));
        this.wrapOperation(ops);
    }

    protected void updateInboundInteractionFeature(String featureId, Object value) {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new InboundInteractionOp());
        ops.add(new AbstractSYBindingComposite.BasicOperation("inboundInteraction", featureId, value));
        this.wrapOperation(ops);
    }

    protected void updateInboundConnectionResourceAdapterFeature(String featureId, Object value) {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new InboundConnectionOp());
        ops.add(new ResourceAdapterOp());
        ops.add(new AbstractSYBindingComposite.BasicOperation("inboundConnection/resourceAdapter", featureId, value));
        this.wrapOperation(ops);
    }

    protected void updateInboundInteractionBatchCommitFeature(String featureId, Object value) {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new InboundInteractionOp());
        ops.add(new BatchCommitOp());
        if (featureId != null) {
            ops.add(new AbstractSYBindingComposite.BasicOperation("inboundInteraction/batchCommit", featureId, value));
        }
        this.wrapOperation(ops);
    }

    protected void removeInboundInteractionBatchCommitFeature() {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new InboundInteractionOp());
        ops.add(new RemoveBatchCommitOp());
        this.wrapOperation(ops);
    }

    protected void updateEndpoint() {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new InboundInteractionOp());
        ops.add(new EndpointOp());
        this.wrapOperation(ops);
    }

    protected void updatePropertiesFromPropertyArray(Property[] propList) {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new ActivationSpecOp());
        ops.add(new ClearActivationSpecPropertiesOp());
        if (propList != null && propList.length > 0) {
            int i = 0;
            while (i < propList.length) {
                Property property = propList[i];
                ops.add(new ActivationSpecPropertyOp(property));
                ++i;
            }
        }
        this.wrapOperation(ops);
    }

    protected void updateInboundActivationProperty(String propName, String propValue) {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new FindOrAddActivationPropertyOp(propName, propValue));
        this.wrapOperation(ops);
    }

    protected void getActivationPropertyForControl(ActivationSpec activationSpec, String property, Control control) {
        String value = this.getResourceAdapterPropertyValue(activationSpec, property);
        if (value != null && control != null && !control.isDisposed()) {
            if (control instanceof Text) {
                ((Text)control).setText(value);
            } else if (control instanceof Combo) {
                ((Combo)control).setText(value);
            }
        }
    }

    class ActivationSpecOp
    extends ModelOperation {
        ActivationSpecOp() {
        }

        @Override
        public void run() throws Exception {
            if (AbstractJCABindingComposite.this._binding != null && AbstractJCABindingComposite.this._binding.getInboundConnection() == null) {
                JCAInboundConnection inbound = JcaFactory.eINSTANCE.createJCAInboundConnection();
                AbstractJCABindingComposite.this.setFeatureValue((EObject)AbstractJCABindingComposite.this._binding, "inboundConnection", inbound);
            }
            if (AbstractJCABindingComposite.this._binding != null && AbstractJCABindingComposite.this._binding.getInboundConnection().getActivationSpec() == null) {
                ActivationSpec activationSpec = JcaFactory.eINSTANCE.createActivationSpec();
                AbstractJCABindingComposite.this.setFeatureValue((EObject)AbstractJCABindingComposite.this._binding.getInboundConnection(), "activationSpec", activationSpec);
            }
        }
    }

    class ActivationSpecPropertyOp
    extends ModelOperation {
        private Property _property;

        public ActivationSpecPropertyOp(Property prop) {
            this._property = prop;
        }

        @Override
        public void run() throws Exception {
            if (AbstractJCABindingComposite.this._binding != null && AbstractJCABindingComposite.this._binding.getInboundConnection() != null && AbstractJCABindingComposite.this._binding.getInboundConnection().getActivationSpec() != null && AbstractJCABindingComposite.this._binding.getInboundConnection().getActivationSpec().getProperty() != null) {
                EList props = AbstractJCABindingComposite.this._binding.getInboundConnection().getActivationSpec().getProperty();
                props.add((Object)this._property);
            }
        }
    }

    class BatchCommitOp
    extends ModelOperation {
        BatchCommitOp() {
        }

        @Override
        public void run() throws Exception {
            BatchCommit batchCommit;
            JCAInboundInteraction interaction = AbstractJCABindingComposite.this._binding.getInboundInteraction();
            if (interaction != null && (batchCommit = interaction.getBatchCommit()) == null) {
                batchCommit = JcaFactory.eINSTANCE.createBatchCommit();
                AbstractJCABindingComposite.this.setFeatureValue((EObject)AbstractJCABindingComposite.this._binding.getInboundInteraction(), "batchCommit", batchCommit);
            }
        }
    }

    class ClearActivationSpecPropertiesOp
    extends ModelOperation {
        ClearActivationSpecPropertiesOp() {
        }

        @Override
        public void run() throws Exception {
            if (AbstractJCABindingComposite.this._binding != null && AbstractJCABindingComposite.this._binding.getInboundConnection() != null && AbstractJCABindingComposite.this._binding.getInboundConnection().getActivationSpec() != null && AbstractJCABindingComposite.this._binding.getInboundConnection().getActivationSpec().getProperty() != null) {
                EList props = AbstractJCABindingComposite.this._binding.getInboundConnection().getActivationSpec().getProperty();
                props.clear();
            }
        }
    }

    private static enum ENDPOINT_MAPPING_TYPE {
        JMSENDPOINT,
        CCIENDPOINT;

    }

    class EndpointOp
    extends ModelOperation {
        private ENDPOINT_MAPPING_TYPE _selType = ENDPOINT_MAPPING_TYPE.JMSENDPOINT;

        EndpointOp() {
        }

        public void setEndpointMappingType(ENDPOINT_MAPPING_TYPE inType) {
            this._selType = inType;
        }

        @Override
        public void run() throws Exception {
            JCAInboundInteraction interaction = AbstractJCABindingComposite.this._binding.getInboundInteraction();
            ENDPOINT_MAPPING_TYPE type = this._selType;
            String listener = null;
            String endpointClass = null;
            boolean foundEndpoint = true;
            switch (type) {
                case JMSENDPOINT: {
                    listener = "javax.jms.MessageListener";
                    endpointClass = "org.switchyard.component.jca.endpoint.JMSEndpoint";
                    break;
                }
                case CCIENDPOINT: {
                    listener = "javax.resource.cci.MessageListener";
                    endpointClass = "org.switchyard.component.jca.endpoint.CCIEndpoint";
                    break;
                }
                default: {
                    foundEndpoint = false;
                }
            }
            if (foundEndpoint) {
                interaction.setListener(listener);
                if (interaction.getEndpoint() == null) {
                    Endpoint endpoint = JcaFactory.eINSTANCE.createEndpoint();
                    endpoint.setType(endpointClass);
                    AbstractJCABindingComposite.this.setFeatureValue((EObject)interaction, "endpoint", endpoint);
                } else {
                    interaction.getEndpoint().setType(endpointClass);
                }
            }
        }
    }

    class FindOrAddActivationPropertyOp
    extends ModelOperation {
        private String _propName;
        private String _propValue;

        public FindOrAddActivationPropertyOp(String propName, String propValue) {
            this._propName = propName;
            this._propValue = propValue;
        }

        @Override
        public void run() throws Exception {
            EList inboundProps = AbstractJCABindingComposite.this._binding.getInboundConnection().getActivationSpec().getProperty();
            for (Property next : inboundProps) {
                if (!next.getName().equals(this._propName)) continue;
                if (this._propValue != null && !this._propValue.trim().isEmpty()) {
                    next.setValue((Object)this._propValue);
                } else {
                    inboundProps.remove((Object)next);
                }
                return;
            }
            Property newProp = JcaFactory.eINSTANCE.createProperty();
            newProp.setName(this._propName);
            newProp.setValue((Object)this._propValue);
            inboundProps.add((Object)newProp);
        }
    }

    class InboundConnectionOp
    extends ModelOperation {
        InboundConnectionOp() {
        }

        @Override
        public void run() throws Exception {
            if (AbstractJCABindingComposite.this._binding != null && AbstractJCABindingComposite.this._binding.getInboundConnection() == null) {
                JCAInboundConnection inbound = JcaFactory.eINSTANCE.createJCAInboundConnection();
                AbstractJCABindingComposite.this.setFeatureValue((EObject)AbstractJCABindingComposite.this._binding, "inboundConnection", inbound);
            }
        }
    }

    class InboundInteractionOp
    extends ModelOperation {
        InboundInteractionOp() {
        }

        @Override
        public void run() throws Exception {
            if (AbstractJCABindingComposite.this._binding != null && AbstractJCABindingComposite.this._binding.getInboundInteraction() == null) {
                JCAInboundInteraction interaction = JcaFactory.eINSTANCE.createJCAInboundInteraction();
                AbstractJCABindingComposite.this.setFeatureValue((EObject)AbstractJCABindingComposite.this._binding, "inboundInteraction", interaction);
            }
        }
    }

    class RemoveBatchCommitOp
    extends ModelOperation {
        RemoveBatchCommitOp() {
        }

        @Override
        public void run() throws Exception {
            BatchCommit batchCommit;
            JCAInboundInteraction interaction = AbstractJCABindingComposite.this._binding.getInboundInteraction();
            if (interaction != null && (batchCommit = interaction.getBatchCommit()) != null) {
                AbstractJCABindingComposite.this.setFeatureValue((EObject)AbstractJCABindingComposite.this._binding.getInboundInteraction(), "batchCommit", null);
            }
        }
    }

    class ResourceAdapterOp
    extends ModelOperation {
        ResourceAdapterOp() {
        }

        @Override
        public void run() throws Exception {
            if (AbstractJCABindingComposite.this._binding != null && AbstractJCABindingComposite.this._binding.getInboundConnection() != null && AbstractJCABindingComposite.this._binding.getInboundConnection().getResourceAdapter() == null) {
                ResourceAdapter resAdapter = JcaFactory.eINSTANCE.createResourceAdapter();
                AbstractJCABindingComposite.this.setFeatureValue((EObject)AbstractJCABindingComposite.this._binding.getInboundConnection(), "resourceAdapter", resAdapter);
            }
        }
    }
}

