/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.xml;

import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.CamelFactory;
import org.switchyard.tools.models.switchyard1_0.camel.CamelImplementationType;
import org.switchyard.tools.models.switchyard1_0.camel.XMLDSLType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.camel.xml.NewCamelXMLRouteCompenentWizard;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.property.AbstractChangeAwareModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class CamelXMLRouteComposite
extends AbstractChangeAwareModelComposite<Component> {
    private Composite _panel;
    private CamelImplementationType _implementation = null;
    private ComponentService _service;
    private String _camelRouteFilePath = null;
    private Link _newXMLLink;
    private Button _browseXMLBtn;
    private Text _mXMLText;
    private boolean _updating;

    public CamelXMLRouteComposite(ICompositeContainer container, Composite parent, int style) {
        super(Component.class, container, parent, style);
        FormToolkit factory = this.getWidgetFactory();
        this._panel = this;
        this._panel.setLayout((Layout)new GridLayout(3, false));
        this._newXMLLink = new Link(this._panel, 0);
        String xmlmessage = Messages.link_routeXmlFile;
        this._newXMLLink.setText(xmlmessage);
        this._newXMLLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = CamelXMLRouteComposite.this.getPathToNewXML(CamelXMLRouteComposite.this._mXMLText.getText());
                if (path != null) {
                    CamelXMLRouteComposite.this._mXMLText.setText(path);
                    CamelXMLRouteComposite.this.handleModify((Control)CamelXMLRouteComposite.this._newXMLLink);
                    CamelXMLRouteComposite.this.fireChangedEvent(CamelXMLRouteComposite.this._newXMLLink);
                }
            }
        });
        this._mXMLText = factory.createText(this._panel, "", 2056);
        this._mXMLText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!CamelXMLRouteComposite.this._updating) {
                    CamelXMLRouteComposite.this.handleModify((Control)CamelXMLRouteComposite.this._mXMLText);
                    CamelXMLRouteComposite.this.fireChangedEvent(CamelXMLRouteComposite.this._mXMLText);
                }
            }
        });
        GridData uriGDXML = new GridData(768);
        this._mXMLText.setLayoutData((Object)uriGDXML);
        this._browseXMLBtn = factory.createButton(this._panel, Messages.button_browse, 8);
        GridData btnGDXML = new GridData();
        this._browseXMLBtn.setLayoutData((Object)btnGDXML);
        this._browseXMLBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = CamelXMLRouteComposite.selectResourceFromWorkspace(CamelXMLRouteComposite.this._panel.getShell(), "xml");
                if (path != null) {
                    CamelXMLRouteComposite.this._mXMLText.setText(path);
                    CamelXMLRouteComposite.this.handleModify((Control)CamelXMLRouteComposite.this._browseXMLBtn);
                    CamelXMLRouteComposite.this.fireChangedEvent(CamelXMLRouteComposite.this._browseXMLBtn);
                }
            }
        });
        this._camelRouteFilePath = this._mXMLText.getText();
        this.validate();
        this.adaptChildren((Control)this);
    }

    public void forceServiceInterfaceType(ComponentService serviceInterface) {
        this._service = serviceInterface;
    }

    protected void handleModify(Control control) {
        if (this._mXMLText != null && !this._mXMLText.isDisposed()) {
            this._camelRouteFilePath = this._mXMLText.getText().trim();
            this.getContainer().validated(this.validate());
            if (!this._updating && this._mXMLText != null && !this._mXMLText.isDisposed()) {
                XMLDSLType xmltype;
                if (this._implementation == null) {
                    this._implementation = CamelFactory.eINSTANCE.createCamelImplementationType();
                }
                if ((xmltype = this._implementation.getXml()) == null) {
                    xmltype = CamelFactory.eINSTANCE.createXMLDSLType();
                    this._implementation.setXml(xmltype);
                }
                xmltype.setPath(this._mXMLText.getText());
                this._implementation.setJava(null);
            }
        }
    }

    @Override
    public IStatus validate() {
        String errMessage = null;
        String routeFileName = this._mXMLText.getText();
        if (routeFileName == null || routeFileName.trim().length() == 0) {
            errMessage = Messages.error_noRouteFile;
        } else if (routeFileName.trim().length() < routeFileName.length()) {
            errMessage = Messages.error_spacesInRouteFilePath;
        }
        if (errMessage != null) {
            return new Status(4, "org.switchyard.tools.ui.editor", errMessage);
        }
        return Status.OK_STATUS;
    }

    public Implementation getImplementation() {
        return this._implementation;
    }

    public void setImplementation(Implementation impl) {
        if (impl instanceof CamelImplementationType) {
            this._implementation = (CamelImplementationType)impl;
            this._updating = true;
            if (this._implementation != null && this._mXMLText != null) {
                if (this._implementation.getXml() != null) {
                    this._mXMLText.setText(this._implementation.getXml().getPath());
                } else {
                    this.handleModify((Control)this._mXMLText);
                }
            }
            this._updating = false;
        }
    }

    public ComponentService getService() {
        return this._service;
    }

    public Composite getPanel() {
        return this._panel;
    }

    public String getCamelRouteString() {
        return this._camelRouteFilePath;
    }

    private static String selectResourceFromWorkspace(Shell shell, String extension) {
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        IJavaProject javaProject = null;
        if (modelFile != null && modelFile.getProject() != null) {
            javaProject = JavaCore.create((IProject)modelFile.getProject());
        }
        ClasspathResourceSelectionDialog dialog = null;
        dialog = javaProject == null ? new ClasspathResourceSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), "xml") : new ClasspathResourceSelectionDialog(shell, (IContainer)javaProject.getProject(), "xml");
        dialog.setTitle(Messages.title_selectRouteXmlFileFromProject);
        dialog.setInitialPattern("*.xml");
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0 || !(result[0] instanceof IResource)) {
            return null;
        }
        return JavaUtil.getJavaPathForResource((IResource)((IResource)result[0])).toString();
    }

    private String getPathToNewXML(String defaultName) {
        NewCamelXMLRouteCompenentWizard newWizard = new NewCamelXMLRouteCompenentWizard(false);
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (modelFile != null && modelFile.getProject() != null) {
            IJavaProject javaProject = JavaCore.create((IProject)modelFile.getProject());
            IResource container = JavaUtil.getFirstResourceRoot((IJavaProject)javaProject);
            selectionToPass = container == null ? new StructuredSelection((Object)modelFile.getParent()) : new StructuredSelection((Object)container);
        }
        newWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selectionToPass);
        newWizard.forceServiceInterfaceType(this.getComponentContract());
        newWizard.setCreatedFilePath(defaultName);
        WizardDialog dialog = new WizardDialog(this._panel.getShell(), (IWizard)newWizard);
        if (dialog.open() == 0) {
            this._service = newWizard.getService();
            return newWizard.getCreatedFilePath();
        }
        return null;
    }

    private ComponentService getComponentContract() {
        Iterator iterator;
        Component component;
        if (this._implementation != null && this._implementation.eContainer() instanceof Component && (component = (Component)this._implementation.eContainer()).getService() != null && (iterator = component.getService().iterator()).hasNext()) {
            ComponentService service;
            this._service = service = (ComponentService)iterator.next();
        }
        return this._service;
    }

    @Override
    public void refresh() {
        this._implementation = null;
        Component bo = (Component)this.getTargetObject();
        if (bo != null) {
            this._implementation = (CamelImplementationType)bo.getImplementation();
            this.setImplementation((Implementation)this._implementation);
        }
    }
}

