/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.sftp;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.ftp.CamelSftpBindingType;
import org.switchyard.tools.models.switchyard1_0.camel.ftp.FtpPackage;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.common.ClasspathResourceSelectionDialog;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class CamelSFTPSecurityComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private CamelSftpBindingType _binding = null;
    private Text _privateKeyFileText;
    private Text _privateKeyFilePassphraseText;
    private Button _browseBtn;
    private WritableValue _bindingValue;

    CamelSFTPSecurityComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_sftpSecurityDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_sftpSecurityDetails;
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof CamelSftpBindingType) {
            this._binding = (CamelSftpBindingType)impl;
            this._bindingValue.setValue((Object)this._binding);
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getFTPSTabControl(this._panel);
        this.bindControls(context);
    }

    private Control getFTPSTabControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        this._privateKeyFileText = this.createLabelAndText(composite, Messages.label_privateKeyFile);
        this._browseBtn = new Button(composite, 8);
        this._browseBtn.setText(Messages.buton_dots);
        this._browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CamelSFTPSecurityComposite.this.browse();
            }
        });
        this._privateKeyFilePassphraseText = this.createLabelAndText(composite, Messages.label_privateKeyFilePassphrase);
        GridData gd = new GridData(4, 128, true, false);
        gd.horizontalSpan = 2;
        this._privateKeyFilePassphraseText.setLayoutData((Object)gd);
        return composite;
    }

    private void browse() {
        String pathString = this._privateKeyFileText.getText();
        IResource resource = null;
        IProject resProject = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
        IJavaProject javaProject = JavaCore.create((IProject)resProject);
        if (pathString == null || pathString.isEmpty()) {
            IResource temp = JavaUtil.getFirstResourceRoot((IJavaProject)javaProject);
            resource = temp == null ? javaProject.getResource() : temp;
        } else {
            Path path = new Path(pathString);
            if (path.isValidPath(pathString)) {
                try {
                    resource = javaProject.getProject().getWorkspace().getRoot().getFile((IPath)path);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IResource temp = JavaUtil.getFirstResourceRoot((IJavaProject)javaProject);
                    resource = temp == null ? javaProject.getResource() : temp;
                }
            } else {
                IResource temp = JavaUtil.getFirstResourceRoot((IJavaProject)javaProject);
                IResource iResource = resource = temp == null ? javaProject.getResource() : temp;
            }
        }
        if (resource != null) {
            ClasspathResourceSelectionDialog dialog = new ClasspathResourceSelectionDialog(this.getPanel().getShell(), (IContainer)resource.getProject());
            dialog.setInitialPattern("*.*");
            dialog.setTitle(Messages.title_selectPrivateKeyFile);
            if (dialog.open() == 0) {
                this._privateKeyFileText.setText(((IResource)dialog.getFirstResult()).getFullPath().toString());
                this._privateKeyFileText.notifyListeners(24, null);
                this._privateKeyFileText.notifyListeners(14, null);
                this._privateKeyFileText.setFocus();
            }
        }
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._privateKeyFileText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelSftpBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._privateKeyFileText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)FtpPackage.Literals.CAMEL_SFTP_BINDING_TYPE__PRIVATE_KEY_FILE), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._privateKeyFilePassphraseText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)FtpPackage.Literals.CAMEL_SFTP_BINDING_TYPE__PRIVATE_KEY_FILE_PASSPHRASE), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }
}

