/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.jpa;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.jpa.CamelJpaBindingType;
import org.switchyard.tools.models.switchyard1_0.camel.jpa.JpaPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.model.merge.MergedModelUtil;

public class CamelJPAProducerComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private CamelJpaBindingType _binding = null;
    private Text _nameText;
    private Text _entityClassNameText;
    private Button _browseEntityClassButton;
    private Text _persistenceUnitText;
    private Text _transcationManagerText;
    private Button _flushOnSendCheckbox;
    private Button _usePersistCheckbox;
    private IJavaProject _project;
    private WritableValue _bindingValue;

    CamelJPAProducerComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_jpaBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_jpaBindingDetails;
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof CamelJpaBindingType) {
            IFile file;
            this._binding = (CamelJpaBindingType)impl;
            this._bindingValue.setValue((Object)this._binding);
            Resource resource = MergedModelUtil.getSwitchYard(this.getTargetObject()).eResource();
            if (resource.getURI().isPlatformResource() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resource.getURI().toPlatformString(true)))) != null) {
                this._project = JavaCore.create((IProject)file.getProject());
            }
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getProducerTabControl(this._panel);
        this.bindControls(context);
    }

    private Control getProducerTabControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        this._nameText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._entityClassNameText = this.createLabelAndText(composite, Messages.label_entityClassName);
        this._browseEntityClassButton = new Button(composite, 8);
        this._browseEntityClassButton.setText(Messages.button_browse);
        GridData btnGD = new GridData();
        this._browseEntityClassButton.setLayoutData((Object)btnGD);
        this._browseEntityClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String newClass = CamelJPAProducerComposite.this.handleBrowse(CamelJPAProducerComposite.this._entityClassNameText.getText());
                if (newClass != null) {
                    CamelJPAProducerComposite.this.setTextValueAndNotify(CamelJPAProducerComposite.this._entityClassNameText, newClass, true);
                }
            }
        });
        this._persistenceUnitText = this.createLabelAndText(composite, Messages.label_persistenceUnit);
        this.addGridData((Control)this._persistenceUnitText, 2, 768);
        this._transcationManagerText = this.createLabelAndText(composite, Messages.label_transactionManager);
        this.addGridData((Control)this._transcationManagerText, 2, 768);
        Group producerGroup = new Group(composite, 0);
        producerGroup.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        producerGroup.setLayout((Layout)new GridLayout(2, false));
        producerGroup.setText(Messages.label_producerOptions);
        this._flushOnSendCheckbox = this.createCheckbox((Composite)producerGroup, Messages.label_flushOnSend);
        this._usePersistCheckbox = this.createCheckbox((Composite)producerGroup, Messages.label_usePersist);
        return composite;
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private String handleBrowse(String filter) {
        IJavaSearchScope scope = null;
        scope = this._project == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this._project});
        try {
            Object[] result;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)Display.getCurrent().getActiveShell(), null, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)(filter.isEmpty() ? "* " : filter));
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IType) {
                return ((IType)result[0]).getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelJpaBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("JPA binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("JPA binding name should not be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._entityClassNameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JpaPackage.Literals.CAMEL_JPA_BINDING_TYPE__ENTITY_CLASS_NAME), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator(Messages.error_emptyEntityClassName)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._persistenceUnitText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JpaPackage.Literals.CAMEL_JPA_BINDING_TYPE__PERSISTENCE_UNIT), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator(Messages.error_emptyPersistenceUnit)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._transcationManagerText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JpaPackage.Literals.CAMEL_JPA_BINDING_TYPE__TRANSACTION_MANAGER), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        FeaturePath path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JpaPackage.Literals.CAMEL_JPA_BINDING_TYPE__PRODUCE, JpaPackage.Literals.JPA_PRODUCER_TYPE__FLUSH_ON_SEND});
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._flushOnSendCheckbox), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        path = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{JpaPackage.Literals.CAMEL_JPA_BINDING_TYPE__PRODUCE, JpaPackage.Literals.JPA_PRODUCER_TYPE__USE_PERSIST});
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._usePersistCheckbox), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, path), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
    }
}

