/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.jms;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.Reference;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.soa.sca.sca1_1.model.sca.Service;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.jms.CamelJmsBindingType;
import org.switchyard.tools.models.switchyard1_0.camel.jms.JmsPackage;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyIntegerValidator;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.binding.OperationSelectorComposite;

public class CamelJmsComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private CamelJmsBindingType _binding = null;
    private Text _nameText;
    private ComboViewer _typeCombo;
    private Text _connectionFactoryText;
    private Text _concurrentConsumersText;
    private Text _maxConcurrentConsumersText;
    private Text _replyToText;
    private Text _requestTimeOutText;
    private Text _transactionManagerText;
    private Text _selectorText;
    private Button _transactedButton;
    private OperationSelectorComposite _opSelectorComposite;
    private WritableValue _bindingValue;
    private org.eclipse.core.databinding.Binding _queueNameBinding;
    private org.eclipse.core.databinding.Binding _topicNameBinding;
    private StackLayout _stackLayout = null;
    private Composite _contentPanel = null;
    private Composite _queuePanel = null;
    private Text _queueNameText;
    private Composite _topicPanel = null;
    private Text _topicNameText;
    private DataBindingContext _context;
    private IObservableValue _queueValue;
    private IObservableValue _topicValue;

    CamelJmsComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_jmsBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_jmsBindingDetails;
    }

    @Override
    public void setBinding(Binding impl) {
        super.setBinding(impl);
        if (impl instanceof CamelJmsBindingType) {
            this.setTargetObject(impl.eContainer());
            this._binding = (CamelJmsBindingType)impl;
            this._bindingValue.setValue((Object)this._binding);
            if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed() && this.getTargetObject() != null) {
                this._opSelectorComposite.setTargetObject(this.getTargetObject());
            }
            if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
                this._opSelectorComposite.setBinding((Binding)this._binding);
            }
            JMSType initialType = JMSType.QUEUE;
            String queueText = this._binding.getQueue();
            String topicText = this._binding.getTopic();
            if (queueText != null && topicText == null) {
                initialType = JMSType.QUEUE;
            } else if (topicText != null && queueText == null) {
                initialType = JMSType.TOPIC;
            }
            this._typeCombo.setSelection((ISelection)new StructuredSelection((Object)initialType));
        } else {
            this._bindingValue.setValue(null);
        }
    }

    @Override
    public void setTargetObject(EObject target) {
        super.setTargetObject(target);
        if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setTargetObject(target);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._context = context;
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        if (this.getTargetObject() == null && this._binding != null && this._binding.eContainer() != null) {
            this.setTargetObject(this._binding.eContainer());
        }
        this.getJmsTabControl(this._panel);
        if (this.getTargetObject() != null && this.getTargetObject() instanceof Service && this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setTargetObject(this.getTargetObject());
        }
        this.bindControls(context);
        this._typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                CamelJmsComposite.this.handleSelectorTypeChanged((JMSType)((Object)((IStructuredSelection)event.getSelection()).getFirstElement()));
            }
        });
    }

    private Control getJmsTabControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        this._typeCombo = this.createLabelAndComboViewer(composite, Messages.label_type, true);
        this._typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._typeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof JMSType) {
                    return ((JMSType)((Object)element)).getLabel();
                }
                return super.getText(element);
            }
        });
        this._typeCombo.setInput((Object)JMSType.values());
        this.getToolkit().createLabel(composite, Messages.label_queueTopicName);
        this._contentPanel = new Composite(composite, 0);
        this._stackLayout = new StackLayout();
        this._contentPanel.setLayout((Layout)this._stackLayout);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalIndent = -5;
        gd.verticalIndent = -5;
        this._contentPanel.setLayoutData((Object)gd);
        this._queuePanel = new Composite(this._contentPanel, 0);
        this._queueNameText = this.createLabelAndText(this._queuePanel, null);
        this._queuePanel.setLayout((Layout)new GridLayout(2, false));
        this._queueNameText.setLayoutData((Object)new GridData(4, 0, true, false));
        this._topicPanel = new Composite(this._contentPanel, 0);
        this._topicNameText = this.createLabelAndText(this._topicPanel, null);
        this._topicPanel.setLayout((Layout)new GridLayout(2, false));
        this._topicNameText.setLayoutData((Object)new GridData(4, 0, true, false));
        this._connectionFactoryText = this.createLabelAndText(composite, Messages.label_connectionFactory);
        this._connectionFactoryText.setText("#ConnectionFactory");
        this._concurrentConsumersText = this.createLabelAndText(composite, Messages.label_concurrentConsumers);
        this._concurrentConsumersText.setText("1");
        this._maxConcurrentConsumersText = this.createLabelAndText(composite, Messages.label_maximumConcurrentConsumers);
        this._maxConcurrentConsumersText.setText("1");
        this._replyToText = this.createLabelAndText(composite, Messages.label_replyTo);
        this._requestTimeOutText = null;
        if (this.getTargetObject() != null && this.getTargetObject() instanceof Reference) {
            this._requestTimeOutText = this.createLabelAndText(composite, Messages.label_requestTimeout);
            this._requestTimeOutText.setText("20000");
        }
        this._selectorText = this.createLabelAndText(composite, Messages.label_selector);
        this._transactionManagerText = this.createLabelAndText(composite, Messages.label_transactionManager);
        this._transactedButton = this.createCheckbox(composite, Messages.label_transacted);
        if (this.getTargetObject() != null && this.getTargetObject() instanceof Service) {
            this._opSelectorComposite = new OperationSelectorComposite(composite, 0, this);
            this._opSelectorComposite.setLayoutData(new GridData(4, 1, true, false, 2, 1));
            this._opSelectorComposite.setLayout((Layout)new GridLayout(2, false));
            this._opSelectorComposite.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    CamelJmsComposite.this.handleModify((Control)CamelJmsComposite.this._opSelectorComposite);
                }
            });
        }
        return composite;
    }

    private void handleSelectorTypeChanged(JMSType typeToSelect) {
        this._queueNameText.setEnabled(false);
        this._topicNameText.setEnabled(false);
        switch (typeToSelect) {
            case QUEUE: {
                this._queueNameText.setEnabled(true);
                if (this._topicValue.getValue() != null) {
                    this._topicValue.setValue(null);
                }
                this._stackLayout.topControl = this._queuePanel;
                this._context.removeBinding(this._topicNameBinding);
                this._context.addBinding(this._queueNameBinding);
                break;
            }
            case TOPIC: {
                this._topicNameText.setEnabled(true);
                if (this._queueValue.getValue() != null) {
                    this._queueValue.setValue(null);
                }
                this._stackLayout.topControl = this._topicPanel;
                this._context.removeBinding(this._queueNameBinding);
                this._context.addBinding(this._topicNameBinding);
            }
        }
        this._contentPanel.layout();
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    protected void handleModify(Control control) {
        if (control.equals((Object)this._opSelectorComposite)) {
            this.fireChangedEvent((Object)this._opSelectorComposite);
        }
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelJmsBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("JMS binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("JMS binding name should not be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        this._queueValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JmsPackage.Literals.CAMEL_JMS_BINDING_TYPE__QUEUE);
        this._queueNameBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._queueNameText, (int[])new int[]{24}), this._queueValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("Queue may not be empty.")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._queueNameBinding), (int)16512);
        this._topicValue = ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JmsPackage.Literals.CAMEL_JMS_BINDING_TYPE__TOPIC);
        this._topicNameBinding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._topicNameText, (int[])new int[]{24}), this._topicValue, new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("Topic may not be empty.")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(this._topicNameBinding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._connectionFactoryText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JmsPackage.Literals.CAMEL_JMS_BINDING_TYPE__CONNECTION_FACTORY), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator(Messages.error_emptyConnectionFactory)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._concurrentConsumersText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JmsPackage.Literals.CAMEL_JMS_BINDING_TYPE__CONCURRENT_CONSUMERS), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidator("Concurrent Consumers must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._maxConcurrentConsumersText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JmsPackage.Literals.CAMEL_JMS_BINDING_TYPE__MAX_CONCURRENT_CONSUMERS), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidator("Max Concurrent Consumers must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._replyToText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JmsPackage.Literals.CAMEL_JMS_BINDING_TYPE__REPLY_TO), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        if (this._requestTimeOutText != null && !this._requestTimeOutText.isDisposed()) {
            binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._requestTimeOutText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JmsPackage.Literals.CAMEL_JMS_BINDING_TYPE__REQUEST_TIMEOUT), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidator("Request Timeout must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
            ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        }
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._transactionManagerText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JmsPackage.Literals.CAMEL_JMS_BINDING_TYPE__TRANSACTION_MANAGER), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._transactedButton), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JmsPackage.Literals.CAMEL_JMS_BINDING_TYPE__TRANSACTED), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._selectorText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)JmsPackage.Literals.CAMEL_JMS_BINDING_TYPE__SELECTOR), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        if (this._opSelectorComposite != null) {
            this._opSelectorComposite.bindControls(domain, context);
        }
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        this._queueValue.dispose();
        this._topicValue.dispose();
        this._topicNameBinding.dispose();
        this._queueNameBinding.dispose();
        super.dispose();
    }

    private static enum JMSType {
        QUEUE(Messages.label_queue){}
        ,
        TOPIC(Messages.label_topic){};

        private final String _label;

        private JMSType(String label) {
            this._label = label;
        }

        public String getLabel() {
            return this._label;
        }
    }
}

