/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.camel.java;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.camel.CamelFactory;
import org.switchyard.tools.models.switchyard1_0.camel.CamelImplementationType;
import org.switchyard.tools.models.switchyard1_0.camel.JavaDSLType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.camel.java.NewCamelJavaRouteComponentWizard;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.property.AbstractChangeAwareModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class CamelJavaRouteComposite
extends AbstractChangeAwareModelComposite<Component> {
    private Composite _panel;
    private CamelImplementationType _implementation = null;
    private ComponentService _service;
    private String _routeClassName = null;
    private Link _newClassLink;
    private Text _mClassText;
    private Button _browseClassBtn;
    private boolean _updating;

    public CamelJavaRouteComposite(ICompositeContainer container, Composite parent, int style) {
        super(Component.class, container, parent, style);
        FormToolkit factory = this.getWidgetFactory();
        this._panel = this;
        this._panel.setLayout((Layout)new GridLayout(3, false));
        this._newClassLink = new Link(this._panel, 0);
        String message = Messages.link_routeBuilderClass;
        this._newClassLink.setText(message);
        this._newClassLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CamelJavaRouteComposite.this._mClassText != null && !CamelJavaRouteComposite.this._mClassText.isDisposed()) {
                    String classname = CamelJavaRouteComposite.this._mClassText.getText();
                    try {
                        IType foundClass = CamelJavaRouteComposite.this.canFindClass(classname);
                        if (foundClass == null) {
                            String className = CamelJavaRouteComposite.this.handleCreateJavaClass();
                            if (className != null) {
                                CamelJavaRouteComposite.this._mClassText.setText(className);
                                CamelJavaRouteComposite.this.handleModify((Control)CamelJavaRouteComposite.this._mClassText);
                                CamelJavaRouteComposite.this.fireChangedEvent(CamelJavaRouteComposite.this._newClassLink);
                            }
                            return;
                        }
                        CamelJavaRouteComposite.this.handleOpenJavaClass(foundClass);
                    }
                    catch (JavaModelException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this._mClassText = factory.createText(this._panel, "", 2056);
        this._mClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CamelJavaRouteComposite.this.handleModify((Control)CamelJavaRouteComposite.this._mClassText);
                CamelJavaRouteComposite.this.fireChangedEvent(CamelJavaRouteComposite.this._mClassText);
            }
        });
        GridData uriGD = new GridData(768);
        this._mClassText.setLayoutData((Object)uriGD);
        this._browseClassBtn = factory.createButton(this._panel, Messages.button_browse, 8);
        GridData btnGD = new GridData();
        this._browseClassBtn.setLayoutData((Object)btnGD);
        this._browseClassBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    IType selected = CamelJavaRouteComposite.this.selectType(CamelJavaRouteComposite.this._panel.getShell(), "org.apache.camel.builder.RouteBuilder", null);
                    if (selected != null) {
                        CamelJavaRouteComposite.this._service = null;
                        CamelJavaRouteComposite.this._mClassText.setText(selected.getFullyQualifiedName());
                        CamelJavaRouteComposite.this.handleModify((Control)CamelJavaRouteComposite.this._mClassText);
                        CamelJavaRouteComposite.this.fireChangedEvent(CamelJavaRouteComposite.this._browseClassBtn);
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.validate();
        this.adaptChildren((Control)this);
    }

    public void forceServiceInterfaceType(ComponentService serviceInterface) {
        this._service = serviceInterface;
    }

    public IType selectType(Shell shell, String superTypeName, IProject project) throws JavaModelException {
        IJavaSearchScope searchScope = null;
        if (project == null) {
            ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            StructuredSelection selectionToPass = StructuredSelection.EMPTY;
            if (selection instanceof IStructuredSelection && (selectionToPass = (IStructuredSelection)selection).getFirstElement() instanceof IFile) {
                project = ((IFile)selectionToPass.getFirstElement()).getProject();
            }
        }
        if (superTypeName != null && !superTypeName.equals("java.lang.Object")) {
            IJavaProject javaProject;
            IType superType;
            if (project == null) {
                project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
            }
            if ((superType = (javaProject = JavaCore.create((IProject)project)).findType(superTypeName)) != null) {
                searchScope = SearchEngine.createStrictHierarchyScope((IJavaProject)javaProject, (IType)superType, (boolean)true, (boolean)false, null);
            }
        } else {
            searchScope = SearchEngine.createWorkspaceScope();
        }
        SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)searchScope, (int)512, (boolean)false);
        dialog.setTitle(Messages.label_selectEntries);
        dialog.setMessage(Messages.label_matchingItems);
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types == null || types.length == 0) {
            return null;
        }
        return (IType)types[0];
    }

    private IType canFindClass(String classname) throws JavaModelException {
        IJavaProject javaProject;
        IType superType;
        IProject project = null;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection && (selectionToPass = (IStructuredSelection)selection).getFirstElement() instanceof IFile) {
            project = ((IFile)selectionToPass.getFirstElement()).getProject();
        }
        if (selectionToPass == StructuredSelection.EMPTY) {
            project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
        }
        if (project != null && classname != null && (superType = (javaProject = JavaCore.create((IProject)project)).findType(classname)) != null) {
            return superType;
        }
        return null;
    }

    private void handleOpenJavaClass(IType classToOpen) {
        if (classToOpen != null) {
            try {
                JavaUI.openInEditor((IJavaElement)classToOpen);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    private String handleCreateJavaClass() throws JavaModelException {
        Component component;
        IJavaElement element;
        IProject project = null;
        IJavaProject javaProject = null;
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        if (modelFile != null) {
            project = modelFile.getProject();
        }
        if (project != null) {
            javaProject = JavaCore.create((IProject)project);
        }
        StructuredSelection selectionToPass = (element = JavaUtil.getInitialPackageForProject(javaProject)) == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)element);
        NewCamelJavaRouteComponentWizard wizard = new NewCamelJavaRouteComponentWizard(false);
        WizardDialog dialog = new WizardDialog(this._panel.getShell(), (IWizard)wizard);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selectionToPass);
        wizard.forceServiceInterfaceType((Contract)this.getComponentContract());
        if (dialog.open() == 0 && (component = wizard.getCreatedObject()) != null) {
            EList services = component.getService();
            if (services != null && services.size() > 0) {
                this._service = (ComponentService)services.get(0);
            }
            return ((CamelImplementationType)component.getImplementation()).getJava().getClass_();
        }
        return null;
    }

    protected void handleModify(Control control) {
        if (this._mClassText != null && !this._mClassText.isDisposed()) {
            this._routeClassName = this._mClassText.getText().trim();
            this.getContainer().validated(this.validate());
            if (!this._updating && this._mClassText != null && !this._mClassText.isDisposed()) {
                JavaDSLType javatype;
                if (this._implementation == null) {
                    this._implementation = CamelFactory.eINSTANCE.createCamelImplementationType();
                }
                if ((javatype = this._implementation.getJava()) == null) {
                    javatype = CamelFactory.eINSTANCE.createJavaDSLType();
                    this._implementation.setJava(javatype);
                }
                javatype.setClass(this._mClassText.getText());
                this._implementation.setXml(null);
            }
        }
    }

    @Override
    public IStatus validate() {
        String errMessage = null;
        String className = this._mClassText.getText();
        if (className == null || className.trim().length() == 0) {
            errMessage = Messages.error_noClassSpecified;
        } else if (className.trim().length() < className.length()) {
            errMessage = Messages.error_noSpacesInClassName;
        }
        if (errMessage != null) {
            return new Status(4, "org.switchyard.tools.ui.editor", errMessage);
        }
        return Status.OK_STATUS;
    }

    public Implementation getImplementation() {
        return this._implementation;
    }

    public void setImplementation(Implementation impl) {
        if (impl instanceof CamelImplementationType) {
            this._implementation = (CamelImplementationType)impl;
            this._updating = true;
            if (this._implementation != null && this._mClassText != null) {
                if (this._implementation.getJava() != null) {
                    this._mClassText.setText(this._implementation.getJava().getClass_());
                } else {
                    this.handleModify((Control)this._mClassText);
                }
            }
            this._updating = false;
        }
    }

    public ComponentService getService() {
        return this._service;
    }

    public Composite getPanel() {
        return this._panel;
    }

    public String getCamelRouteClass() {
        return this._routeClassName;
    }

    private ComponentService getComponentContract() {
        Iterator iterator;
        Component component;
        if (this._implementation != null && this._implementation.eContainer() instanceof Component && (component = (Component)this._implementation.eContainer()).getService() != null && (iterator = component.getService().iterator()).hasNext()) {
            ComponentService service;
            this._service = service = (ComponentService)iterator.next();
        }
        return this._service;
    }

    @Override
    public void refresh() {
        this._implementation = null;
        Component bo = (Component)this.getTargetObject();
        if (bo != null) {
            this._implementation = (CamelImplementationType)bo.getImplementation();
            this._updating = true;
            if (this._implementation != null && this._mClassText != null) {
                if (this._implementation.getJava() != null) {
                    this._mClassText.setText(this._implementation.getJava().getClass_());
                } else {
                    this.handleModify((Control)this._mClassText);
                }
            }
            this._updating = false;
        }
    }
}

