/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.bean;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.ui.PlatformUI;
import org.switchyard.tools.models.switchyard1_0.bean.BeanFactory;
import org.switchyard.tools.models.switchyard1_0.bean.BeanImplementationType;
import org.switchyard.tools.ui.JavaTypeScanner;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.editor.diagram.component.IComponentWizard;
import org.switchyard.tools.ui.wizards.NewBeanServiceWizard;

public class NewBeanComponentWizard
extends NewBeanServiceWizard
implements IComponentWizard {
    private Component _component;

    public NewBeanComponentWizard(boolean openAfterCreate) {
        super(false, openAfterCreate);
    }

    @Override
    public Component getCreatedObject() {
        return this._component;
    }

    @Override
    public void init(Composite container) {
        if (container == null || this.getSelection() != null && !this.getSelection().isEmpty()) {
            return;
        }
        IProject project = PlatformResourceAdapterFactory.getContainingProject((Object)container);
        if (project == null) {
            return;
        }
        IJavaElement element = JavaUtil.getInitialPackageForProject((IJavaProject)JavaCore.create((IProject)project));
        StructuredSelection selection = element == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)element);
        this.init(this.getWorkbench() == null ? PlatformUI.getWorkbench() : this.getWorkbench(), (IStructuredSelection)selection);
    }

    public boolean performFinish() {
        if (super.performFinish()) {
            IType type = this.getNewClass();
            BeanImplementationType implementation = BeanFactory.eINSTANCE.createBeanImplementationType();
            implementation.setClass(type.getFullyQualifiedName());
            this._component = ScaFactory.eINSTANCE.createComponent();
            this._component.setName(type.getElementName());
            this._component.setImplementation((Implementation)implementation);
            JavaTypeScanner scanner = new JavaTypeScanner(type);
            List services = scanner.getServices();
            if (services != null && services.size() > 0) {
                this._component.getService().add((Object)((ComponentService)services.get(0)));
            } else if (this.getServiceContract() instanceof ComponentService) {
                this._component.getService().add((Object)((ComponentService)this.getServiceContract()));
            }
            List references = scanner.getReferences();
            if (references != null) {
                references.addAll(references);
            }
            return true;
        }
        return false;
    }
}

