/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.bean;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Interface;
import org.eclipse.soa.sca.sca1_1.model.sca.JavaInterface;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.wizards.NewBeanServiceWizard;

public class BeanImplementationWizardPage
extends WizardPage {
    private Link _newBeanLink;
    private Text _beanClassText;
    private Button _browseBeanButton;
    private IJavaProject _project;
    private IType _beanClass;
    private ComponentService _serviceInterface;
    private IType _serviceInterfaceType;

    public BeanImplementationWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.title_beanImplementationDetails);
        this.setDescription(Messages.description_beanImplementationDetails);
        this.setPageComplete(false);
    }

    private void updateProject(Component container) {
        ResourceSet resourceSet;
        if (container == null) {
            this._project = null;
            return;
        }
        ResourceSet resourceSet2 = resourceSet = container.eResource() == null ? null : container.eResource().getResourceSet();
        if (resourceSet != null && resourceSet.getResources().size() > 0) {
            for (Resource emfResource : resourceSet.getResources()) {
                IProject project;
                IResource resource;
                String path = resourceSet.getURIConverter().normalize(emfResource.getURI()).toPlatformString(true);
                if (path == null || (resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path)) == null || (project = resource.getProject()) == null) continue;
                this._project = JavaCore.create((IProject)project);
                break;
            }
        }
    }

    public void setComponent(Component component) {
        this.updateProject(component);
        this._serviceInterface = null;
        if (this._project == null || component == null || component.getService() == null) {
            return;
        }
        Iterator iterator = component.getService().iterator();
        if (iterator.hasNext()) {
            ComponentService service;
            this._serviceInterface = service = (ComponentService)iterator.next();
            Interface intf = service.getInterface();
            if (intf instanceof JavaInterface && ((JavaInterface)intf).getInterface() != null) {
                try {
                    this._serviceInterfaceType = this._project.findType(((JavaInterface)intf).getInterface());
                }
                catch (JavaModelException e) {
                    e.fillInStackTrace();
                }
            }
            return;
        }
    }

    public IType getBeanClass() {
        return this._beanClass;
    }

    public void createControl(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        this._newBeanLink = new Link(contents, 0);
        this._newBeanLink.setText(Messages.link_beanClass);
        this._newBeanLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BeanImplementationWizardPage.this.openNewBeanWizard();
            }
        });
        this._beanClassText = new Text(contents, 2056);
        this._beanClassText.setLayoutData((Object)new GridData(768));
        this._beanClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                BeanImplementationWizardPage.this.validate();
            }
        });
        this._browseBeanButton = new Button(contents, 8);
        this._browseBeanButton.setText(Messages.button_browse);
        this._browseBeanButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BeanImplementationWizardPage.this.handleBrowse();
            }
        });
        this.setControl((Control)contents);
    }

    private void validate() {
        this.setErrorMessage(null);
        if (this._beanClass == null) {
            this.setErrorMessage(Messages.error_pleaseSelectBeanClass);
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private void handleBrowse() {
        IJavaSearchScope scope = null;
        if (this._project == null) {
            scope = SearchEngine.createWorkspaceScope();
        } else if (this._serviceInterface == null) {
            scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this._project});
        } else {
            try {
                scope = SearchEngine.createStrictHierarchyScope((IJavaProject)this._project, (IType)this._serviceInterfaceType, (boolean)true, (boolean)false, null);
            }
            catch (JavaModelException javaModelException) {
                scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this._project});
            }
        }
        try {
            Object[] result;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)this.getContainer(), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"*Bean");
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IType) {
                this._beanClass = (IType)result[0];
                this._beanClassText.setText(((IType)result[0]).getFullyQualifiedName());
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void openNewBeanWizard() {
        IType type;
        ICompilationUnit icu;
        NewBeanServiceWizard wizard = new NewBeanServiceWizard(false, false);
        SwitchyardSCAEditor editor = SwitchyardSCAEditor.getEditor((EObject)this._serviceInterface);
        IJavaElement element = JavaUtil.getInitialPackageForProject((IJavaProject)this._project);
        StructuredSelection selection = element == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)element);
        IWorkbench workbench = editor == null ? PlatformUI.getWorkbench() : editor.getEditorSite().getWorkbenchWindow().getWorkbench();
        wizard.init(workbench, (IStructuredSelection)selection);
        wizard.forceServiceInterfaceType(this._serviceInterface);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (icu = JavaCore.createCompilationUnitFrom((IFile)wizard.getNewClassFile())) != null && (type = icu.findPrimaryType()) != null) {
            this._beanClass = type;
            this._beanClassText.setText(type.getFullyQualifiedName());
        }
    }
}

