/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.browser.XULRunnerInitializer;

public class BrowserInitializer {
    private static final String PROPERTY_DEFAULTTYPE = "org.eclipse.swt.browser.DefaultType";
    private static final String SWT_GTK3 = "SWT_GTK3";

    static {
        String defaultType;
        if ("linux".equals(Platform.getOS()) && (defaultType = System.getProperty(PROPERTY_DEFAULTTYPE)) == null) {
            defaultType = BrowserInitializer.isGTK3() || !XULRunnerInitializer.EMBEDDED_XULRUNNER_ENABLED ? "webkit" : "mozilla";
            System.setProperty(PROPERTY_DEFAULTTYPE, defaultType);
        }
    }

    public static boolean isGTK3() {
        if ("gtk".equals(Platform.getWS())) {
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.gtk.OS");
                Field field = clazz.getDeclaredField("GTK3");
                boolean gtk3 = field.getBoolean(field);
                return gtk3;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return BrowserInitializer.isGTK3Env();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return false;
            }
            catch (SecurityException securityException) {
                return BrowserInitializer.isGTK3Env();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return BrowserInitializer.isGTK3Env();
            }
            catch (IllegalAccessException illegalAccessException) {
                return BrowserInitializer.isGTK3Env();
            }
        }
        return false;
    }

    private static boolean isGTK3Env() {
        String gtk3 = System.getProperty(SWT_GTK3);
        if (gtk3 == null) {
            gtk3 = System.getenv(SWT_GTK3);
        }
        return !"0".equals(gtk3);
    }
}

