/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.view;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.jboss.tools.usage.event.UsageEventType;
import org.jboss.tools.usage.event.UsageReporter;
import org.jboss.tools.vpe.preview.Activator;
import org.jboss.tools.vpe.preview.core.exceptions.BrowserErrorWrapper;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModel;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModelHolder;
import org.jboss.tools.vpe.preview.core.util.ActionBarUtil;
import org.jboss.tools.vpe.preview.core.util.EditorUtil;
import org.jboss.tools.vpe.preview.core.util.NavigationUtil;
import org.jboss.tools.vpe.preview.core.util.SuitableFileExtensions;

public class VpvView
extends ViewPart
implements VpvVisualModelHolder {
    public static final String ID = "org.jboss.tools.vpe.vpv.view.VpvView";
    private Browser browser;
    private ActionBarUtil actionBarUtil;
    private Job currentJob;
    private VpvVisualModel visualModel;
    private int modelHolderId;
    private EditorListener editorListener;
    private SelectionListener selectionListener;
    private IEditorPart currentEditor;
    private IDocumentListener documentListener;
    protected BrowserErrorWrapper errorWrapper = new BrowserErrorWrapper();

    public VpvView() {
        this.setModelHolderId(Activator.getDefault().getVisualModelHolderRegistry().registerHolder((VpvVisualModelHolder)this));
        UsageEventType eventType = Activator.getDefault().getPreviewEventType();
        UsageReporter.getInstance().countEvent(eventType.event("open"));
    }

    public void dispose() {
        if (this.editorListener != null) {
            this.getSite().getPage().removePartListener((IPartListener2)this.editorListener);
        }
        if (this.selectionListener != null) {
            this.getSite().getPage().removeSelectionListener((ISelectionListener)this.selectionListener);
        }
        Activator.getDefault().getVisualModelHolderRegistry().unregisterHolder((VpvVisualModelHolder)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        try {
            this.browser = new Browser(parent, 0);
            this.browser.setUrl("about:blank");
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent event) {
                    NavigationUtil.disableAlert((Browser)VpvView.this.browser);
                    NavigationUtil.disableLinks((Browser)VpvView.this.browser);
                    NavigationUtil.disableInputs((Browser)VpvView.this.browser);
                    ISelection currentSelection = VpvView.this.getCurrentSelection();
                    NavigationUtil.updateSelectionAndScrollToIt((ISelection)currentSelection, (Browser)VpvView.this.browser, (VpvVisualModel)VpvView.this.visualModel);
                }
            });
            this.browser.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent event) {
                    NavigationUtil.navigateToVisual((IEditorPart)VpvView.this.currentEditor, (Browser)VpvView.this.browser, (VpvVisualModel)VpvView.this.visualModel, (int)event.x, (int)event.y);
                }
            });
            this.inizializeSelectionListener();
            this.inizializeEditorListener(this.browser, this.modelHolderId);
            IActionBars bars = this.getViewSite().getActionBars();
            this.actionBarUtil = new ActionBarUtil(this.browser);
            this.actionBarUtil.fillLocalToolBar(bars.getToolBarManager());
        }
        catch (Throwable t) {
            this.errorWrapper.showError(parent, t);
        }
    }

    private void inizializeEditorListener(Browser browser, int modelHolderId) {
        this.editorListener = new EditorListener();
        this.getSite().getPage().addPartListener((IPartListener2)this.editorListener);
        this.editorListener.showBootstrapPart();
    }

    private void inizializeSelectionListener() {
        this.selectionListener = new SelectionListener();
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this.selectionListener);
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public void setVisualModel(VpvVisualModel visualModel) {
        this.visualModel = visualModel;
    }

    public void setModelHolderId(int modelHolderId) {
        this.modelHolderId = modelHolderId;
    }

    public IEditorPart getCurrentEditor() {
        return this.currentEditor;
    }

    public void editorChanged(IEditorPart editor) {
        if (this.currentEditor != editor) {
            if (editor == null) {
                this.browser.setUrl("about:blank");
                this.setCurrentEditor(null);
            } else if (EditorUtil.isImportant((IEditorPart)editor)) {
                this.formRequestToServer(editor);
                this.setCurrentEditor(editor);
            } else {
                this.browser.setUrl("about:blank");
                this.setCurrentEditor(null);
            }
        }
    }

    private void setCurrentEditor(IEditorPart currentEditor) {
        IDocument document;
        if (this.currentEditor != null && (document = (IDocument)this.currentEditor.getAdapter(IDocument.class)) != null) {
            document.removeDocumentListener(this.getDocumentListener());
        }
        this.currentEditor = currentEditor;
        if (this.currentEditor != null) {
            document = (IDocument)this.currentEditor.getAdapter(IDocument.class);
            String fileExtension = EditorUtil.getFileExtensionFromEditor((IEditorPart)this.currentEditor);
            if (document == null && SuitableFileExtensions.isCssOrJs((String)fileExtension)) {
                document = ((AbstractDecoratedTextEditor)this.currentEditor).getDocumentProvider().getDocument((Object)currentEditor.getEditorInput());
            }
            if (document != null) {
                document.addDocumentListener(this.getDocumentListener());
            }
        }
    }

    private IDocumentListener getDocumentListener() {
        if (this.documentListener == null) {
            this.documentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    if (VpvView.this.actionBarUtil.isAutomaticRefreshEnabled()) {
                        String fileExtension = EditorUtil.getFileExtensionFromEditor((IEditorPart)VpvView.this.currentEditor);
                        if (SuitableFileExtensions.isCssOrJs((String)fileExtension)) {
                            VpvView.this.currentEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                        }
                        VpvView.this.updatePreview();
                    }
                }
            };
        }
        return this.documentListener;
    }

    private Job createPreviewUpdateJob() {
        UIJob job = new UIJob("Preview Update"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!VpvView.this.browser.isDisposed()) {
                    VpvView.this.refresh(VpvView.this.browser);
                }
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    private void updatePreview() {
        if (this.currentJob == null || this.currentJob.getState() != 2) {
            if (this.currentJob != null && this.currentJob.getState() == 1) {
                this.currentJob.cancel();
            }
            this.currentJob = this.createPreviewUpdateJob();
        }
        this.currentJob.schedule(500L);
    }

    private void refresh(Browser browser) {
        browser.setUrl(browser.getUrl());
    }

    private ISelection getCurrentSelection() {
        Activator activator = Activator.getDefault();
        IWorkbench workbench = activator.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        ISelectionService selectionService = workbenchWindow.getSelectionService();
        ISelection selection = selectionService.getSelection();
        return selection;
    }

    private boolean isCurrentEditor(IEditorPart editorPart) {
        return this.currentEditor == editorPart;
    }

    private void formRequestToServer(IEditorPart editor) {
        IFile file = EditorUtil.getFileOpenedInEditor((IEditorPart)editor);
        String fileExtension = null;
        if (file != null && file.exists()) {
            fileExtension = file.getFileExtension();
        }
        if (SuitableFileExtensions.contains(fileExtension)) {
            if (SuitableFileExtensions.isHTML(fileExtension)) {
                try {
                    String url = EditorUtil.formUrl((IFile)file, (int)this.modelHolderId, (String)("" + Activator.getDefault().getServer().getPort()));
                    this.browser.setUrl(url);
                }
                catch (UnsupportedEncodingException e) {
                    Activator.logError(e);
                }
            }
        } else {
            this.browser.setUrl("about:blank");
        }
    }

    private IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private class EditorListener
    implements IPartListener2 {
        private EditorListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef instanceof EditorReference) {
                IEditorPart editor = ((EditorReference)partRef).getEditor(false);
                VpvView.this.editorChanged(editor);
            }
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            IEditorPart editorPart;
            if (partRef instanceof EditorReference && VpvView.this.isCurrentEditor(editorPart = ((EditorReference)partRef).getEditor(false))) {
                VpvView.this.editorChanged(null);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void showBootstrapPart() {
            IEditorPart activeEditor = VpvView.this.getActivePage().getActiveEditor();
            VpvView.this.formRequestToServer(activeEditor);
        }
    }

    private class SelectionListener
    implements ISelectionListener {
        private SelectionListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection && EditorUtil.isInCurrentEditor((IStructuredSelection)((IStructuredSelection)selection), (IEditorPart)VpvView.this.currentEditor)) {
                NavigationUtil.updateSelectionAndScrollToIt((ISelection)selection, (Browser)VpvView.this.browser, (VpvVisualModel)VpvView.this.visualModel);
            }
        }
    }
}

