/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.mylyn.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.commons.ui.ProgressContainer;
import org.eclipse.mylyn.commons.workbench.forms.SectionComposite;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.QueryWizardDialog;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class AbstractRepositoryQueryPage2
extends AbstractRepositoryQueryPage {
    private Button cancelButton;
    private final AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(this.getTaskRepository().getConnectorKind());
    private boolean firstTime = true;
    private SectionComposite innerComposite;
    private boolean needsClear;
    private boolean needsRefresh = true;
    private ProgressContainer progressContainer;
    private Button refreshButton;
    private Text titleText;

    public AbstractRepositoryQueryPage2(String pageName, TaskRepository repository, IRepositoryQuery query) {
        super(pageName, repository, query);
        this.setTitle(Messages.AbstractRepositoryQueryPage2_Enter_query_parameters);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        GridLayout layout = new GridLayout(2, false);
        if (this.inSearchContainer()) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        composite.setLayout((Layout)layout);
        this.createTitleGroup(composite);
        this.innerComposite = new SectionComposite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).span(2, 1).applyTo((Control)this.innerComposite);
        this.createPageContent(this.innerComposite);
        this.createButtonGroup(composite);
        if (!this.needsRefresh) {
            this.setDescription(Messages.AbstractRepositoryQueryPage2_Create_a_Query_Page_Description);
        }
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    @Override
    public String getQueryTitle() {
        return this.titleText != null ? this.titleText.getText() : null;
    }

    public boolean handleExtraButtonPressed(int buttonId) {
        if (buttonId == 2001) {
            if (this.getTaskRepository() != null) {
                this.refreshConfiguration(true);
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AbstractRepositoryQueryPage2_Update_Attributes_Failed, (String)Messages.AbstractRepositoryQueryPage2_No_repository_available_please_add_one_using_the_Task_Repositories_view);
            }
            return true;
        }
        if (buttonId == 2002) {
            this.doClearControls();
            return true;
        }
        return false;
    }

    @Override
    public boolean isPageComplete() {
        if (this.titleText != null && this.titleText.getText().length() > 0) {
            return true;
        }
        this.setMessage(Messages.AbstractRepositoryQueryPage2_Enter_a_title);
        return false;
    }

    public boolean needsClear() {
        return this.needsClear;
    }

    public boolean needsRefresh() {
        return this.needsRefresh;
    }

    @Override
    public boolean performSearch() {
        if (this.inSearchContainer()) {
            this.saveState();
        }
        return super.performSearch();
    }

    @Override
    public void saveState() {
        if (this.inSearchContainer()) {
            RepositoryQuery query = new RepositoryQuery(this.getTaskRepository().getConnectorKind(), "handle");
            this.applyTo((IRepositoryQuery)query);
            IDialogSettings settings = this.getDialogSettings();
            if (settings != null) {
                settings.put(this.getSavedStateSettingKey(), query.getUrl());
            }
        }
    }

    public void setExtraButtonState(Button button) {
        Integer obj = (Integer)button.getData();
        if (obj == 2001) {
            if (this.needsRefresh) {
                if (!button.isVisible()) {
                    button.setVisible(true);
                }
                button.setEnabled(true);
            } else if (button != null && button.isVisible()) {
                button.setVisible(false);
            }
        } else if (obj == 2002) {
            if (!button.isVisible()) {
                button.setVisible(true);
            }
            button.setEnabled(true);
        }
    }

    public void setNeedsClear(boolean needsClearButton) {
        this.needsClear = needsClearButton;
    }

    public void setNeedsRefresh(boolean needsRefresh) {
        this.needsRefresh = needsRefresh;
    }

    public void setQueryTitle(String text) {
        if (this.titleText != null) {
            this.titleText.setText(text);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.getSearchContainer() != null) {
            this.getSearchContainer().setPerformActionEnabled(true);
        }
        if (visible && this.firstTime) {
            this.firstTime = false;
            if (!this.hasRepositoryConfiguration() && this.needsRefresh) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractRepositoryQueryPage2.this.getControl() != null && !AbstractRepositoryQueryPage2.this.getControl().isDisposed()) {
                            AbstractRepositoryQueryPage2.this.initializePage();
                        }
                    }
                });
            } else {
                this.initializePage();
            }
        }
    }

    private void createButtonGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonComposite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)buttonComposite);
        this.createButtons(buttonComposite);
        if (buttonComposite.getChildren().length > 0) {
            layout.numColumns = buttonComposite.getChildren().length;
        } else {
            buttonComposite.dispose();
        }
    }

    private void createTitleGroup(Composite control) {
        if (this.inSearchContainer()) {
            return;
        }
        Label titleLabel = new Label(control, 0);
        titleLabel.setText(Messages.AbstractRepositoryQueryPage2__Title_);
        this.titleText = new Text(control, 2048);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.titleText);
        this.titleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRepositoryQueryPage2.this.getContainer().updateButtons();
            }
        });
    }

    private void initializePage() {
        boolean refreshed;
        if (this.needsRefresh && !(refreshed = this.refreshConfiguration(false)) && !this.innerComposite.isDisposed()) {
            this.doRefreshControls();
        }
        boolean restored = false;
        if (this.getQuery() != null) {
            this.titleText.setText(this.getQuery().getSummary());
            restored |= this.restoreState(this.getQuery());
        } else if (this.inSearchContainer()) {
            restored |= this.restoreSavedState();
        }
        if (!restored && !this.innerComposite.isDisposed()) {
            this.doClearControls();
        }
    }

    protected boolean refreshConfiguration(boolean force) {
        if (force || !this.hasRepositoryConfiguration()) {
            this.setErrorMessage(null);
            try {
                this.doRefreshConfiguration();
                if (!this.innerComposite.isDisposed()) {
                    this.doRefreshControls();
                }
                return true;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    this.setErrorMessage(((CoreException)e.getCause()).getStatus().getMessage());
                } else {
                    this.setErrorMessage(e.getCause().getMessage());
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    private void doRefreshConfiguration() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor = SubMonitor.convert((IProgressMonitor)monitor);
                monitor.beginTask(Messages.AbstractRepositoryQueryPage2_Refresh_Configuration_Button_Label, -1);
                try {
                    try {
                        AbstractRepositoryQueryPage2.this.connector.updateRepositoryConfiguration(AbstractRepositoryQueryPage2.this.getTaskRepository(), monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        if (this.getContainer() != null) {
            this.getContainer().run(true, true, runnable);
        } else if (this.progressContainer != null) {
            this.progressContainer.run(true, true, runnable);
        } else if (this.getSearchContainer() != null) {
            this.getSearchContainer().getRunnableContext().run(true, true, runnable);
        } else {
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            service.busyCursorWhile(runnable);
        }
    }

    protected void createButtons(final Composite composite) {
        if (this.getContainer() instanceof QueryWizardDialog) {
            return;
        }
        if (this.needsRefresh) {
            this.refreshButton = new Button(composite, 8);
            this.refreshButton.setText(Messages.AbstractRepositoryQueryPage2__Refresh_From_Repository);
            this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AbstractRepositoryQueryPage2.this.getTaskRepository() != null) {
                        AbstractRepositoryQueryPage2.this.refreshConfiguration(true);
                    } else {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.AbstractRepositoryQueryPage2_Update_Attributes_Failed, (String)Messages.AbstractRepositoryQueryPage2_No_repository_available_please_add_one_using_the_Task_Repositories_view);
                    }
                }
            });
        }
        if (this.needsClear) {
            Button clearButton = new Button(composite, 8);
            clearButton.setText(Messages.AbstractRepositoryQueryPage2_Clear_Fields);
            clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractRepositoryQueryPage2.this.doClearControls();
                }
            });
        }
        if (this.getContainer() == null) {
            ProgressMonitorPart progressMonitorPart = new ProgressMonitorPart(composite, null);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)progressMonitorPart);
            progressMonitorPart.setVisible(false);
            this.progressContainer = new ProgressContainer(composite.getShell(), progressMonitorPart){

                protected void restoreUiState(Map<Object, Object> state) {
                    AbstractRepositoryQueryPage2.this.cancelButton.setVisible(false);
                    CommonUiUtil.setEnabled((Composite)AbstractRepositoryQueryPage2.this.innerComposite, (boolean)true);
                    Control[] controlArray = composite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof ProgressMonitorPart) break;
                        control.setEnabled(true);
                        ++n2;
                    }
                }

                protected void saveUiState(Map<Object, Object> savedState) {
                    CommonUiUtil.setEnabled((Composite)AbstractRepositoryQueryPage2.this.innerComposite, (boolean)false);
                    Control[] controlArray = composite.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof ProgressMonitorPart) break;
                        control.setEnabled(false);
                        ++n2;
                    }
                    AbstractRepositoryQueryPage2.this.cancelButton.setEnabled(true);
                    AbstractRepositoryQueryPage2.this.cancelButton.setVisible(true);
                }
            };
            this.cancelButton = new Button(composite, 8);
            this.cancelButton.setText(IDialogConstants.CANCEL_LABEL);
            this.cancelButton.setVisible(false);
            this.progressContainer.setCancelButton(this.cancelButton);
        }
    }

    protected abstract void createPageContent(@NonNull SectionComposite var1);

    protected void doClearControls() {
    }

    protected abstract void doRefreshControls();

    protected AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    protected String getSavedStateSettingKey() {
        return String.valueOf(this.getName()) + "." + this.getTaskRepository().getRepositoryUrl();
    }

    protected abstract boolean hasRepositoryConfiguration();

    protected boolean restoreSavedState() {
        String queryUrl;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (queryUrl = settings.get(this.getSavedStateSettingKey())) != null) {
            RepositoryQuery query = new RepositoryQuery(this.getTaskRepository().getConnectorKind(), "handle");
            query.setUrl(queryUrl);
            return this.restoreState((IRepositoryQuery)query);
        }
        return false;
    }

    protected abstract boolean restoreState(@NonNull IRepositoryQuery var1);

    public void reflow() {
        this.innerComposite.resizeAndReflow();
    }
}

