/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.models.switchyard1_0.bpm;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OperationType implements Enumerator
{
    STARTPROCESS(0, "STARTPROCESS", "START_PROCESS"),
    SIGNALEVENT(1, "SIGNALEVENT", "SIGNAL_EVENT"),
    SIGNALEVENTALL(2, "SIGNALEVENTALL", "SIGNAL_EVENT_ALL"),
    ABORTPROCESSINSTANCE(3, "ABORTPROCESSINSTANCE", "ABORT_PROCESS_INSTANCE");

    public static final int STARTPROCESS_VALUE = 0;
    public static final int SIGNALEVENT_VALUE = 1;
    public static final int SIGNALEVENTALL_VALUE = 2;
    public static final int ABORTPROCESSINSTANCE_VALUE = 3;
    private static final OperationType[] VALUES_ARRAY;
    public static final List<OperationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OperationType[]{STARTPROCESS, SIGNALEVENT, SIGNALEVENTALL, ABORTPROCESSINSTANCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OperationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperationType get(int value) {
        switch (value) {
            case 0: {
                return STARTPROCESS;
            }
            case 1: {
                return SIGNALEVENT;
            }
            case 2: {
                return SIGNALEVENTALL;
            }
            case 3: {
                return ABORTPROCESSINSTANCE;
            }
        }
        return null;
    }

    private OperationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

