/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql.spi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.jpql.spi.ClassConstructor;
import org.eclipse.jpt.jpa.core.jpql.spi.IJpaType;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaConstructor;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeDeclaration;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeRepository;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.tools.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaType
implements IJpaType {
    private Collection<IConstructor> constructors;
    private String[] enumConstants;
    private IType type;
    private ITypeBinding typeBinding;
    private boolean typeBindingResolved;
    private ITypeDeclaration typeDeclaration;
    private ITypeHierarchy typeHierarchy;
    private final String typeName;
    private final JpaTypeRepository typeRepository;

    public JpaType(JpaTypeRepository typeRepository, IType type) {
        this.type = type;
        this.typeName = type.getFullyQualifiedName();
        this.typeRepository = typeRepository;
    }

    protected CompilationUnit buildCompilationUnit() {
        ASTParser parser = ASTTools.newParser();
        parser.setSource(this.type.getTypeRoot());
        return (CompilationUnit)parser.createAST(null);
    }

    protected Collection<IConstructor> buildConstructors() {
        ITypeBinding typeBinding = this.getTypeBinding();
        if (typeBinding == null && this.type.isBinary()) {
            ArrayList<IConstructor> constructors = new ArrayList<IConstructor>();
            try {
                IJavaElement[] iJavaElementArray = this.type.getTypeRoot().getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement rootType = iJavaElementArray[n2];
                    if (rootType.getElementType() == 7) {
                        IJavaElement[] iJavaElementArray2 = ((IType)rootType).getChildren();
                        int n3 = iJavaElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMethod method;
                            IJavaElement javaElement = iJavaElementArray2[n4];
                            if (javaElement.getElementType() == 9 && (method = (IMethod)javaElement).isConstructor()) {
                                constructors.add(new ClassConstructor(this, method));
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                JptJpaCorePlugin.instance().logError(e);
            }
            return constructors;
        }
        if (typeBinding != null) {
            ArrayList<IConstructor> constructors = new ArrayList<IConstructor>();
            IMethodBinding[] iMethodBindingArray = typeBinding.getDeclaredMethods();
            int n = iMethodBindingArray.length;
            int n5 = 0;
            while (n5 < n) {
                IMethodBinding method = iMethodBindingArray[n5];
                if (method.isConstructor()) {
                    constructors.add(new JpaConstructor(this, method));
                }
                ++n5;
            }
            return constructors;
        }
        return Collections.emptyList();
    }

    protected String[] buildEnumConstants() {
        try {
            if (this.type.isEnum()) {
                ArrayList<String> names = new ArrayList<String>();
                IField[] iFieldArray = this.type.getFields();
                int n = iFieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    if (field.isEnumConstant()) {
                        names.add(field.getElementName());
                    }
                    ++n2;
                }
                return names.toArray(new String[names.size()]);
            }
        }
        catch (Exception exception) {}
        return ExpressionTools.EMPTY_STRING_ARRAY;
    }

    protected ITypeBinding buildTypeBinding() {
        try {
            CompilationUnit compilationUnit = this.buildCompilationUnit();
            if (this.type.isAnonymous()) {
                IJavaElement parent = this.type.getParent();
                if (parent instanceof IField && Flags.isEnum((int)((IMember)parent).getFlags())) {
                    AnonymousClassDeclaration declaration;
                    ASTNode node = NodeFinder.perform((ASTNode)compilationUnit, (ISourceRange)this.type.getNameRange());
                    EnumConstantDeclaration constant = (EnumConstantDeclaration)node;
                    if (constant != null && (declaration = constant.getAnonymousClassDeclaration()) != null) {
                        return declaration.resolveBinding();
                    }
                } else {
                    ASTNode node = NodeFinder.perform((ASTNode)compilationUnit, (ISourceRange)this.type.getNameRange());
                    ClassInstanceCreation creation = (ClassInstanceCreation)this.getParent(node, ClassInstanceCreation.class);
                    if (creation != null) {
                        return creation.resolveTypeBinding();
                    }
                }
            } else {
                ASTNode node = NodeFinder.perform((ASTNode)compilationUnit, (ISourceRange)this.type.getNameRange());
                AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)this.getParent(node, AbstractTypeDeclaration.class);
                if (declaration != null) {
                    return declaration.resolveBinding();
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected ITypeDeclaration buildTypeDeclaration() {
        return new JpaTypeDeclaration(this, new ITypeDeclaration[0]);
    }

    public Iterable<IConstructor> constructors() {
        if (this.constructors == null) {
            this.constructors = this.buildConstructors();
        }
        return IterableTools.cloneSnapshot(this.constructors);
    }

    public boolean equals(Object object) {
        return this.equals((org.eclipse.persistence.jpa.jpql.tools.spi.IType)object);
    }

    public boolean equals(org.eclipse.persistence.jpa.jpql.tools.spi.IType type) {
        return this == type || this.typeName.equals(type.getName());
    }

    public String[] getEnumConstants() {
        if (this.enumConstants == null) {
            this.enumConstants = this.buildEnumConstants();
        }
        return this.enumConstants;
    }

    public String getName() {
        return this.typeName;
    }

    protected ASTNode getParent(ASTNode node, Class<? extends ASTNode> parentClass) {
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return node;
    }

    protected IType getType() {
        return this.type;
    }

    protected ITypeBinding getTypeBinding() {
        if (this.typeBinding == null && !this.typeBindingResolved) {
            this.typeBinding = this.buildTypeBinding();
            this.typeBindingResolved = true;
        }
        return this.typeBinding;
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.buildTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    protected JpaTypeRepository getTypeRepository() {
        return this.typeRepository;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.type.getAnnotation(annotationType.getName()) != null;
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    public boolean isAssignableTo(org.eclipse.persistence.jpa.jpql.tools.spi.IType otherType) {
        if (this.equals(otherType)) {
            return true;
        }
        String otherTypeName = otherType.getName();
        ITypeBinding typeBinding = this.getTypeBinding();
        if (typeBinding == null && this.type.isBinary()) {
            if (this.typeHierarchy == null) {
                try {
                    this.typeHierarchy = this.type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception exception) {
                    return false;
                }
            }
            IType[] iTypeArray = this.typeHierarchy.getAllTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType superType = iTypeArray[n2];
                if (superType.getFullyQualifiedName().equals(otherTypeName)) {
                    return true;
                }
                ++n2;
            }
        } else if (typeBinding != null) {
            return ASTTools.typeIsSubTypeOf((ITypeBinding)typeBinding, (String)otherTypeName);
        }
        return false;
    }

    public boolean isEnum() {
        try {
            return this.type.isEnum();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isResolvable() {
        return true;
    }

    @Override
    public void setTypeDeclaration(JpaTypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.typeName);
    }
}

