/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.ArrayList;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.context.DatabaseGenerator;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.SpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaGeneratorContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaDatabaseGenerator;
import org.eclipse.jpt.jpa.core.resource.java.TableGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaTableGenerator
extends AbstractJavaDatabaseGenerator<TableGeneratorAnnotation>
implements JavaTableGenerator,
SpecifiedUniqueConstraint.Parent {
    protected String specifiedTableName;
    protected String defaultTableName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedPkColumnName;
    protected String defaultPkColumnName;
    protected String specifiedValueColumnName;
    protected String defaultValueColumnName;
    protected String specifiedPkColumnValue;
    protected String defaultPkColumnValue;
    protected final AbstractJpaContextModel.ContextListContainer<JavaSpecifiedUniqueConstraint, UniqueConstraintAnnotation> uniqueConstraintContainer;

    public GenericJavaTableGenerator(JavaGeneratorContainer parent, TableGeneratorAnnotation generatorAnnotation) {
        super(parent, generatorAnnotation);
        this.specifiedTableName = generatorAnnotation.getTable();
        this.specifiedSchema = generatorAnnotation.getSchema();
        this.specifiedCatalog = generatorAnnotation.getCatalog();
        this.specifiedPkColumnName = generatorAnnotation.getPkColumnName();
        this.specifiedValueColumnName = generatorAnnotation.getValueColumnName();
        this.specifiedPkColumnValue = generatorAnnotation.getPkColumnValue();
        this.uniqueConstraintContainer = this.buildUniqueConstraintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedTableName_(((TableGeneratorAnnotation)this.generatorAnnotation).getTable());
        this.setSpecifiedSchema_(((TableGeneratorAnnotation)this.generatorAnnotation).getSchema());
        this.setSpecifiedCatalog_(((TableGeneratorAnnotation)this.generatorAnnotation).getCatalog());
        this.setSpecifiedPkColumnName_(((TableGeneratorAnnotation)this.generatorAnnotation).getPkColumnName());
        this.setSpecifiedValueColumnName_(((TableGeneratorAnnotation)this.generatorAnnotation).getValueColumnName());
        this.setSpecifiedPkColumnValue_(((TableGeneratorAnnotation)this.generatorAnnotation).getPkColumnValue());
        this.syncUniqueConstraints();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultTableName(this.buildDefaultTableName());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setDefaultPkColumnName(this.buildDefaultPkColumnName());
        this.setDefaultValueColumnName(this.buildDefaultValueColumnName());
        this.setDefaultPkColumnValue(this.buildDefaultPkColumnValue());
        this.updateModels((Iterable<? extends JpaContextModel>)this.getUniqueConstraints());
    }

    @Override
    protected int buildDefaultInitialValue() {
        return 0;
    }

    @Override
    public String getTableName() {
        return this.specifiedTableName != null ? this.specifiedTableName : this.defaultTableName;
    }

    @Override
    public String getSpecifiedTableName() {
        return this.specifiedTableName;
    }

    @Override
    public void setSpecifiedTableName(String tableName) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setTable(tableName);
        this.setSpecifiedTableName_(tableName);
    }

    protected void setSpecifiedTableName_(String tableName) {
        String old = this.specifiedTableName;
        this.specifiedTableName = tableName;
        this.firePropertyChanged("specifiedTableName", old, tableName);
    }

    @Override
    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    protected void setDefaultTableName(String tableName) {
        String old = this.defaultTableName;
        this.defaultTableName = tableName;
        this.firePropertyChanged("defaultTableName", old, tableName);
    }

    protected String buildDefaultTableName() {
        return null;
    }

    @Override
    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getTableName());
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setSchema(schema);
        this.setSpecifiedSchema_(schema);
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setCatalog(catalog);
        this.setSpecifiedCatalog_(catalog);
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public String getPkColumnName() {
        return this.specifiedPkColumnName != null ? this.specifiedPkColumnName : this.defaultPkColumnName;
    }

    @Override
    public String getSpecifiedPkColumnName() {
        return this.specifiedPkColumnName;
    }

    @Override
    public void setSpecifiedPkColumnName(String name) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setPkColumnName(name);
        this.setSpecifiedPkColumnName_(name);
    }

    protected void setSpecifiedPkColumnName_(String name) {
        String old = this.specifiedPkColumnName;
        this.specifiedPkColumnName = name;
        this.firePropertyChanged("specifiedPkColumnName", old, name);
    }

    @Override
    public String getDefaultPkColumnName() {
        return this.defaultPkColumnName;
    }

    protected void setDefaultPkColumnName(String name) {
        String old = this.defaultPkColumnName;
        this.defaultPkColumnName = name;
        this.firePropertyChanged("defaultPkColumnName", old, name);
    }

    protected String buildDefaultPkColumnName() {
        return null;
    }

    @Override
    public String getValueColumnName() {
        return this.specifiedValueColumnName != null ? this.specifiedValueColumnName : this.defaultValueColumnName;
    }

    @Override
    public String getSpecifiedValueColumnName() {
        return this.specifiedValueColumnName;
    }

    @Override
    public void setSpecifiedValueColumnName(String name) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setValueColumnName(name);
        this.setSpecifiedValueColumnName_(name);
    }

    protected void setSpecifiedValueColumnName_(String name) {
        String old = this.specifiedValueColumnName;
        this.specifiedValueColumnName = name;
        this.firePropertyChanged("specifiedValueColumnName", old, name);
    }

    @Override
    public String getDefaultValueColumnName() {
        return this.defaultValueColumnName;
    }

    protected void setDefaultValueColumnName(String name) {
        String old = this.defaultValueColumnName;
        this.defaultValueColumnName = name;
        this.firePropertyChanged("defaultValueColumnName", old, name);
    }

    protected String buildDefaultValueColumnName() {
        return null;
    }

    @Override
    public String getPkColumnValue() {
        return this.specifiedPkColumnValue != null ? this.specifiedPkColumnValue : this.defaultPkColumnValue;
    }

    @Override
    public String getSpecifiedPkColumnValue() {
        return this.specifiedPkColumnValue;
    }

    @Override
    public void setSpecifiedPkColumnValue(String value) {
        ((TableGeneratorAnnotation)this.generatorAnnotation).setPkColumnValue(value);
        this.setSpecifiedPkColumnValue_(value);
    }

    protected void setSpecifiedPkColumnValue_(String value) {
        String old = this.specifiedPkColumnValue;
        this.specifiedPkColumnValue = value;
        this.firePropertyChanged("specifiedPkColummValue", old, value);
    }

    @Override
    public String getDefaultPkColumnValue() {
        return this.defaultPkColumnValue;
    }

    protected void setDefaultPkColumnValue(String value) {
        String old = this.defaultPkColumnValue;
        this.defaultPkColumnValue = value;
        this.firePropertyChanged("defaultPkColummValue", old, value);
    }

    protected String buildDefaultPkColumnValue() {
        return null;
    }

    public ListIterable<JavaSpecifiedUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraintContainer;
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintContainer.size();
    }

    @Override
    public JavaSpecifiedUniqueConstraint getUniqueConstraint(int index) {
        return (JavaSpecifiedUniqueConstraint)this.uniqueConstraintContainer.get(index);
    }

    @Override
    public JavaSpecifiedUniqueConstraint addUniqueConstraint() {
        return this.addUniqueConstraint(this.getUniqueConstraintsSize());
    }

    @Override
    public JavaSpecifiedUniqueConstraint addUniqueConstraint(int index) {
        UniqueConstraintAnnotation annotation = ((TableGeneratorAnnotation)this.getGeneratorAnnotation()).addUniqueConstraint(index);
        return (JavaSpecifiedUniqueConstraint)this.uniqueConstraintContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        ((TableGeneratorAnnotation)this.getGeneratorAnnotation()).removeUniqueConstraint(index);
        this.uniqueConstraintContainer.remove(index);
    }

    @Override
    public void removeUniqueConstraint(SpecifiedUniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraintContainer.indexOf((JavaSpecifiedUniqueConstraint)uniqueConstraint));
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        ((TableGeneratorAnnotation)this.getGeneratorAnnotation()).moveUniqueConstraint(targetIndex, sourceIndex);
        this.uniqueConstraintContainer.move(targetIndex, sourceIndex);
    }

    protected void syncUniqueConstraints() {
        this.uniqueConstraintContainer.synchronizeWithResourceModel();
    }

    protected void updateUniqueConstraints() {
        this.uniqueConstraintContainer.synchronizeWithResourceModel();
    }

    protected JavaSpecifiedUniqueConstraint buildUniqueConstraint(UniqueConstraintAnnotation constraintAnnotation) {
        return this.getJpaFactory().buildJavaUniqueConstraint(this, constraintAnnotation);
    }

    protected ListIterable<UniqueConstraintAnnotation> getUniqueConstraintAnnotations() {
        return ((TableGeneratorAnnotation)this.getGeneratorAnnotation()).getUniqueConstraints();
    }

    protected AbstractJpaContextModel.ContextListContainer<JavaSpecifiedUniqueConstraint, UniqueConstraintAnnotation> buildUniqueConstraintContainer() {
        return this.buildSpecifiedContextListContainer("uniqueConstraints", new UniqueConstraintContainerAdapter());
    }

    @Override
    public Iterable<String> getCandidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (JavaSpecifiedUniqueConstraint constraint : this.getUniqueConstraints()) {
            result = constraint.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos)) {
            return this.getJavaCandidateTables();
        }
        if (this.schemaTouches(pos)) {
            return this.getJavaCandidateSchemata();
        }
        if (this.pkColumnNameTouches(pos)) {
            return this.getJavaCandidateColumnNames();
        }
        if (this.valueColumnNameTouches(pos)) {
            return this.getJavaCandidateColumnNames();
        }
        return null;
    }

    protected boolean tableTouches(int pos) {
        return ((TableGeneratorAnnotation)this.generatorAnnotation).tableTouches(pos);
    }

    protected Iterable<String> getJavaCandidateTables() {
        return new TransformationIterable(this.getCandidateTables(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateTables() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedTableIdentifiers() : EmptyIterable.instance();
    }

    protected boolean schemaTouches(int pos) {
        return ((TableGeneratorAnnotation)this.generatorAnnotation).schemaTouches(pos);
    }

    protected Iterable<String> getJavaCandidateSchemata() {
        return new TransformationIterable(this.getCandidateSchemata(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateSchemata() {
        SchemaContainer schemaContainer = this.getDbSchemaContainer();
        return schemaContainer != null ? schemaContainer.getSortedSchemaIdentifiers() : EmptyIterable.instance();
    }

    protected boolean catalogTouches(int pos) {
        return ((TableGeneratorAnnotation)this.generatorAnnotation).catalogTouches(pos);
    }

    protected Iterable<String> getJavaCandidateCatalogs(Predicate<String> filter) {
        return new TransformationIterable(this.getCandidateCatalogs(filter), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateCatalogs(Predicate<String> filter) {
        return IterableTools.filter(this.getCandidateCatalogs(), filter);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    protected boolean pkColumnNameTouches(int pos) {
        return ((TableGeneratorAnnotation)this.generatorAnnotation).pkColumnNameTouches(pos);
    }

    protected Iterable<String> getJavaCandidateColumnNames() {
        return new TransformationIterable(this.getCandidateColumnNames(), StringTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER);
    }

    protected Iterable<String> getCandidateColumnNames() {
        Table table = this.getDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    protected boolean valueColumnNameTouches(int pos) {
        return ((TableGeneratorAnnotation)this.generatorAnnotation).valueColumnNameTouches(pos);
    }

    @Override
    public void convertTo(EntityMappings entityMappings) {
        entityMappings.addTableGenerator().convertFrom(this);
    }

    @Override
    public void delete() {
        ((JavaGeneratorContainer)this.parent).removeTableGenerator();
    }

    @Override
    public Class<TableGenerator> getGeneratorType() {
        return TableGenerator.class;
    }

    @Override
    protected boolean isEquivalentTo_(DatabaseGenerator other) {
        return super.isEquivalentTo_(other) && this.isEquivalentTo_((TableGenerator)other);
    }

    protected boolean isEquivalentTo_(TableGenerator other) {
        return ObjectTools.equals((Object)this.specifiedTableName, (Object)other.getSpecifiedTableName()) && ObjectTools.equals((Object)this.specifiedSchema, (Object)other.getSpecifiedSchema()) && ObjectTools.equals((Object)this.specifiedCatalog, (Object)other.getSpecifiedCatalog()) && ObjectTools.equals((Object)this.specifiedPkColumnName, (Object)other.getSpecifiedPkColumnName()) && ObjectTools.equals((Object)this.specifiedPkColumnValue, (Object)other.getSpecifiedPkColumnValue()) && ObjectTools.equals((Object)this.specifiedValueColumnName, (Object)other.getSpecifiedValueColumnName()) && this.uniqueConstraintsAreEquivalentTo(other);
    }

    protected boolean uniqueConstraintsAreEquivalentTo(TableGenerator generator) {
        ArrayList uniqueConstraints1 = ListTools.list(this.getUniqueConstraints());
        ArrayList uniqueConstraints2 = ListTools.list(generator.getUniqueConstraints());
        if (uniqueConstraints1.size() != uniqueConstraints2.size()) {
            return false;
        }
        int i = 0;
        while (i < uniqueConstraints1.size()) {
            if (!((JavaSpecifiedUniqueConstraint)uniqueConstraints1.get(i)).isEquivalentTo((SpecifiedUniqueConstraint)uniqueConstraints2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class UniqueConstraintContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<JavaSpecifiedUniqueConstraint, UniqueConstraintAnnotation> {
        @Override
        public JavaSpecifiedUniqueConstraint buildContextElement(UniqueConstraintAnnotation resourceElement) {
            return GenericJavaTableGenerator.this.buildUniqueConstraint(resourceElement);
        }

        @Override
        public ListIterable<UniqueConstraintAnnotation> getResourceElements() {
            return GenericJavaTableGenerator.this.getUniqueConstraintAnnotations();
        }

        @Override
        public UniqueConstraintAnnotation extractResourceElement(JavaSpecifiedUniqueConstraint contextElement) {
            return contextElement.getUniqueConstraintAnnotation();
        }
    }
}

