/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppDeploymentDescriptor;
import org.eclipse.jst.javaee.web.WebFactory;
import org.jboss.tools.ws.jaxrs.core.wtp.WtpUtils;

public class JaxrsElementCreationUtils {
    private JaxrsElementCreationUtils() {
    }

    public static IPackageFragment getSuggestedPackage(ICompilationUnit compilationUnit) {
        IPackageFragment selectedPackage = (IPackageFragment)compilationUnit.getAncestor(4);
        return JaxrsElementCreationUtils.getSuggestedPackage(selectedPackage);
    }

    public static IPackageFragment getSuggestedPackage(IPackageFragment selectedPackage) {
        IPath selectedPackagePath = selectedPackage.getPath();
        IPackageFragmentRoot selectedSourceFolder = (IPackageFragmentRoot)selectedPackage.getAncestor(3);
        if (selectedPackage.isDefaultPackage()) {
            return selectedSourceFolder.getPackageFragment("rest");
        }
        String suggestedPackageName = selectedPackagePath.removeLastSegments(1).append("rest").makeRelativeTo(selectedSourceFolder.getPath()).toString().replace("/", ".");
        return selectedSourceFolder.getPackageFragment(suggestedPackageName);
    }

    public static void addAnnotation(IMember member, String annotationFullyQualifiedName, List<String> annotationValues, NewTypeWizardPage.ImportsManager imports) throws JavaModelException {
        ISourceRange sourceRange = member.getSourceRange();
        ISourceRange javaDocRange = member.getJavadocRange();
        IBuffer buf = member.getCompilationUnit().getBuffer();
        String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)member.getJavaProject());
        StringBuffer sb = new StringBuffer();
        String annotationSimpleName = JaxrsElementCreationUtils.getSimpleName(annotationFullyQualifiedName);
        imports.addImport(annotationFullyQualifiedName);
        sb.append("@").append(annotationSimpleName);
        if (annotationValues != null && !annotationValues.isEmpty()) {
            sb.append('(');
            if (annotationValues.size() > 1) {
                sb.append('{');
            }
            Iterator<String> iterator = annotationValues.iterator();
            while (iterator.hasNext()) {
                sb.append('\"').append(iterator.next()).append('\"');
                if (!iterator.hasNext()) continue;
                sb.append(',');
            }
            if (annotationValues.size() > 1) {
                sb.append('}');
            }
            sb.append(")");
        }
        sb.append(lineDelimiter);
        if (javaDocRange == null) {
            buf.replace(sourceRange.getOffset(), 0, sb.toString());
        } else {
            buf.replace(javaDocRange.getOffset() + javaDocRange.getLength() + lineDelimiter.length(), 0, sb.toString());
        }
        JavaModelUtil.reconcile((ICompilationUnit)member.getCompilationUnit());
    }

    public static String getSimpleName(String annotationFullyQualifiedName) {
        int i = annotationFullyQualifiedName.lastIndexOf(46);
        String annotationSimpleName = annotationFullyQualifiedName.substring(i + 1);
        return annotationSimpleName;
    }

    public static WebApp getWebApp(IJavaProject javaProject) throws CoreException {
        if (WtpUtils.hasWebDeploymentDescriptor((IProject)javaProject.getProject())) {
            return (WebApp)ModelProviderManager.getModelProvider((IProject)javaProject.getProject()).getModelObject();
        }
        WebAppDeploymentDescriptor deploymentDescriptor = WebFactory.eINSTANCE.createWebAppDeploymentDescriptor();
        WebApp webApp = WebFactory.eINSTANCE.createWebApp();
        deploymentDescriptor.setWebApp(webApp);
        return webApp;
    }
}

