/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.navigation;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class JaxrsNameBindingAnnotationHyperlink
implements IHyperlink {
    private final IJaxrsJavaElement targetElement;
    private final IRegion hyperlinkRegion;

    public JaxrsNameBindingAnnotationHyperlink(IJaxrsJavaElement targetElement, IRegion hyperlinkRegion) {
        this.targetElement = targetElement;
        this.hyperlinkRegion = hyperlinkRegion;
    }

    public IRegion getHyperlinkRegion() {
        return this.hyperlinkRegion;
    }

    public String getTypeLabel() {
        return this.getHyperlinkText();
    }

    public String getHyperlinkText() {
        return "Jump to " + JaxrsNameBindingAnnotationHyperlink.getDisplayNameText(this.targetElement);
    }

    public static String getDisplayNameText(IJaxrsJavaElement element) {
        if (element instanceof IJaxrsJavaElement) {
            IJavaElement javaElement = element.getJavaElement();
            if (javaElement.getElementType() == 7) {
                return ((IType)javaElement).getFullyQualifiedName();
            }
            return String.valueOf(((IJaxrsResourceMethod)element).getParentResource().getJavaElement().getFullyQualifiedName()) + '.' + javaElement.getElementName() + "(...)";
        }
        return element.getName();
    }

    public void open() {
        try {
            JavaUI.openInEditor((IJavaElement)this.targetElement.getJavaElement());
        }
        catch (PartInitException e) {
            Logger.error("Failed to open " + JaxrsNameBindingAnnotationHyperlink.getDisplayNameText(this.targetElement) + " in a Java Editor", e);
        }
        catch (JavaModelException e) {
            Logger.error("Failed to open " + JaxrsNameBindingAnnotationHyperlink.getDisplayNameText(this.targetElement) + " in a Java Editor", e);
        }
    }
}

