/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.AnnotationUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsProvider;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceField;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourceFieldValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourceMethodValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourcePropertyValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsResourceValidatorDelegate
extends AbstractJaxrsElementValidatorDelegate<JaxrsResource> {
    private final IMarkerManager markerManager;

    public JaxrsResourceValidatorDelegate(IMarkerManager markerManager) {
        this.markerManager = markerManager;
    }

    @Override
    void internalValidate(JaxrsResource resource) throws CoreException {
        Logger.debug("Validating element {}", resource);
        this.validatePathAnnotationValue(resource);
        this.validateAtLeastOneProviderWithBinding(resource);
        for (IJaxrsResourceMethod resourceMethod : resource.getAllMethods()) {
            new JaxrsResourceMethodValidatorDelegate(this.markerManager).validate((JaxrsResourceMethod)resourceMethod, false);
        }
        for (IJaxrsResourceField resourceField : resource.getAllFields()) {
            new JaxrsResourceFieldValidatorDelegate(this.markerManager).validate((JaxrsResourceField)resourceField, false);
        }
        for (IJaxrsResourceProperty resourceProperty : resource.getAllProperties()) {
            new JaxrsResourcePropertyValidatorDelegate(this.markerManager).validate((JaxrsResourceProperty)resourceProperty, false);
        }
    }

    private void validatePathAnnotationValue(JaxrsResource resource) throws JavaModelException, CoreException {
        Annotation pathAnnotation = resource.getPathAnnotation();
        if (pathAnnotation != null && pathAnnotation.getValue() != null && !AnnotationUtils.isValidAnnotationValue((String)pathAnnotation.getValue())) {
            ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathAnnotation.getJavaAnnotation(), (String)"value");
            this.markerManager.addMarker((JaxrsBaseElement)resource, range, JaxrsValidationMessages.RESOURCE_INVALID_PATH_ANNOTATION_VALUE, new String[]{pathAnnotation.getValue()}, JaxrsPreferences.RESOURCE_INVALID_PATH_ANNOTATION_VALUE);
        }
    }

    private void validateAtLeastOneProviderWithBinding(JaxrsResource resource) throws CoreException {
        if (resource == null) {
            return;
        }
        Map nameBindingAnnotations = resource.getNameBindingAnnotations();
        if (nameBindingAnnotations.isEmpty()) {
            return;
        }
        JaxrsMetamodel metamodel = resource.getMetamodel();
        String firstNameBindingAnnotationClassName = (String)nameBindingAnnotations.keySet().iterator().next();
        Set allBindingAnnotationNames = nameBindingAnnotations.keySet();
        Set annotatedProviders = metamodel.findProvidersByAnnotation(firstNameBindingAnnotationClassName);
        for (IJaxrsProvider provider : annotatedProviders) {
            if (!provider.getNameBindingAnnotations().keySet().equals(allBindingAnnotationNames)) continue;
            return;
        }
        ISourceRange nameRange = ((Annotation)nameBindingAnnotations.get(firstNameBindingAnnotationClassName)).getJavaAnnotation().getNameRange();
        this.markerManager.addMarker((JaxrsBaseElement)resource, nameRange, JaxrsValidationMessages.PROVIDER_MISSING_BINDING, new String[]{firstNameBindingAnnotationClassName}, JaxrsPreferences.PROVIDER_MISSING_BINDING);
    }

    private void validateConstructorParameters() {
    }
}

