/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResource;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceMethod;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsResourceProperty;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsParameterValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsResourcePropertyValidatorDelegate
extends AbstractJaxrsElementValidatorDelegate<JaxrsResourceProperty> {
    private final IMarkerManager markerManager;

    public JaxrsResourcePropertyValidatorDelegate(IMarkerManager markerManager) {
        this.markerManager = markerManager;
    }

    @Override
    void internalValidate(JaxrsResourceProperty resourceProperty) throws CoreException {
        Logger.debug("Validating element {}", resourceProperty);
        this.validateParameterType(resourceProperty);
        this.validateNotUnboundPathParamAnnotationValue(resourceProperty);
    }

    private void validateNotUnboundPathParamAnnotationValue(JaxrsResourceProperty resourceProperty) throws CoreException {
        Annotation pathParamAnnotation = resourceProperty.getPathParamAnnotation();
        if (pathParamAnnotation == null) {
            return;
        }
        JaxrsResource parentResource = resourceProperty.getParentResource();
        HashSet pathTemplateParameters = new HashSet();
        pathTemplateParameters.addAll(parentResource.getPathTemplateParameters().keySet());
        Collection resourceMethods = parentResource.getMethods().values();
        for (JaxrsResourceMethod resourceMethod : resourceMethods) {
            pathTemplateParameters.addAll(resourceMethod.getPathTemplateParameters().keySet());
        }
        if (!pathTemplateParameters.contains(pathParamAnnotation.getValue())) {
            ISourceRange annotationValueRange = JdtUtils.resolveMemberPairValueRange((IAnnotation)pathParamAnnotation.getJavaAnnotation(), (String)"value");
            this.markerManager.addMarker((JaxrsBaseElement)resourceProperty, annotationValueRange, JaxrsValidationMessages.RESOURCE_FIELD_UNBOUND_PATHPARAM_ANNOTATION_VALUE, new String[]{pathParamAnnotation.getValue(), ((IType)parentResource.getJavaElement()).getFullyQualifiedName()}, JaxrsPreferences.RESOURCE_FIELD_UNBOUND_PATHPARAM_ANNOTATION_VALUE);
        }
    }

    private void validateParameterType(JaxrsResourceProperty resourceProperty) throws CoreException {
        Set allParamConverterProviders = resourceProperty.getMetamodel().findAllParamConverterProviders();
        if (allParamConverterProviders != null && !allParamConverterProviders.isEmpty()) {
            return;
        }
        JaxrsParameterValidatorDelegate parameterValidatorDelegate = new JaxrsParameterValidatorDelegate();
        SourceType type = resourceProperty.getType();
        if (!type.exists()) {
            return;
        }
        boolean isValid = parameterValidatorDelegate.validate(type);
        if (!isValid) {
            this.markerManager.addMarker((JaxrsBaseElement)resourceProperty, ((IMethod)resourceProperty.getJavaElement()).getNameRange(), JaxrsValidationMessages.RESOURCE_METHOD_INVALID_ANNOTATED_PARAMETER_TYPE, new String[]{type.getErasureName()}, JaxrsPreferences.RESOURCE_METHOD_INVALID_ANNOTATED_PARAMETER_TYPE);
        }
    }
}

