/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.jboss.tools.ws.jaxrs.core.jdt.SourceType;

public class JaxrsParameterValidatorDelegate {
    public boolean validate(SourceType type) throws CoreException {
        if (type.isPrimitive()) {
            return true;
        }
        if (this.validate(type.getErasureType())) {
            return true;
        }
        String erasureQualifiedName = type.getErasureType().getFullyQualifiedName();
        if (erasureQualifiedName.equals(Set.class.getName()) || erasureQualifiedName.equals(List.class.getName()) || erasureQualifiedName.equals(SortedSet.class.getName())) {
            for (IType typeArgument : type.getTypeArguments()) {
                if (!this.validate(typeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validate(IType type) throws JavaModelException {
        String qualifiedName = type.getFullyQualifiedName();
        String simpleName = Signature.getSimpleName((String)qualifiedName);
        String[] stringArray = new String[]{Signature.createTypeSignature((String)"String", (boolean)false), Signature.createTypeSignature((String)"String", (boolean)true), Signature.createTypeSignature((String)"java.lang.String", (boolean)false), Signature.createTypeSignature((String)"java.lang.String", (boolean)true)};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String singleStringParameter = stringArray[n2];
            if (type.getMethod(simpleName, new String[]{singleStringParameter}).exists()) {
                return true;
            }
            String[] stringArray2 = new String[]{Signature.createTypeSignature((String)simpleName, (boolean)false), Signature.createTypeSignature((String)qualifiedName, (boolean)false), Signature.createTypeSignature((String)qualifiedName, (boolean)true)};
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String expectedReturnType = stringArray2[n4];
                IMethod fromStringMethod = type.getMethod("fromString", new String[]{singleStringParameter});
                if (fromStringMethod.exists() && JaxrsParameterValidatorDelegate.isStatic(fromStringMethod) && fromStringMethod.getReturnType().equals(expectedReturnType)) {
                    return true;
                }
                IMethod valueOfMethod = type.getMethod("valueOf", new String[]{singleStringParameter});
                if (valueOfMethod.exists() && JaxrsParameterValidatorDelegate.isStatic(valueOfMethod) && valueOfMethod.getReturnType().equals(expectedReturnType)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    private static boolean isStatic(IMethod method) throws JavaModelException {
        return (method.getFlags() & 8) > 0;
    }
}

