/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsParamConverterProvider;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.CompilationUnitsRepository;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodParameter;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJavaMethodSignature;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsParamConverterProviderValidatorDelegate
extends AbstractJaxrsElementValidatorDelegate<JaxrsParamConverterProvider> {
    private final IMarkerManager markerManager;

    public JaxrsParamConverterProviderValidatorDelegate(IMarkerManager markerManager) {
        this.markerManager = markerManager;
    }

    @Override
    void internalValidate(JaxrsParamConverterProvider provider) throws CoreException {
        Logger.debug("Validating element {}", provider);
        this.validateAtLeastOneValidConstructor(provider);
        this.validateNoMissingProviderAnnotation(provider);
    }

    private void validateAtLeastOneValidConstructor(JaxrsParamConverterProvider provider) throws CoreException {
        IType providerType = (IType)provider.getJavaElement();
        IMethod[] methods = providerType.getMethods();
        int validConstructorsCounter = 0;
        boolean hasConstructors = false;
        IMethod[] iMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (JaxrsParamConverterProviderValidatorDelegate.isContructor(method)) {
                hasConstructors = true;
                if (JaxrsParamConverterProviderValidatorDelegate.isValidConstructor(method)) {
                    ++validConstructorsCounter;
                }
            }
            ++n2;
        }
        if (hasConstructors && validConstructorsCounter == 0) {
            ISourceRange nameRange = providerType.getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)provider, nameRange, JaxrsValidationMessages.PROVIDER_MISSING_VALID_CONSTRUCTOR, new String[0], JaxrsPreferences.PROVIDER_MISSING_VALID_CONSTRUCTOR);
        }
    }

    private static boolean isContructor(IMethod method) {
        return method.getElementName().equals(method.getParent().getElementName());
    }

    private static boolean isValidConstructor(IMethod method) throws JavaModelException {
        if ((method.getFlags() & 1) == 0) {
            return false;
        }
        ILocalVariable[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return true;
        }
        IJavaMethodSignature methodSignature = CompilationUnitsRepository.getInstance().getMethodSignature(method);
        if (methodSignature != null) {
            for (IJavaMethodParameter parameter : methodSignature.getMethodParameters()) {
                if (parameter.getAnnotations().isEmpty()) {
                    return false;
                }
                for (Map.Entry annotation : parameter.getAnnotations().entrySet()) {
                    if (((Annotation)annotation.getValue()).getFullyQualifiedName().equals("javax.ws.rs.core.Context") && (parameter.getType() == null || CONTEXT_TYPE_NAMES.contains(parameter.getType().getErasureName()))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void validateNoMissingProviderAnnotation(JaxrsParamConverterProvider provider) throws CoreException {
        Annotation annotation = provider.getAnnotation("javax.ws.rs.ext.Provider");
        if (annotation == null) {
            ISourceRange nameRange = ((IType)provider.getJavaElement()).getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)provider, nameRange, JaxrsValidationMessages.PROVIDER_MISSING_ANNOTATION, new String[0], JaxrsPreferences.PROVIDER_MISSING_ANNOTATION);
        }
    }
}

