/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.EditorValidationContext;
import org.jboss.tools.common.validation.IJavaElementValidator;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IStringValidator;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.TempMarkerManager;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.search.JavaElementsSearcher;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.EnumElementKind;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsApplication;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsElement;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsProvider;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsResource;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IJaxrsElementValidator;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsHttpMethodValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsJavaApplicationValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsMetamodelValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsNameBindingValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsParamConverterProviderValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsProviderValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourceFieldValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourceMethodValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourcePropertyValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsResourceValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsWebxmlApplicationValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.ValidatingProjectTreeLocator;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsMetamodelValidator
extends TempMarkerManager
implements org.jboss.tools.common.validation.IValidator,
IJavaElementValidator,
IStringValidator,
IMarkerManager {
    private static final String PREFERENCE_PAGE_ID = "org.jboss.tools.ws.jaxrs.ui.preferencePages.JaxrsValidatorPreferencePage";
    private static final String PROPERTY_PAGE_ID = "org.jboss.tools.ws.jaxrs.ui.propertyPages.JaxrsValidatorPreferencePage";
    public static final String ID = "org.jboss.tools.ws.jaxrs.JaxrsMetamodelValidator";
    private static final String BUNDLE_NAME = String.valueOf(JaxrsMetamodelValidator.class.getPackage().getName()) + ".messages";
    public static final String JAXRS_PROBLEM_MARKER_ID = "org.jboss.tools.ws.jaxrs.metamodelMarker";
    public static final String JAXRS_PROBLEM_TYPE = "problemType";

    public JaxrsMetamodelValidator() {
        super.setProblemType(JAXRS_PROBLEM_MARKER_ID);
    }

    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, context, manager, reporter);
        this.setAsYouTypeValidation(false);
    }

    public boolean isEnabled(IProject project) {
        return JaxrsPreferences.isValidationEnabled(project);
    }

    public boolean shouldValidate(IProject project) {
        try {
            return project.isAccessible() && project.hasNature("org.jboss.tools.ws.jaxrs.nature") && this.isEnabled(project);
        }
        catch (CoreException e) {
            Logger.error("Failed to check if JAX-RS validation is required for project '" + project.getName() + "'", e);
            Logger.debug("*** Skipping JAX-RS validation for project {}", project.getName());
            return false;
        }
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        block12: {
            long startTime = System.currentTimeMillis();
            this.init(project, validationHelper, context, (IValidator)manager, reporter);
            try {
                try {
                    if (changedFiles.size() == 1 && changedFiles.contains(project.findMember(".project"))) {
                        this.validateAll(project, validationHelper, context, manager, reporter);
                    } else if (!changedFiles.isEmpty()) {
                        Logger.debug("*** Validating project {} after files {} changed... ***", project.getName(), changedFiles.toString());
                        JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IProject)project);
                        if (metamodel != null) {
                            int previousProblemLevel = metamodel.getMarkerSeverity();
                            List<IResource> allResources = this.completeValidationSet(metamodel, changedFiles.toArray(new IFile[changedFiles.size()]));
                            for (IResource changedResource : allResources) {
                                this.validate(changedResource, metamodel, reporter);
                            }
                            int currentProblemLevel = metamodel.getMarkerSeverity();
                            if (currentProblemLevel != previousProblemLevel) {
                                Logger.debug("Informing metamodel that problem level changed from {} to {}", previousProblemLevel, currentProblemLevel);
                                metamodel.notifyMetamodelProblemLevelChanged();
                            }
                        }
                    } else {
                        Logger.debug("*** Validating full project {} because no file changed... ***", project.getName());
                        this.validateAll(project, validationHelper, context, manager, reporter);
                    }
                }
                catch (CoreException e) {
                    Logger.error("Failed to validate changed files " + changedFiles + " in project " + project, e);
                    long endTime = System.currentTimeMillis();
                    Logger.debug("Validation done in {} ms.", endTime - startTime);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                Logger.debug("Validation done in {} ms.", endTime - startTime);
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            Logger.debug("Validation done in {} ms.", endTime - startTime);
        }
        return Status.OK_STATUS;
    }

    private List<IResource> completeValidationSet(JaxrsMetamodel metamodel, IFile ... changedResources) throws CoreException {
        IProject project = metamodel.getProject();
        HashSet<Object> resources = new HashSet<Object>();
        resources.addAll(Arrays.asList(changedResources));
        Set<EnumElementKind> elementKindChanges = this.analyzeChangeResources(metamodel, changedResources);
        boolean applicationsChanged = elementKindChanges.contains(EnumElementKind.APPLICATION_JAVA) || elementKindChanges.contains(EnumElementKind.APPLICATION_WEBXML);
        boolean resourcesChanged = elementKindChanges.contains(EnumElementKind.ROOT_RESOURCE) || elementKindChanges.contains(EnumElementKind.SUBRESOURCE) || elementKindChanges.contains(EnumElementKind.SUBRESOURCE_LOCATOR) || elementKindChanges.contains(EnumElementKind.UNDEFINED_RESOURCE);
        boolean filtersChanged = elementKindChanges.contains(EnumElementKind.CONTAINER_FILTER) || elementKindChanges.contains(EnumElementKind.CONTAINER_REQUEST_FILTER) || elementKindChanges.contains(EnumElementKind.CONTAINER_RESPONSE_FILTER) || elementKindChanges.contains(EnumElementKind.UNDEFINED_PROVIDER);
        boolean interceptorsChanged = elementKindChanges.contains(EnumElementKind.ENTITY_INTERCEPTOR) || elementKindChanges.contains(EnumElementKind.ENTITY_READER_INTERCEPTOR) || elementKindChanges.contains(EnumElementKind.ENTITY_WRITER_INTERCEPTOR);
        boolean nameBindingChanged = elementKindChanges.contains(EnumElementKind.NAME_BINDING);
        if (applicationsChanged) {
            resources.addAll(this.getApplicationUnderlyingResources(metamodel));
            resources.add(project);
        }
        if (applicationsChanged || resourcesChanged) {
            resources.addAll(this.getFiltersAndInterceptorsUnderlyingResources(metamodel));
        }
        if (filtersChanged || interceptorsChanged) {
            resources.addAll(this.getApplicationUnderlyingResources(metamodel));
            resources.addAll(this.getResourceUnderlyingResources(metamodel));
        }
        if (nameBindingChanged) {
            resources.addAll(this.getApplicationUnderlyingResources(metamodel));
            resources.addAll(this.getFiltersAndInterceptorsUnderlyingResources(metamodel));
            resources.addAll(this.getResourceUnderlyingResources(metamodel));
        }
        List jaxrsRelatedTypes = metamodel.getAllJavaElements(7);
        IFile[] iFileArray = changedResources;
        int n = changedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile changedResource = iFileArray[n2];
            ICompilationUnit changedCompilationUnit = JdtUtils.getCompilationUnit((IResource)changedResource);
            if (changedCompilationUnit != null) {
                Set foundRelatedTypes = JavaElementsSearcher.findRelatedTypes((IType)changedCompilationUnit.findPrimaryType(), (List)jaxrsRelatedTypes, (IProgressMonitor)new NullProgressMonitor());
                for (IType relatedType : foundRelatedTypes) {
                    resources.add(relatedType.getResource());
                }
            }
            ++n2;
        }
        if (elementKindChanges.contains(EnumElementKind.PARAM_CONVERTER_PROVIDER)) {
            resources.addAll(this.getResourceUnderlyingResources(metamodel));
        }
        ArrayList<IResource> result = new ArrayList<IResource>(resources);
        Collections.sort(result, new Comparator<IResource>(){

            @Override
            public int compare(IResource a, IResource b) {
                return a.getType() - b.getType();
            }
        });
        return result;
    }

    private Set<EnumElementKind> analyzeChangeResources(JaxrsMetamodel metamodel, IFile[] changedResources) {
        HashSet<EnumElementKind> elementKindChanges = new HashSet<EnumElementKind>();
        IFile[] iFileArray = changedResources;
        int n = changedResources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile changedResource = iFileArray[n2];
            EnumElementKind previousElementKind = metamodel.getShadowElementKind(changedResource);
            IJaxrsElement currentElement = metamodel.findElement((IResource)changedResource);
            if (previousElementKind != null) {
                elementKindChanges.add(previousElementKind);
            }
            if (currentElement != null) {
                elementKindChanges.add(currentElement.getElementKind());
            }
            if (currentElement == null) {
                metamodel.removeShadowedElement(changedResource);
            } else {
                metamodel.addShadowedElement(currentElement);
            }
            ++n2;
        }
        return elementKindChanges;
    }

    private Set<IResource> getFiltersAndInterceptorsUnderlyingResources(JaxrsMetamodel metamodel) {
        HashSet<IResource> providerResources = new HashSet<IResource>();
        Set providers = metamodel.findAllProviders();
        for (IJaxrsProvider provider : providers) {
            switch (provider.getElementKind()) {
                case CONTAINER_REQUEST_FILTER: 
                case CONTAINER_RESPONSE_FILTER: 
                case CONTAINER_FILTER: 
                case ENTITY_READER_INTERCEPTOR: 
                case ENTITY_WRITER_INTERCEPTOR: 
                case ENTITY_INTERCEPTOR: {
                    providerResources.add(provider.getResource());
                    break;
                }
            }
        }
        return providerResources;
    }

    private Set<IResource> getApplicationUnderlyingResources(JaxrsMetamodel metamodel) {
        Logger.debug("Adding all JAX-RS Applications and project in the set of files to validate...");
        HashSet<IResource> applicationResources = new HashSet<IResource>();
        Set applications = metamodel.findAllApplications();
        for (IJaxrsApplication application : applications) {
            applicationResources.add(application.getResource());
        }
        return applicationResources;
    }

    private Set<IResource> getResourceUnderlyingResources(JaxrsMetamodel metamodel) {
        Logger.debug("Adding all JAX-RS Resources (and children) and project in the set of files to validate...");
        HashSet<IResource> resourceResources = new HashSet<IResource>();
        Set resources = metamodel.findAllResources();
        for (IJaxrsResource resource : resources) {
            resourceResources.add(resource.getResource());
        }
        return resourceResources;
    }

    private void validate(IResource changedResource, JaxrsMetamodel metamodel, IReporter reporter) {
        if (reporter.isCancelled() || !changedResource.isAccessible()) {
            return;
        }
        this.displaySubtask(JaxrsValidationMessages.VALIDATING_RESOURCE, new String[]{changedResource.getProject().getName(), changedResource.getName()});
        try {
            if (metamodel != null && changedResource != null && changedResource.exists()) {
                if (changedResource.getType() == 4) {
                    this.validate(metamodel);
                } else {
                    Set elements = metamodel.findElements(changedResource);
                    if (elements.isEmpty()) {
                        JaxrsMetamodelValidator.removeMarkers(metamodel, changedResource);
                    } else {
                        for (IJaxrsElement element : elements) {
                            this.validate(element);
                        }
                    }
                }
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to validate the resource change", e);
        }
    }

    public void validate(IValidator validatorManager, IProject rootProject, Collection<IRegion> dirtyRegions, IValidationContext helper, IReporter reporter, EditorValidationContext validationContext, IProjectValidationContext projectContext, IFile changedFile) {
        block8: {
            long startTime = System.currentTimeMillis();
            Logger.debug("*** Validating project {} after file {} changed... ***", changedFile.getProject().getName(), changedFile.getFullPath());
            try {
                try {
                    JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IProject)changedFile.getProject());
                    ICompilationUnit compilationUnit = JdtUtils.getCompilationUnit((IResource)changedFile);
                    if (metamodel != null && compilationUnit != null) {
                        CompilationUnit ast = JdtUtils.parse((ICompilationUnit)compilationUnit, (IProgressMonitor)new NullProgressMonitor());
                        HashSet<IJaxrsElement> changedJaxrsElements = new HashSet<IJaxrsElement>();
                        for (IRegion dirtyRegion : dirtyRegions) {
                            IJavaElement changedElement = compilationUnit.getElementAt(dirtyRegion.getOffset());
                            if (changedElement == null) continue;
                            IJaxrsElement changedJaxrsElement = metamodel.findElement(changedElement);
                            if (changedJaxrsElements == null || !(changedJaxrsElement instanceof JaxrsJavaElement)) continue;
                            ((JaxrsJavaElement)changedJaxrsElement).update(changedElement, ast);
                            changedJaxrsElements.add(changedJaxrsElement);
                        }
                        for (IJaxrsElement changedJaxrsElement : changedJaxrsElements) {
                            Logger.debug("Going to validate {}:\n{}", changedJaxrsElement.getName(), ((JaxrsJavaElement)changedJaxrsElement).getJavaElement().getSource());
                            this.validate(changedJaxrsElement);
                        }
                    }
                }
                catch (CoreException e) {
                    Logger.error("Failed to validate changed file " + changedFile.getName() + " in project " + changedFile.getProject(), e);
                    long endTime = System.currentTimeMillis();
                    Logger.debug("Validation done in {} ms.", endTime - startTime);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                Logger.debug("Validation done in {} ms.", endTime - startTime);
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            Logger.debug("Validation done in {} ms.", endTime - startTime);
        }
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext validationContext, ValidatorManager manager, IReporter reporter) throws ValidationException {
        block8: {
            long startTime = System.currentTimeMillis();
            Logger.debug("*** Validating all files in project {} ***", project.getName());
            this.init(project, validationHelper, validationContext, (IValidator)manager, reporter);
            this.displaySubtask(JaxrsValidationMessages.VALIDATING_PROJECT, new String[]{project.getName()});
            try {
                try {
                    JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IProject)project);
                    if (metamodel != null) {
                        int previousProblemLevel = metamodel.getMarkerSeverity();
                        List allElements = metamodel.getAllElements();
                        for (IJaxrsElement element : allElements) {
                            this.validate(element);
                        }
                        this.validate(metamodel);
                        int currentProblemLevel = metamodel.getMarkerSeverity();
                        if (currentProblemLevel != previousProblemLevel) {
                            Logger.debug("Informing metamodel that problem level changed from {} to {}", previousProblemLevel, currentProblemLevel);
                            metamodel.notifyMetamodelProblemLevelChanged();
                        }
                    }
                }
                catch (CoreException e) {
                    Logger.error("Failed to validate project '", e);
                    long endTime = System.currentTimeMillis();
                    Logger.debug("Validation done in {} ms.", endTime - startTime);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                long endTime = System.currentTimeMillis();
                Logger.debug("Validation done in {} ms.", endTime - startTime);
                throw throwable;
            }
            long endTime = System.currentTimeMillis();
            Logger.debug("Validation done in {} ms.", endTime - startTime);
        }
        return Status.OK_STATUS;
    }

    private void validate(IJaxrsElement element) throws CoreException {
        IJaxrsElementValidator<? extends IJaxrsElement> validator;
        if (!element.isBinary() && (validator = this.getValidator(element)) != null) {
            validator.validate((IJaxrsElement)element);
        }
    }

    private IJaxrsElementValidator<? extends IJaxrsElement> getValidator(IJaxrsElement element) {
        switch (element.getElementKind().getCategory()) {
            case APPLICATION: {
                IJaxrsApplication application = (IJaxrsApplication)element;
                if (application.isJavaApplication()) {
                    return new JaxrsJavaApplicationValidatorDelegate(this);
                }
                return new JaxrsWebxmlApplicationValidatorDelegate(this);
            }
            case HTTP_METHOD: {
                return new JaxrsHttpMethodValidatorDelegate(this);
            }
            case NAME_BINDING: {
                return new JaxrsNameBindingValidatorDelegate(this);
            }
            case PARAM_CONVERTER_PROVIDER: {
                return new JaxrsParamConverterProviderValidatorDelegate(this);
            }
            case PROVIDER: {
                return new JaxrsProviderValidatorDelegate(this);
            }
            case RESOURCE: {
                return new JaxrsResourceValidatorDelegate(this);
            }
            case RESOURCE_FIELD: {
                return new JaxrsResourceFieldValidatorDelegate(this);
            }
            case RESOURCE_PROPERTY: {
                return new JaxrsResourcePropertyValidatorDelegate(this);
            }
            case RESOURCE_METHOD: {
                return new JaxrsResourceMethodValidatorDelegate(this);
            }
        }
        return null;
    }

    private void validate(JaxrsMetamodel metamodel) throws CoreException {
        new JaxrsMetamodelValidatorDelegate(this).validate(metamodel);
    }

    protected String getMessageBundleName() {
        return BUNDLE_NAME;
    }

    protected String getPreference(IProject project, String preferenceKey) {
        return JaxrsPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }

    public int getMaxNumberOfMarkersPerFile(IProject project) {
        return JaxrsPreferences.getMaxNumberOfProblemMarkersPerFile(project);
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return "org.jboss.tools.ws.jaxrs.metamodelBuilder";
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        return ValidatingProjectTreeLocator.getInstance().getValidatingProjects(project);
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new JaxrsPreferenceInfo());
    }

    public static void removeMarkers(JaxrsMetamodel metamodel, IResource resource) throws CoreException {
        if (resource == null) {
            return;
        }
        resource.deleteMarkers(JAXRS_PROBLEM_MARKER_ID, true, 1);
    }

    @Override
    public IMarker addMarker(JaxrsMetamodel metamodel, String message, String[] messageArguments, String preferenceKey) throws CoreException {
        IProject project = metamodel.getProject();
        Logger.debug("Reporting problem '{}' on project '{}'", message, project.getName());
        IMarker marker = this.addProblem(message, preferenceKey, messageArguments, 0, 0, (IResource)project);
        if (marker != null) {
            marker.setAttribute(JAXRS_PROBLEM_TYPE, (Object)preferenceKey);
            metamodel.registerMarker(marker);
        }
        return marker;
    }

    @Override
    public IMarker addMarker(JaxrsBaseElement element, ISourceRange range, String message, String[] messageArguments, String preferenceKey) throws CoreException {
        if (element == null || range == null) {
            return null;
        }
        IResource resource = element.getResource();
        Logger.debug("Reporting problem '{}' on resource '{}'", message, resource.getFullPath().toString());
        IMarker marker = this.addProblem(message, preferenceKey, messageArguments, range.getLength(), range.getOffset(), resource);
        if (marker != null) {
            marker.setAttribute(JAXRS_PROBLEM_TYPE, (Object)preferenceKey);
            element.registerMarker(marker);
        }
        return marker;
    }

    @Override
    public IMarker addMarker(JaxrsBaseElement element, ISourceRange range, String message, String[] messageArguments, String preferenceKey, int quickFixId) throws CoreException {
        if (element == null || range == null) {
            return null;
        }
        IResource resource = element.getResource();
        Logger.debug("Reporting problem '{}' on resource '{}'", message, resource.getFullPath().toString());
        IMarker marker = this.addProblem(message, preferenceKey, messageArguments, range.getLength(), range.getOffset(), resource, quickFixId);
        if (marker != null) {
            marker.setAttribute(JAXRS_PROBLEM_TYPE, (Object)preferenceKey);
            element.registerMarker(marker);
        }
        return marker;
    }

    public boolean shouldValidateAsYouType(IProject project) {
        return this.shouldValidate(project);
    }

    class JaxrsPreferenceInfo
    implements IPreferenceInfo {
        JaxrsPreferenceInfo() {
        }

        public String getPreferencePageId() {
            return JaxrsMetamodelValidator.PREFERENCE_PAGE_ID;
        }

        public String getPropertyPageId() {
            return JaxrsMetamodelValidator.PROPERTY_PAGE_ID;
        }

        public String getPluginId() {
            return "org.jboss.tools.ws.jaxrs.ui";
        }
    }
}

