/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsJavaApplication;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsProvider;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsJavaApplicationValidatorDelegate
extends AbstractJaxrsElementValidatorDelegate<JaxrsJavaApplication> {
    private final IMarkerManager markerManager;

    public JaxrsJavaApplicationValidatorDelegate(IMarkerManager markerManager) {
        this.markerManager = markerManager;
    }

    @Override
    void internalValidate(JaxrsJavaApplication application) throws CoreException {
        Logger.debug("Validating element {}", application);
        this.validateApplicationOverride(application);
        this.validateApplicationSubclass(application);
        this.validateAtLeastOneProviderWithBinding(application);
    }

    private void validateApplicationSubclass(JaxrsJavaApplication application) throws CoreException, JavaModelException {
        IType appJavaElement = (IType)application.getJavaElement();
        if (!application.isJaxrsCoreApplicationSubclass()) {
            this.markerManager.addMarker((JaxrsBaseElement)application, ((IType)application.getJavaElement()).getSourceRange(), JaxrsValidationMessages.JAVA_APPLICATION_INVALID_TYPE_HIERARCHY, new String[]{appJavaElement.getFullyQualifiedName()}, JaxrsPreferences.JAVA_APPLICATION_INVALID_TYPE_HIERARCHY, 10);
        }
    }

    private void validateApplicationOverride(JaxrsJavaApplication application) throws CoreException, JavaModelException {
        Annotation applicationPathAnnotation = application.getAnnotation("javax.ws.rs.ApplicationPath");
        IType appJavaElement = (IType)application.getJavaElement();
        if (!application.isOverriden() && applicationPathAnnotation == null) {
            this.markerManager.addMarker((JaxrsBaseElement)application, appJavaElement.getNameRange(), JaxrsValidationMessages.JAVA_APPLICATION_MISSING_APPLICATION_PATH_ANNOTATION, new String[0], JaxrsPreferences.JAVA_APPLICATION_MISSING_APPLICATION_PATH_ANNOTATION, 9);
        }
    }

    private void validateAtLeastOneProviderWithBinding(JaxrsJavaApplication javaApplication) throws CoreException {
        if (javaApplication == null) {
            return;
        }
        Map nameBindingAnnotations = javaApplication.getNameBindingAnnotations();
        if (nameBindingAnnotations.isEmpty()) {
            return;
        }
        JaxrsMetamodel metamodel = javaApplication.getMetamodel();
        String firstNameBindingAnnotationClassName = (String)nameBindingAnnotations.keySet().iterator().next();
        Set allBindingAnnotationNames = nameBindingAnnotations.keySet();
        Set annotatedProviders = metamodel.findProvidersByAnnotation(firstNameBindingAnnotationClassName);
        for (IJaxrsProvider provider : annotatedProviders) {
            if (!provider.getNameBindingAnnotations().keySet().equals(allBindingAnnotationNames)) continue;
            return;
        }
        ISourceRange nameRange = ((Annotation)nameBindingAnnotations.get(firstNameBindingAnnotationClassName)).getJavaAnnotation().getNameRange();
        this.markerManager.addMarker((JaxrsBaseElement)javaApplication, nameRange, JaxrsValidationMessages.PROVIDER_MISSING_BINDING, new String[]{firstNameBindingAnnotationClassName}, JaxrsPreferences.PROVIDER_MISSING_BINDING);
    }
}

