/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.validation;

import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsBaseElement;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsHttpMethod;
import org.jboss.tools.ws.jaxrs.core.jdt.Annotation;
import org.jboss.tools.ws.jaxrs.core.jdt.JdtUtils;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.CollectionUtils;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.AbstractJaxrsElementValidatorDelegate;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.IMarkerManager;
import org.jboss.tools.ws.jaxrs.ui.internal.validation.JaxrsValidationMessages;
import org.jboss.tools.ws.jaxrs.ui.preferences.JaxrsPreferences;

public class JaxrsHttpMethodValidatorDelegate
extends AbstractJaxrsElementValidatorDelegate<JaxrsHttpMethod> {
    private final IMarkerManager markerManager;

    public JaxrsHttpMethodValidatorDelegate(IMarkerManager markerManager) {
        this.markerManager = markerManager;
    }

    @Override
    void internalValidate(JaxrsHttpMethod httpMethod) throws CoreException {
        Logger.debug("Validating element {}", httpMethod);
        if (!httpMethod.isBuiltIn()) {
            this.validateHttpMethodAnnotation(httpMethod);
            this.validateRetentionAnnotation(httpMethod);
            this.validateTargetAnnotation(httpMethod);
        }
    }

    private void validateHttpMethodAnnotation(JaxrsHttpMethod httpMethod) throws CoreException {
        String httpValue;
        Annotation httpMethodAnnotation = httpMethod.getHttpMethodAnnotation();
        if (httpMethodAnnotation != null && (httpValue = httpMethodAnnotation.getValue()) != null && httpValue.isEmpty()) {
            ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)httpMethodAnnotation.getJavaAnnotation(), (String)"value");
            this.markerManager.addMarker((JaxrsBaseElement)httpMethod, range, JaxrsValidationMessages.HTTP_METHOD_INVALID_HTTP_METHOD_ANNOTATION_VALUE, new String[0], JaxrsPreferences.HTTP_METHOD_INVALID_HTTP_METHOD_ANNOTATION_VALUE);
        }
    }

    private void validateTargetAnnotation(JaxrsHttpMethod httpMethod) throws CoreException {
        Annotation targetAnnotation = httpMethod.getTargetAnnotation();
        if (targetAnnotation == null) {
            ISourceRange range = ((IType)httpMethod.getJavaElement()).getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)httpMethod, range, JaxrsValidationMessages.HTTP_METHOD_MISSING_TARGET_ANNOTATION, new String[0], JaxrsPreferences.HTTP_METHOD_MISSING_TARGET_ANNOTATION, 3);
        } else {
            List annotationValues = targetAnnotation.getValues();
            List<String> expectedValue = Arrays.asList(ElementType.METHOD.name());
            if (!CollectionUtils.containsInAnyOrder(annotationValues, expectedValue)) {
                ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)targetAnnotation.getJavaAnnotation(), (String)"value");
                this.markerManager.addMarker((JaxrsBaseElement)httpMethod, range, JaxrsValidationMessages.HTTP_METHOD_INVALID_TARGET_ANNOTATION_VALUE, new String[0], JaxrsPreferences.HTTP_METHOD_INVALID_TARGET_ANNOTATION_VALUE, 4);
            }
        }
    }

    private void validateRetentionAnnotation(JaxrsHttpMethod httpMethod) throws CoreException {
        Annotation retentionAnnotation = httpMethod.getRetentionAnnotation();
        if (retentionAnnotation == null) {
            ISourceRange range = ((IType)httpMethod.getJavaElement()).getNameRange();
            this.markerManager.addMarker((JaxrsBaseElement)httpMethod, range, JaxrsValidationMessages.HTTP_METHOD_MISSING_RETENTION_ANNOTATION, new String[0], JaxrsPreferences.HTTP_METHOD_MISSING_RETENTION_ANNOTATION, 1);
        } else {
            String annotationValue = retentionAnnotation.getValue();
            if (annotationValue != null && !annotationValue.equals(RetentionPolicy.RUNTIME.name())) {
                ISourceRange range = JdtUtils.resolveMemberPairValueRange((IAnnotation)retentionAnnotation.getJavaAnnotation(), (String)"value");
                this.markerManager.addMarker((JaxrsBaseElement)httpMethod, range, JaxrsValidationMessages.HTTP_METHOD_INVALID_RETENTION_ANNOTATION_VALUE, new String[0], JaxrsPreferences.HTTP_METHOD_INVALID_RETENTION_ANNOTATION_VALUE, 2);
            }
        }
    }
}

