/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.internal.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.ws.jaxrs.ui.JBossJaxrsUIPlugin;

public final class Logger {
    private static final String DEBUG = "org.jboss.tools.ws.jaxrs.ui/debug";
    private static final String TRACE = "org.jboss.tools.ws.jaxrs.ui/trace";
    private static final ThreadLocal<DateFormat> dateFormatter = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss.SSS");
        }
    };

    private Logger() {
    }

    public static void error(String message) {
        JBossJaxrsUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.ws.jaxrs.ui", message));
    }

    public static void error(String message, Throwable t) {
        JBossJaxrsUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.ws.jaxrs.ui", message, t));
    }

    public static void error(String message, Throwable t, Object ... items) {
        JBossJaxrsUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.ws.jaxrs.ui", Logger.getMessage(message, items), t));
    }

    public static void warn(String message) {
        JBossJaxrsUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.ws.jaxrs.ui", message));
    }

    public static void warn(String message, Throwable cause) {
        JBossJaxrsUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.jboss.tools.ws.jaxrs.ui", message, cause));
    }

    public static void info(String message) {
        JBossJaxrsUIPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.jboss.tools.ws.jaxrs.ui", message));
    }

    public static void debug(String message) {
        Logger.debug(message, null);
    }

    public static void debug(String message, Object ... items) {
        Logger.log(DEBUG, message, items);
    }

    public static void trace(String message, Object ... items) {
        Logger.log(TRACE, message, items);
    }

    /*
     * Unable to fully structure code
     */
    private static void log(String level, String message, Object ... items) {
        block3: {
            try {
                debugOption = Platform.getDebugOption((String)level);
                if (JBossJaxrsUIPlugin.getDefault() == null || !JBossJaxrsUIPlugin.getDefault().isDebugging() || !"true".equalsIgnoreCase(debugOption)) break block3;
                valuedMessage = Logger.getMessage(message, items);
                System.out.println(String.valueOf(Logger.dateFormatter.get().format(new Date())) + " [" + Thread.currentThread().getName() + "] " + valuedMessage);
                break block3;
            }
            catch (RuntimeException v0) {
                System.err.println("Failed to write proper debug message with template:\n " + message + "\n and items:");
                var6_7 = items;
                var5_8 = items.length;
                var4_6 = 0;
                ** while (var4_6 < var5_8)
            }
lbl-1000:
            // 1 sources

            {
                item = var6_7[var4_6];
                System.err.println(" " + item);
                ++var4_6;
                continue;
            }
        }
    }

    public static String getMessage(String valuedMessage, Object ... items) {
        if (items != null) {
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                valuedMessage = valuedMessage.replaceFirst("\\{\\}", item != null ? item.toString().replaceAll("\\$", ".") : "null");
                ++n2;
            }
        }
        return valuedMessage;
    }
}

