/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.jaxrs.ui.cnf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.ws.jaxrs.core.internal.metamodel.domain.JaxrsMetamodel;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpoint;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.IJaxrsEndpointChangedListener;
import org.jboss.tools.ws.jaxrs.core.metamodel.domain.JaxrsMetamodelLocator;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriMappingsContentProvider;
import org.jboss.tools.ws.jaxrs.ui.cnf.UriPathTemplateElement;
import org.jboss.tools.ws.jaxrs.ui.internal.utils.Logger;

public class UriPathTemplateCategory
implements ITreeContentProvider {
    private final IJavaProject javaProject;
    private final UriMappingsContentProvider parent;
    private final Map<IJaxrsEndpoint, UriPathTemplateElement> wrapperCache = new HashMap<IJaxrsEndpoint, UriPathTemplateElement>();

    public UriPathTemplateCategory(UriMappingsContentProvider parent, IProject project) {
        this(parent, JavaCore.create((IProject)project));
    }

    public UriPathTemplateCategory(UriMappingsContentProvider parent, IJavaProject javaProject) {
        this.parent = parent;
        this.javaProject = javaProject;
    }

    public Object[] getChildren(Object parentElement) {
        try {
            JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IJavaProject)this.javaProject);
            if (metamodel != null && !metamodel.isInitializing()) {
                metamodel.addJaxrsEndpointChangedListener((IJaxrsEndpointChangedListener)this.parent);
                Collection endpoints = metamodel.getAllEndpoints();
                Logger.debug("UriPathTemplateCategory contains {} endpoints", endpoints.size());
                ArrayList<UriPathTemplateElement> uriPathTemplateElements = new ArrayList<UriPathTemplateElement>();
                for (IJaxrsEndpoint endpoint : endpoints) {
                    UriPathTemplateElement element = this.wrapperCache.get(endpoint);
                    if (element == null) {
                        Logger.trace("Creating element for endpoint '{}' (was not found in wrapperCache)", endpoint);
                        element = new UriPathTemplateElement(endpoint, this);
                        this.wrapperCache.put(endpoint, element);
                    } else if (element.getEndpoint().equals(endpoint)) {
                        element.setEndpoint(endpoint);
                    }
                    uriPathTemplateElements.add(element);
                }
                return uriPathTemplateElements.toArray();
            }
            if (metamodel == null || !metamodel.isInitializing()) {
                JaxrsMetamodelLocator.get((IJavaProject)this.javaProject, (boolean)true);
                this.launchLoadingMetamodelJob(this);
                Logger.debug("Displaying the 'Loading...' stub for project '{}' and launching a build", this.javaProject.getElementName());
                return new Object[]{new UriMappingsContentProvider.LoadingStub(this.javaProject)};
            }
            Logger.debug("Just displaying the 'Loading...' stub for project '{}'", this.javaProject.getElementName());
            return new Object[]{new UriMappingsContentProvider.LoadingStub(this.javaProject)};
        }
        catch (CoreException e) {
            Logger.error("Failed to retrieve JAX-RS Metamodel in project '" + this.javaProject.getElementName() + "'", e);
            Logger.debug("*** There's no JAX-RS Metamodel for project '{}' -> no element to display ***", this.javaProject.getElementName());
            return new Object[0];
        }
    }

    private void launchLoadingMetamodelJob(UriPathTemplateCategory uriPathTemplateCategory) {
        final IProject project = uriPathTemplateCategory.getProject();
        Job job = new Job("Loading JAX-RS metamodel for project '" + this.javaProject.getElementName() + "'..."){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Loading JAX-RS metamodel for project '" + UriPathTemplateCategory.this.javaProject.getElementName() + "'...", 3);
                try {
                    project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    project.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
                }
                catch (Exception e) {
                    Logger.error("Failed to build project '" + UriPathTemplateCategory.this.javaProject.getElementName() + "'", e);
                }
                monitor.worked(1);
                UriPathTemplateCategory.this.refreshContent();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }

    public Object getParent(Object element) {
        return this.javaProject.getProject();
    }

    public final IProject getProject() {
        return this.javaProject.getProject();
    }

    public final IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public boolean hasChildren(Object element) {
        try {
            JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IJavaProject)this.javaProject);
            if (metamodel != null && !metamodel.isInitializing()) {
                Collection endpoints = metamodel.getAllEndpoints();
                Logger.debug("UriPathTemplateCategory contains {} endpoints", endpoints.size());
                return endpoints.size() > 0;
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to retrieve JAX-RS Metamodel in project '" + this.javaProject.getElementName() + "'", e);
        }
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public UriPathTemplateElement getUriPathTemplateElement(IJaxrsEndpoint endpoint) {
        return this.wrapperCache.get(endpoint);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Logger.debug("Input changed in UriPathTemplateCategory");
    }

    public int getProblemLevel() {
        int level = 0;
        try {
            JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IJavaProject)this.javaProject);
            if (metamodel != null) {
                level = metamodel.getMarkerSeverity();
                for (IJaxrsEndpoint endpoint : metamodel.getAllEndpoints()) {
                    level = Math.max(level, endpoint.getProblemLevel());
                }
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to determine the problem severity for the JAX-RS Web Services", e);
        }
        return level;
    }

    public void dispose() {
    }

    public void refreshContent() {
        try {
            JaxrsMetamodel metamodel = JaxrsMetamodelLocator.get((IJavaProject)this.javaProject);
            if (metamodel != null) {
                metamodel.addJaxrsEndpointChangedListener((IJaxrsEndpointChangedListener)this.parent);
            }
        }
        catch (CoreException e) {
            Logger.error("Failed to retrieve the JAX-RS Metamodel for project '" + this.javaProject.getElementName() + "'", e);
        }
        this.parent.refreshContent(this.javaProject.getProject());
    }

    public Object[] getChildren() {
        return this.getChildren(this);
    }

    public String toString() {
        return "UriPathTemplateCategory on project '" + this.javaProject.getElementName() + "'";
    }
}

