/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.behavior;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.wtp.core.ASWTPToolsPlugin;
import org.jboss.ide.eclipse.as.wtp.core.Trace;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;

public class SubsystemModel {
    public static final String REQUIRED_PROPERTIES_ENV_KEY = ".RESERVED_requiredProperties";
    private static SubsystemModel instance;
    private Map<String, Map<String, SubsystemMapping>> mappedModel;
    private Map<String, SubsystemType> subsystemModel;

    public static SubsystemModel getInstance() {
        if (instance == null) {
            instance = new SubsystemModel();
        }
        return instance;
    }

    protected SubsystemMapping[] getAllMappings(String serverType) {
        this.checkLoaded();
        Map<String, SubsystemMapping> map = this.mappedModel.get(serverType);
        if (map != null) {
            Collection<SubsystemMapping> vals = map.values();
            return vals.toArray(new SubsystemMapping[vals.size()]);
        }
        return new SubsystemMapping[0];
    }

    protected String[] getAllSystemsForServertype(String serverType) {
        ArrayList<String> ret = new ArrayList<String>();
        SubsystemMapping[] all = this.getAllMappings(serverType);
        String sys = null;
        int i = 0;
        while (i < all.length) {
            sys = all[i].getSubsystem().getSystem();
            if (!ret.contains(sys)) {
                ret.add(sys);
            }
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }

    protected SubsystemMapping[] getSubsystemMappings(String serverType, String system) {
        this.checkLoaded();
        Map<String, SubsystemMapping> serverSubsystems = this.mappedModel.get(serverType);
        if (serverSubsystems != null) {
            Collection<SubsystemMapping> mappings = serverSubsystems.values();
            if (system == null) {
                return mappings.toArray(new SubsystemMapping[mappings.size()]);
            }
            ArrayList<SubsystemMapping> clone = new ArrayList<SubsystemMapping>(mappings);
            Iterator<SubsystemMapping> i = clone.iterator();
            SubsystemMapping tmp = null;
            while (i.hasNext()) {
                tmp = i.next();
                if (tmp.getSubsystem().getSystem().equals(system)) continue;
                i.remove();
            }
            return clone.toArray(new SubsystemMapping[clone.size()]);
        }
        return new SubsystemMapping[0];
    }

    public ISubsystemController createControllerForSubsystem(IServer server, String system, String subsystemId) throws CoreException {
        return this.createControllerForSubsystem(server, server.getServerType().getId(), system, subsystemId, null);
    }

    public ISubsystemController createControllerForSubsystem(IServer server, String serverType, String system, String subsystemId, Map<String, Object> env) throws CoreException {
        ISubsystemController c = this.createSubsystemController((IServerAttributes)server, serverType, system, null, subsystemId, env);
        if (c.getSubsystemMappedId().equals(subsystemId)) {
            return c;
        }
        return null;
    }

    public ISubsystemController createSubsystemController(IServer server, String system) throws CoreException {
        return this.createSubsystemController((IServerAttributes)server, system, null, null, null);
    }

    public ISubsystemController createSubsystemController(IServerAttributes server, String system, Map<String, Object> env) throws CoreException {
        return this.createSubsystemController(server, system, null, null, env);
    }

    public ISubsystemController createSubsystemController(IServerAttributes server, String system, Map<String, String> requiredProperties, String defaultSubsystem, Map<String, Object> environment) throws CoreException {
        return this.createSubsystemController(server, server.getServerType().getId(), system, requiredProperties, defaultSubsystem, environment);
    }

    public SubsystemMapping getSubsystemMappingForCreation(String serverType, String system, Map<String, String> requiredProperties, String defaultSubsystem, Map<String, Object> environment) throws CoreException {
        this.checkLoaded();
        SubsystemMapping[] types = this.getSubsystemMappings(serverType, system);
        if (types == null) {
            types = new SubsystemMapping[]{};
        }
        types = this.removeInvalidTypes(types);
        if (requiredProperties != null) {
            types = this.findTypesWithProperties(types, requiredProperties);
        } else if (environment != null) {
            Map<String, String> requiredProps = this.getRequiredPropsFromEnv(system, environment);
            types = this.findTypesWithProperties(types, requiredProps);
        }
        SubsystemMapping selectedMapping = null;
        if (defaultSubsystem != null && types.length > 0) {
            SubsystemMapping tmp = this.findSubsystemWithMappedId(types, defaultSubsystem);
            SubsystemMapping subsystemMapping = selectedMapping = tmp == null ? types[0] : tmp;
        }
        if (types.length == 1) {
            selectedMapping = types[0];
        }
        if (selectedMapping == null) {
            SubsystemMapping[] defaultsSet = this.findMappingsWithProperty(types, "default", "true");
            if (defaultsSet.length > 0) {
                selectedMapping = defaultsSet[0];
            } else if (types.length > 1) {
                String msg = "Unable to choose a subsystem. Multiple subsystems found for servertype " + serverType + " and system type " + system;
                throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", msg));
            }
        }
        if (selectedMapping == null) {
            String msg = "No subsystem found for servertype " + serverType + " and system type " + system;
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", msg));
        }
        return selectedMapping;
    }

    public ISubsystemController createSubsystemController(IServerAttributes server, String serverType, String system, Map<String, String> requiredProperties, String defaultSubsystem, Map<String, Object> environment) throws CoreException {
        Trace.trace("/finer", "Creating subsystem controller for server type " + serverType + ", system " + system + " and default subsystem id " + defaultSubsystem);
        SubsystemMapping selectedMapping = this.getSubsystemMappingForCreation(serverType, system, requiredProperties, defaultSubsystem, environment);
        try {
            Trace.trace("/finest", "Found subsystem id " + selectedMapping.getSubsystemId() + " while searching server type " + serverType + ", system " + system + " and default subsystem id " + defaultSubsystem);
            ISubsystemController c = selectedMapping.getSubsystem().createController();
            Trace.trace("/finest", "Subsystem created with class " + c.getClass().getCanonicalName());
            c.initialize(server, new Subsystem(selectedMapping), environment);
            return c;
        }
        catch (CoreException ce) {
            String msg = "Error creating subsystem " + selectedMapping.mappedId + " for server type " + serverType;
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", msg, (Throwable)ce));
        }
    }

    private Map<String, String> getRequiredPropsFromEnv(String system, Map<String, Object> environment) {
        String key = String.valueOf(system) + REQUIRED_PROPERTIES_ENV_KEY;
        HashMap<String, String> requiredProps = null;
        if (environment == null) {
            return new HashMap<String, String>();
        }
        Object val1 = environment.get(key);
        if (val1 instanceof String) {
            String val = (String)val1;
            requiredProps = new HashMap<String, String>();
            String[] perReq = val.split(";");
            int i = 0;
            while (i < perReq.length) {
                String[] tmp = perReq[i].split("=");
                requiredProps.put(tmp[0], tmp[1]);
                ++i;
            }
        }
        return requiredProps;
    }

    private SubsystemMapping findSubsystemWithMappedId(SubsystemMapping[] types, String id) {
        int i = 0;
        while (i < types.length) {
            if (types[i].mappedId.equals(id)) {
                return types[i];
            }
            ++i;
        }
        return null;
    }

    private SubsystemMapping[] findMappingsWithProperty(SubsystemMapping[] types, String key, String val) {
        if (key == null || val == null) {
            return types;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(key, val);
        return this.findTypesWithProperties(types, m);
    }

    private SubsystemMapping[] removeInvalidTypes(SubsystemMapping[] types) {
        ArrayList<SubsystemMapping> matching = new ArrayList<SubsystemMapping>();
        int i = 0;
        while (i < types.length) {
            if (types[i].isValid) {
                matching.add(types[i]);
            }
            ++i;
        }
        return matching.toArray(new SubsystemMapping[matching.size()]);
    }

    private SubsystemMapping[] findTypesWithProperties(SubsystemMapping[] types, Map<String, String> requiredProps) {
        if (requiredProps == null || requiredProps.size() == 0) {
            return types;
        }
        ArrayList<SubsystemMapping> matching = new ArrayList<SubsystemMapping>();
        int i = 0;
        while (i < types.length) {
            boolean matchesAll = true;
            Iterator<String> j = requiredProps.keySet().iterator();
            while (j.hasNext() && matchesAll) {
                String typeVal;
                String k = j.next();
                String v = requiredProps.get(k);
                if (v.equals(typeVal = (String)types[i].getSubsystem().props.get(k))) continue;
                matchesAll = false;
            }
            if (matchesAll) {
                matching.add(types[i]);
            }
            ++i;
        }
        return matching.toArray(new SubsystemMapping[matching.size()]);
    }

    private void checkLoaded() {
        if (this.subsystemModel == null) {
            this.loadModel();
        }
    }

    private synchronized void loadModel() {
        ArrayList<Object> warningsErrors = new ArrayList<Object>();
        this.subsystemModel = new HashMap<String, SubsystemType>();
        this.mappedModel = new HashMap<String, Map<String, SubsystemMapping>>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.wtp.core", "serverSubsystem");
        int i = 0;
        while (i < cf.length) {
            String name = cf[i].getName();
            if ("subsystem".equals(name)) {
                SubsystemType type = new SubsystemType(cf[i]);
                SubsystemType existing = this.subsystemModel.get(type.id);
                if (existing != null) {
                    warningsErrors.add(new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Invalid - 2 subsystems have been declared with the same unique id: " + type.id));
                } else if (this.hasRequiredSubsystemAttributes(type)) {
                    this.subsystemModel.put(type.id, type);
                } else {
                    warningsErrors.add(new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Invalid - Subsystem missing required attributes: " + type.id));
                }
            } else if ("subsystemMapping".equals(name)) {
                String subsystemId = cf[i].getAttribute("id");
                String mappedId = cf[i].getAttribute("mappedId");
                String serverTypes = cf[i].getAttribute("serverTypes");
                if (subsystemId != null && mappedId != null && serverTypes != null) {
                    String[] split = serverTypes.split(",");
                    int j = 0;
                    while (j < split.length) {
                        Map<String, SubsystemMapping> m = this.mappedModel.get(split[j]);
                        if (m == null) {
                            m = new HashMap<String, SubsystemMapping>();
                            this.mappedModel.put(split[j], m);
                        }
                        this.mappedModel.get(split[j]).put(mappedId, new SubsystemMapping(split[j], mappedId, subsystemId));
                        ++j;
                    }
                } else {
                    warningsErrors.add(new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Invalid - Subsystem Mapping missing required attributes: " + subsystemId + ", " + mappedId + ", " + serverTypes));
                }
            }
            ++i;
        }
        IStatus[] extra = this.validateModel();
        warningsErrors.addAll(Arrays.asList(extra));
        MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.as.wtp.core", 0, warningsErrors.toArray(new IStatus[warningsErrors.size()]), "Errors validating Server Subsystem Model", null);
        if (!ms.isOK()) {
            ASWTPToolsPlugin.log((IStatus)ms);
        }
    }

    private IStatus[] validateModel() {
        ArrayList<Object> warningsErrors = new ArrayList<Object>();
        for (Map.Entry<String, Map<String, SubsystemMapping>> entry : this.mappedModel.entrySet()) {
            String serverType = entry.getKey();
            Map<String, SubsystemMapping> val = entry.getValue();
            Collection<SubsystemMapping> types = val.values();
            for (SubsystemMapping mapping : types) {
                SubsystemType type = mapping.getSubsystem();
                if (type != null) {
                    IStatus s = this.validateSubsystemMapping(mapping);
                    if (s.isOK()) continue;
                    mapping.isValid = false;
                    mapping.validationError = s;
                    warningsErrors.add(s);
                    continue;
                }
                warningsErrors.add(new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Invalid - Mapped Subsystem does not exist: " + serverType + ", " + type.id));
            }
        }
        return warningsErrors.toArray(new IStatus[warningsErrors.size()]);
    }

    private IStatus validateSubsystemMapping(SubsystemMapping mapping) {
        ArrayList<Status> warningsErrors = new ArrayList<Status>();
        String serverType = mapping.getServerType();
        String[] requiredSystem = mapping.getSubsystem().getRequiredSystems();
        int i = 0;
        while (i < requiredSystem.length) {
            SubsystemMapping[] mappingsForSystem = this.getSubsystemMappings(serverType, requiredSystem[i]);
            int k = 0;
            while (k < mappingsForSystem.length) {
                this.validateSubsystemMapping(mappingsForSystem[k]);
                ++k;
            }
            if (mappingsForSystem.length == 0 || this.allInvalid(mappingsForSystem)) {
                warningsErrors.add(new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Invalid controller: - missing required dependent system " + requiredSystem[i]));
            }
            ++i;
        }
        Map<String, String> m = mapping.getSubsystem().getRequiredSubsystems();
        for (Map.Entry<String, String> entry : m.entrySet()) {
            String system2 = entry.getKey();
            String subsys2 = entry.getValue();
            SubsystemMapping[] matched = this.getSubsystemMappings(serverType, system2);
            boolean found = false;
            SubsystemMapping found2 = null;
            int k = 0;
            while (k < matched.length && !found) {
                if (matched[k].mappedId.equals(subsys2)) {
                    found = true;
                    found2 = matched[k];
                }
                ++k;
            }
            if (!found) {
                warningsErrors.add(new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Invalid controller: - missing required dependent subsystem "));
                continue;
            }
            this.validateSubsystemMapping(found2);
            if (found2.isValid) continue;
            warningsErrors.add(new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Invalid controller: - required subsystem has errors: " + found2.validationError));
        }
        IStatus[] allErrors = warningsErrors.toArray(new IStatus[warningsErrors.size()]);
        return new MultiStatus("org.jboss.ide.eclipse.as.wtp.core", 0, allErrors, "Errors validating subsystem mapping=" + serverType + " and subsystem id " + mapping.getSubsystem().getId(), null);
    }

    private boolean allInvalid(SubsystemMapping[] matched) {
        int i = 0;
        while (i < matched.length) {
            if (matched[i].isValid) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasRequiredSubsystemAttributes(SubsystemType type) {
        return type.element != null && type.id != null && type.system != null;
    }

    public static class Subsystem {
        private SubsystemMapping mapping;

        public Subsystem(SubsystemMapping mapping) {
            this.mapping = mapping;
        }

        public String getSubsystemName() {
            return this.mapping.getSubsystem().getName();
        }

        public String getSubsystemId() {
            return this.mapping.getSubsystem().getId();
        }

        public String getSystemId() {
            return this.mapping.getSubsystem().getSystem();
        }

        public String getMappedId() {
            return this.mapping.getMappedId();
        }

        public Map<String, String> getRequiredSubsystems() {
            return this.mapping.getSubsystem().getRequiredSubsystems();
        }

        public boolean isValid() {
            return this.mapping.isValid();
        }

        public IStatus getValidationError() {
            return this.mapping.getValidationError();
        }
    }

    public class SubsystemMapping {
        private boolean isValid = true;
        private IStatus validationError;
        private String serverTypeId;
        private String mappedId;
        private String subsystemId;

        public SubsystemMapping(String server, String mappedId, String subsystemId) {
            this.serverTypeId = server;
            this.mappedId = mappedId;
            this.subsystemId = subsystemId;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public String getServerType() {
            return this.serverTypeId;
        }

        public IStatus getValidationError() {
            return this.validationError;
        }

        public String getSubsystemId() {
            return this.subsystemId;
        }

        public String getMappedId() {
            return this.mappedId;
        }

        public SubsystemType getSubsystem() {
            return (SubsystemType)SubsystemModel.this.subsystemModel.get(this.subsystemId);
        }
    }

    protected static class SubsystemType {
        private String system;
        private String id;
        private String name;
        private boolean requiresRuntime;
        private IConfigurationElement element;
        private String[] requiredSystems;
        private HashMap<String, String> requiredSubsystems;
        private HashMap<String, String> props;

        public SubsystemType(IConfigurationElement element) {
            this.element = element;
            this.name = element.getAttribute("name");
            this.id = element.getAttribute("id");
            this.system = element.getAttribute("system");
            String reqRuntime = element.getAttribute("requiresRuntime");
            this.requiresRuntime = reqRuntime == null ? false : new Boolean(reqRuntime);
            HashSet<String> reqSystems = new HashSet<String>();
            HashMap<String, String> reqSubsystems = new HashMap<String, String>();
            IConfigurationElement[] children = element.getChildren("dependencies");
            int i = 0;
            while (i < children.length) {
                IConfigurationElement[] required = children[i].getChildren("requires");
                int j = 0;
                while (j < required.length) {
                    String systemReq = required[j].getAttribute("system");
                    String subsystemReq = required[j].getAttribute("subsystem");
                    if (systemReq != null) {
                        reqSystems.add(systemReq);
                    }
                    if (systemReq != null && subsystemReq != null) {
                        reqSubsystems.put(systemReq, subsystemReq);
                    }
                    ++j;
                }
                ++i;
            }
            this.requiredSystems = reqSystems.toArray(new String[reqSystems.size()]);
            this.requiredSubsystems = reqSubsystems;
            this.props = new HashMap();
            IConfigurationElement[] properties = element.getChildren("properties");
            int i2 = 0;
            while (i2 < properties.length) {
                IConfigurationElement[] property = properties[i2].getChildren("property");
                int j = 0;
                while (j < property.length) {
                    String key = property[j].getAttribute("key");
                    String value = property[j].getAttribute("value");
                    if (key != null && value != null) {
                        this.props.put(key, value);
                    }
                    ++j;
                }
                ++i2;
            }
        }

        private ISubsystemController createController() throws CoreException {
            return (ISubsystemController)this.element.createExecutableExtension("class");
        }

        public String[] getRequiredSystems() {
            return this.requiredSystems;
        }

        public Map<String, String> getRequiredSubsystems() {
            return (Map)this.requiredSubsystems.clone();
        }

        public boolean requiresRuntime() {
            return this.requiresRuntime;
        }

        public String getSystem() {
            return this.system;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return String.valueOf(this.getSystem()) + " - " + this.getId();
        }
    }
}

