/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public class UnitedServerListenerManager
implements IServerLifecycleListener,
IServerListener,
IPublishListener,
IRuntimeLifecycleListener {
    protected static UnitedServerListenerManager instance;
    private boolean isInitialized = false;
    protected ArrayList<UnitedServerListener> list = new ArrayList();

    public static synchronized UnitedServerListenerManager getDefault() {
        if (instance == null) {
            instance = new UnitedServerListenerManager();
        }
        return instance;
    }

    private UnitedServerListenerManager() {
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this);
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this);
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        while (i < allServers.length) {
            allServers[i].removeServerListener((IServerListener)new UnitedServerListener());
            allServers[i].removePublishListener((IPublishListener)new UnitedServerListener());
            allServers[i].addServerListener((IServerListener)this);
            allServers[i].addPublishListener((IPublishListener)this);
            ++i;
        }
    }

    public synchronized UnitedServerListener[] getListeners() {
        return this.list.toArray(new UnitedServerListener[this.list.size()]);
    }

    public static boolean isJBossServer(IServer server) {
        return ServerConverter.getJBossServer(server) != null;
    }

    public synchronized void addListener(UnitedServerListener listener) {
        if (!this.list.contains(listener)) {
            this.list.add(listener);
            if (this.isInitialized) {
                this.initializeListener(listener);
            }
        }
    }

    private synchronized void initializeCurrentListeners() {
        Iterator<UnitedServerListener> it = this.list.iterator();
        while (it.hasNext()) {
            this.initializeListener(it.next());
        }
        this.isInitialized = true;
    }

    private synchronized void initializeListener(UnitedServerListener listener) {
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        while (i < allServers.length) {
            listener.init(allServers[i]);
            ++i;
        }
    }

    public synchronized void removeListener(UnitedServerListener listener) {
        this.list.remove(listener);
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        while (i < allServers.length) {
            listener.cleanUp(allServers[i]);
            ++i;
        }
    }

    public void serverAdded(IServer server) {
        server.addServerListener((IServerListener)this);
        server.addPublishListener((IPublishListener)this);
        UnitedServerListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].canHandleServer(server)) {
                listeners[i].serverAdded(server);
            }
            ++i;
        }
    }

    public void serverChanged(IServer server) {
        UnitedServerListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].canHandleServer(server)) {
                listeners[i].serverChanged(server);
            }
            ++i;
        }
    }

    public void serverRemoved(IServer server) {
        server.removeServerListener((IServerListener)this);
        server.removePublishListener((IPublishListener)this);
        UnitedServerListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].canHandleServer(server)) {
                listeners[i].serverRemoved(server);
            }
            ++i;
        }
    }

    public void serverChanged(ServerEvent event) {
        IServer server = event.getServer();
        UnitedServerListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].canHandleServer(server)) {
                listeners[i].serverChanged(event);
            }
            ++i;
        }
    }

    public void publishStarted(IServer server) {
        UnitedServerListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].canHandleServer(server)) {
                listeners[i].publishStarted(server);
            }
            ++i;
        }
    }

    public void publishFinished(IServer server, IStatus status) {
        UnitedServerListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].canHandleServer(server)) {
                listeners[i].publishFinished(server, status);
            }
            ++i;
        }
    }

    public void runtimeAdded(IRuntime runtime) {
        UnitedServerListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].canHandleRuntime(runtime)) {
                listeners[i].runtimeAdded(runtime);
            }
            ++i;
        }
    }

    public void runtimeChanged(IRuntime runtime) {
        UnitedServerListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].canHandleRuntime(runtime)) {
                listeners[i].runtimeChanged(runtime);
            }
            ++i;
        }
    }

    public void runtimeRemoved(IRuntime runtime) {
        UnitedServerListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i].canHandleRuntime(runtime)) {
                listeners[i].runtimeRemoved(runtime);
            }
            ++i;
        }
    }
}

