/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.DataRowExpressionEvaluatorAdapter;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesGroupingImpl;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.reportitem.AbstractChartBaseQueryGenerator;
import org.eclipse.birt.chart.reportitem.BIRTCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.BaseGroupedQueryResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.ChartBaseQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartCubeQueryHelper;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.SharedCubeResultSetEvaluator;
import org.eclipse.birt.chart.reportitem.api.ChartCubeUtil;
import org.eclipse.birt.chart.reportitem.api.ChartItemUtil;
import org.eclipse.birt.chart.reportitem.api.ChartReportItemHelper;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIActivator;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIFactory;
import org.eclipse.birt.chart.reportitem.ui.ChartReportItemUIUtil;
import org.eclipse.birt.chart.reportitem.ui.ChartXTabUIUtil;
import org.eclipse.birt.chart.reportitem.ui.DteAdapter;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ColumnBindingInfo;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeFilterDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.DummyEngineTask;
import org.eclipse.birt.report.designer.internal.ui.data.DataService;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.IReportClasspathResolver;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDatasetPreviewTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ReportEngineFactory;
import org.eclipse.birt.report.engine.api.impl.ReportEngineHelper;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.re.CrosstabQueryUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.MultiViewsHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.util.CubeUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ReportDataServiceProvider
implements IDataServiceProvider {
    protected ExtendedItemHandle itemHandle;
    protected ChartWizardContext context;
    private final ShareBindingQueryHelper fShareBindingQueryHelper = new ShareBindingQueryHelper();
    static final String OPTION_NONE = Messages.getString("ReportDataServiceProvider.Option.None");
    ChartReportItemUIFactory uiFactory = ChartReportItemUIFactory.instance();
    protected DteAdapter dteAdapter = this.uiFactory.createDteAdapter();
    protected Object sessionLock = new Object();
    private boolean isErrorFound = false;
    private IProject project = null;
    protected DataRequestSession session = null;
    private ReportEngine engine = null;
    private ChartDummyEngineTask engineTask = null;
    private Object dataSetReference = null;
    private Map<String, ReportItemHandle> referMap = new HashMap<String, ReportItemHandle>();
    protected ChartExpressionUtil.ExpressionCodec exprCodec = null;
    private IDatasetPreviewTask dataSetPreviewTask;
    private ILogger logger = Logger.getLogger((String)"com.actuate.birt.chart.reportitem.ui/trace");

    public ReportDataServiceProvider(ExtendedItemHandle itemHandle) {
        this.itemHandle = itemHandle;
        this.project = UIUtil.getCurrentProject();
        this.exprCodec = ChartReportItemHelper.instance().createExpressionCodec(itemHandle);
    }

    private String[] getDesignWorkspaceClasspath() {
        IReportClasspathResolver provider = ReportPlugin.getDefault().getReportClasspathResolverService();
        if (provider != null) {
            String designPath = null;
            designPath = this.isLibraryHandle() ? ((LibraryHandle)this.itemHandle.getModuleHandle()).getFileName() : ((ReportDesignHandle)this.itemHandle.getModuleHandle()).getFileName();
            return provider.resolveClasspath((Object)designPath);
        }
        return null;
    }

    public void initialize() throws ChartException {
        try {
            EngineConfig config = new EngineConfig();
            String[] paths = this.getDesignWorkspaceClasspath();
            if (paths != null && paths.length > 0) {
                StringBuffer buffer = new StringBuffer();
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    if (buffer.length() > 0) {
                        buffer.append(';');
                    }
                    buffer.append(path);
                    ++n2;
                }
                if (buffer.length() != 0) {
                    HashMap appContext = config.getAppContext();
                    appContext.put("user.projectclasspath", buffer.toString());
                }
            }
            this.engine = (ReportEngine)new ReportEngineFactory().createReportEngine(config);
            if (this.isReportDesignHandle()) {
                this.engineTask = new ChartDummyEngineTask(this.engine, new ReportEngineHelper(this.engine).openReportDesign((ReportDesignHandle)this.itemHandle.getModuleHandle()), this.itemHandle.getModuleHandle());
                this.session = this.engineTask.getDataSession();
                this.engineTask.run();
                this.dteAdapter.setExecutionContext(this.engineTask.getExecutionContext());
            } else {
                ReportEngineHelper engineHelper = new ReportEngineHelper(this.engine);
                this.dataSetPreviewTask = engineHelper.createDatasetPreviewTask();
                DataSessionContext dsc = new DataSessionContext(3, this.getReportDesignHandle());
                this.session = DataRequestSession.newSession((DataSessionContext)dsc);
            }
        }
        catch (BirtException e) {
            if (this.engine == null && this.session != null) {
                this.session.shutdown();
            }
            if (this.engineTask != null) {
                this.engineTask.close();
            }
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
        }
    }

    public void dispose() {
        if (this.engineTask != null) {
            this.engineTask.close();
        } else if (this.session != null) {
            this.session.shutdown();
        }
    }

    public void setWizardContext(ChartWizardContext context) {
        this.context = context;
    }

    protected ModuleHandle getReportDesignHandle() {
        return this.itemHandle.getModuleHandle();
    }

    protected String[] getAllDataSets() {
        List list = this.getReportDesignHandle().getVisibleDataSets();
        String[] names = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            names[i] = ((DataSetHandle)list.get(i)).getQualifiedName();
            ++i;
        }
        return names;
    }

    protected String[] getAllDataCubes() {
        List list = this.getReportDesignHandle().getVisibleCubes();
        String[] names = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            names[i] = ((CubeHandle)list.get(i)).getQualifiedName();
            ++i;
        }
        return names;
    }

    public String getDataCube() {
        CubeHandle cube = this.itemHandle.getCube();
        if (cube == null) {
            return null;
        }
        return cube.getQualifiedName();
    }

    String getInheritedCube() {
        CubeHandle cube = null;
        DesignElementHandle container = this.itemHandle.getContainer();
        while (container != null) {
            if (container instanceof ReportItemHandle && (cube = ((ReportItemHandle)container).getCube()) != null) break;
            container = container.getContainer();
        }
        if (cube == null) {
            return null;
        }
        if (this.getBindingCubeHandle() == null) {
            return null;
        }
        return cube.getQualifiedName();
    }

    public void setDataCube(String cubeName) {
        try {
            boolean isPreviousDataBindingReference = false;
            if (this.itemHandle.getDataBindingType() == 2) {
                isPreviousDataBindingReference = true;
                this.itemHandle.setDataBindingReference(null);
            }
            this.itemHandle.setDataSet(null);
            if (cubeName == null) {
                this.itemHandle.setCube(null);
                this.clearBindings();
            } else if (!cubeName.equals(this.getDataCube()) || isPreviousDataBindingReference) {
                CubeHandle cubeHandle = this.getReportDesignHandle().findCube(cubeName);
                this.itemHandle.setCube(cubeHandle);
                this.clearBindings();
                this.generateBindings(ChartXTabUIUtil.generateComputedColumns(this.itemHandle, cubeHandle));
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setDataCube");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setDataCube", (String)e.getLocalizedMessage());
        }
    }

    public final String[] getPreviewHeader() {
        Iterator iterator = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)this.itemHandle);
        ArrayList<String> list = new ArrayList<String>();
        boolean bInheritColumnsOnly = this.isInheritColumnsOnly();
        while (iterator.hasNext()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)iterator.next();
            if (bInheritColumnsOnly && binding.getAggregateFunction() != null) continue;
            list.add(binding.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<Object[]> getPreviewData() throws ChartException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.engineTask != null) {
                try {
                    this.engineTask.run();
                }
                catch (EngineException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
                }
            }
            List<Object[]> values = null;
            values = this.isSharedBinding() || this.isInheritColumnsGroups() ? this.fShareBindingQueryHelper.getPreviewRowData(this.getPreviewHeadersInfo(), -1, true) : this.getPreviewRowData(this.getPreviewHeader(false), -1, true);
            this.dataSetReference = this.getBindingDataSetHandle();
            return values;
        }
    }

    private void removeIndirectRefOfAggregates(List<ComputedColumnHandle> list, Map<String, ComputedColumnHandle> bindingMap) throws BirtException {
        Iterator<ComputedColumnHandle> iter = list.iterator();
        while (iter.hasNext()) {
            ComputedColumnHandle cch = iter.next();
            if (this.isCommonBinding(cch, bindingMap)) continue;
            iter.remove();
        }
    }

    private boolean isCommonBinding(ComputedColumnHandle cch, Map<String, ComputedColumnHandle> bindingMap) throws BirtException {
        ScriptExpression se = ChartReportItemUtil.newExpression((IModelAdapter)this.session.getModelAdaptor(), (ComputedColumnHandle)cch);
        List bindings = ExpressionUtil.extractColumnExpressions((String)se.getText(), (String)"row");
        int i = 0;
        while (i < bindings.size()) {
            ComputedColumnHandle refCch = bindingMap.get(((IColumnBinding)bindings.get(i)).getResultSetColumnName());
            if (refCch.getAggregateFunction() != null) {
                return false;
            }
            if (refCch.getExpression() != null && !this.isCommonBinding(refCch, bindingMap)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final ColumnBindingInfo[] getPreviewHeadersInfo() throws ChartException {
        Iterator iterator = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)this.itemHandle);
        if (iterator == null) {
            return new ColumnBindingInfo[0];
        }
        HashMap<String, ComputedColumnHandle> bindingMap = new HashMap<String, ComputedColumnHandle>();
        ArrayList<ComputedColumnHandle> columnList = new ArrayList<ComputedColumnHandle>();
        boolean bInheritColumnsOnly = this.isInheritColumnsOnly();
        while (iterator.hasNext()) {
            ComputedColumnHandle binding = (ComputedColumnHandle)iterator.next();
            bindingMap.put(binding.getName(), binding);
            if (bInheritColumnsOnly && binding.getAggregateFunction() != null) continue;
            columnList.add(binding);
        }
        try {
            if (bInheritColumnsOnly) {
                this.removeIndirectRefOfAggregates(columnList, bindingMap);
            }
        }
        catch (BirtException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
        }
        if (columnList.size() == 0) {
            return new ColumnBindingInfo[0];
        }
        ColumnBindingInfo[] columnHeaders = null;
        if (this.isTableSharedBinding() || this.isInheritColumnsGroups()) {
            columnHeaders = this.fShareBindingQueryHelper.getPreviewHeadersInfo(columnList);
        } else {
            columnHeaders = new ColumnBindingInfo[columnList.size()];
            int i = 0;
            while (i < columnHeaders.length) {
                ComputedColumnHandle cch = (ComputedColumnHandle)columnList.get(i);
                columnHeaders[i] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), null, null, (Object)cch);
                ++i;
            }
        }
        ArrayList<ColumnBindingInfo> columnsSet = new ArrayList<ColumnBindingInfo>();
        int i = columnHeaders.length - 1;
        while (i >= 0) {
            columnsSet.add(columnHeaders[i]);
            --i;
        }
        Collections.sort(columnsSet, new ColumnNameComprator());
        columnHeaders = columnsSet.toArray(new ColumnBindingInfo[0]);
        return columnHeaders;
    }

    private String[] getPreviewHeader(boolean isExpression) throws ChartException {
        ColumnBindingInfo[] cbis = this.getPreviewHeadersInfo();
        String[] exps = new String[cbis.length];
        int i = 0;
        ColumnBindingInfo[] columnBindingInfoArray = cbis;
        int n = cbis.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnBindingInfo cbi = columnBindingInfoArray[n2];
            exps[i] = isExpression ? ExpressionUtil.createJSRowExpression((String)cbi.getName()) : cbi.getName();
            ++i;
            ++n2;
        }
        return exps;
    }

    protected final List<Object[]> getPreviewRowData(String[] bindingNames, int rowCount, boolean isStringType) throws ChartException {
        List<Object> dataList = null;
        ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader parentLoader = oldContextLoader;
        if (parentLoader == null) {
            parentLoader = this.getClass().getClassLoader();
        }
        ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)this.itemHandle.getModuleHandle());
        Thread.currentThread().setContextClassLoader(newContextLoader);
        try {
            try {
                DataSetHandle datasetHandle = this.getDataSetFromHandle();
                QueryDefinition queryDefn = new QueryDefinition();
                queryDefn.setMaxRows(this.getMaxRow());
                queryDefn.setDataSetName(datasetHandle.getQualifiedName());
                this.setQueryDefinitionWithDataSet(this.itemHandle, queryDefn);
                if (this.isLibraryHandle() && datasetHandle instanceof ScriptDataSetHandle) {
                    this.dataSetPreviewTask.setQuery(queryDefn);
                    this.dataSetPreviewTask.setDataSet(datasetHandle);
                    IExtractionResults ier = this.dataSetPreviewTask.execute();
                    if (ier != null) {
                        IResultIterator iter = ier.nextResultIterator().getResultIterator();
                        dataList = this.iterateDataSetResults(iter, bindingNames, isStringType);
                        ier.close();
                    }
                } else {
                    IQueryResults actualResultSet = this.executeDataSetQuery(queryDefn);
                    if (actualResultSet != null) {
                        IResultIterator iter = actualResultSet.getResultIterator();
                        dataList = this.iterateDataSetResults(iter, bindingNames, isStringType);
                        actualResultSet.close();
                    }
                }
            }
            catch (BirtException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextLoader);
        }
        return dataList == null ? new ArrayList() : dataList;
    }

    private List<Object[]> iterateDataSetResults(IResultIterator iter, String[] bindingNames, boolean isStringType) throws BirtException {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        String[] expressions = bindingNames;
        int columnCount = expressions.length;
        while (iter.next()) {
            int n;
            Object[] record;
            if (isStringType) {
                record = new String[columnCount];
                n = 0;
                while (n < columnCount) {
                    record[n] = this.valueAsString(iter.getValue(expressions[n]));
                    ++n;
                }
                dataList.add(record);
                continue;
            }
            record = new Object[columnCount];
            n = 0;
            while (n < columnCount) {
                record[n] = iter.getValue(expressions[n]);
                ++n;
            }
            dataList.add(record);
        }
        return dataList;
    }

    private String valueAsString(Object source) throws NumberFormatException, BirtException {
        if (source == null) {
            return null;
        }
        if (source instanceof Number) {
            ULocale locale = ULocale.getDefault();
            String value = source.toString();
            int index = value.indexOf(69);
            if (index >= 0) {
                String returnValue = String.valueOf(DataTypeUtil.toString((Object)Double.valueOf(value.substring(0, index)), (ULocale)locale)) + "E";
                String exponent = value.substring(index + 1);
                returnValue = exponent.matches("[\\+-]+[1-9]{1}[0-9]*") ? String.valueOf(returnValue) + exponent.substring(0, 1) + DataTypeUtil.toString((Object)Integer.valueOf(exponent.substring(1)), (ULocale)locale) : String.valueOf(returnValue) + DataTypeUtil.toString((Object)Integer.valueOf(exponent), (ULocale)locale);
                return returnValue;
            }
        }
        return DataTypeUtil.toString((Object)source);
    }

    private boolean isReportDesignHandle() {
        return this.itemHandle.getModuleHandle() instanceof ReportDesignHandle;
    }

    private boolean isLibraryHandle() {
        return this.itemHandle.getModuleHandle() instanceof LibraryHandle;
    }

    private void handleGroup(QueryDefinition queryDefn, ExtendedItemHandle reportItemHandle, IModelAdapter modelAdapter) {
        ReportItemHandle handle = ChartReportItemUtil.getBindingHolder((DesignElementHandle)reportItemHandle);
        if (handle instanceof ListingHandle) {
            SlotHandle groups = ((ListingHandle)handle).getGroups();
            Iterator iter = groups.iterator();
            while (iter.hasNext()) {
                ChartBaseQueryHelper.handleGroup((GroupHandle)((GroupHandle)iter.next()), (IBaseQueryDefinition)queryDefn, (IModelAdapter)modelAdapter);
            }
        }
    }

    private QueryDefinition resetParametersForDataPreview(DataSetHandle dataSetHandle, QueryDefinition queryDefn) {
        Iterator iterParams;
        LinkedHashMap<String, DataSetParameterHandle> dsphMap = new LinkedHashMap<String, DataSetParameterHandle>();
        if (dataSetHandle != null) {
            iterParams = dataSetHandle.parametersIterator();
            while (iterParams.hasNext()) {
                DataSetParameterHandle dsph = (DataSetParameterHandle)iterParams.next();
                dsphMap.put(dsph.getName(), dsph);
            }
        }
        iterParams = this.itemHandle.getPropertyHandle("paramBindings").iterator();
        LinkedHashMap<String, ParamBindingHandle> pbhMap = new LinkedHashMap<String, ParamBindingHandle>();
        while (iterParams.hasNext()) {
            ParamBindingHandle paramBindingHandle = (ParamBindingHandle)iterParams.next();
            pbhMap.put(paramBindingHandle.getParamName(), paramBindingHandle);
        }
        Object[] names = pbhMap.keySet().toArray();
        int i = 0;
        while (i < names.length) {
            DataSetParameterHandle dsph = (DataSetParameterHandle)dsphMap.get(names[i]);
            ScriptExpression se = null;
            String expr = ((ParamBindingHandle)pbhMap.get(names[i])).getExpression();
            se = dsph.getDefaultValue() != null && (expr == null || expr.indexOf("row[") >= 0 || expr.indexOf("row.") >= 0) ? new ScriptExpression(dsph.getDefaultValue()) : new ScriptExpression(expr);
            InputParameterBinding ipb = new InputParameterBinding((String)names[i], (IBaseExpression)se);
            queryDefn.addInputParamBinding(ipb);
            ++i;
        }
        return queryDefn;
    }

    public String getDataSet() {
        if (this.itemHandle.getDataSet() == null) {
            return null;
        }
        return this.itemHandle.getDataSet().getQualifiedName();
    }

    boolean isInheritanceOnly() {
        return this.isInXTabCell() || this.isInMultiView() || this.isInXTabMeasureCell();
    }

    boolean isInheritCube() {
        return this.getDataSet() == null && this.getDataCube() == null && this.checkState(8192);
    }

    protected boolean isInMultiView() {
        return this.itemHandle.getContainer() instanceof MultiViewsHandle;
    }

    String getInheritedDataSet() {
        List list = DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer());
        if (list.size() > 0) {
            if (this.getBindingDataSetHandle() == null) {
                return null;
            }
            return ((DataSetHandle)list.get(0)).getQualifiedName();
        }
        return null;
    }

    public void setDataSet(String datasetName) {
        try {
            boolean isPreviousDataBindingReference = false;
            if (this.itemHandle.getDataBindingType() == 2) {
                isPreviousDataBindingReference = true;
                this.itemHandle.setDataBindingReference(null);
            }
            this.itemHandle.setCube(null);
            if (datasetName == null) {
                if (this.getDataSet() != null) {
                    this.clearBindings();
                }
                this.itemHandle.setDataSet(null);
            } else {
                DataSetHandle dataset = this.getReportDesignHandle().findDataSet(datasetName);
                if (isPreviousDataBindingReference || this.itemHandle.getDataSet() != dataset) {
                    this.itemHandle.setDataSet(dataset);
                    this.clearBindings();
                    this.generateBindings(this.generateComputedColumns(dataset));
                    this.enableCategoryGroup();
                }
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setDataSet");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setDataSet", (String)e.getLocalizedMessage());
        }
    }

    protected void enableCategoryGroup() {
        EList sds;
        if (!"Gantt Chart".equals(this.context.getModel().getType()) && !"Stock Chart".equals(this.context.getModel().getType()) && (sds = ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel())) != null && sds.size() > 0) {
            SeriesDefinition base = (SeriesDefinition)sds.get(0);
            if (base.getGrouping() == null) {
                base.setGrouping(SeriesGroupingImpl.create());
            }
            base.getGrouping().setEnabled(true);
        }
    }

    protected void clearBindings() throws SemanticException {
        this.clearProperty(this.itemHandle.getPropertyHandle("paramBindings"));
        this.clearProperty(this.itemHandle.getPropertyHandle("filter"));
        this.clearProperty(this.itemHandle.getColumnBindings());
    }

    private void clearProperty(PropertyHandle property) throws SemanticException {
        if (property != null) {
            property.clearValue();
        }
    }

    private Iterator<?> getPropertyIterator(PropertyHandle property) {
        if (property != null) {
            return property.iterator();
        }
        return null;
    }

    protected void generateBindings(List<ComputedColumn> columnList) throws SemanticException {
        if (columnList.size() > 0) {
            Iterator<ComputedColumn> iter = columnList.iterator();
            while (iter.hasNext()) {
                DEUtil.addColumn((DesignElementHandle)this.itemHandle, (ComputedColumn)iter.next(), (boolean)false);
            }
        }
    }

    protected List<ComputedColumn> generateComputedColumns(DataSetHandle dataSetHandle) throws SemanticException {
        return ChartReportItemUIUtil.generateComputedColumns((ReportItemHandle)this.itemHandle, dataSetHandle);
    }

    protected DataSetHandle getDataSetFromHandle() {
        if (this.itemHandle.getDataSet() != null) {
            return this.itemHandle.getDataSet();
        }
        List datasetList = DEUtil.getDataSetList((DesignElementHandle)this.itemHandle.getContainer());
        if (datasetList.size() > 0) {
            return (DataSetHandle)datasetList.get(0);
        }
        return null;
    }

    protected void processQueryDefinition(QueryDefinition queryDefn) {
    }

    private StyleHandle[] getAllStyleHandles() {
        List sLst = this.getReportDesignHandle().getAllStyles();
        StyleHandle[] list = sLst.toArray(new StyleHandle[sLst.size()]);
        Arrays.sort(list, new Comparator<StyleHandle>(){
            Collator collator = Collator.getInstance((ULocale)ULocale.getDefault());

            @Override
            public int compare(StyleHandle s1, StyleHandle s2) {
                return this.collator.compare(s1.getDisplayLabel(), s2.getDisplayLabel());
            }
        });
        return list;
    }

    public String[] getAllStyles() {
        StyleHandle[] handles = this.getAllStyleHandles();
        String[] names = new String[handles.length];
        int i = 0;
        while (i < names.length) {
            names[i] = handles[i].getQualifiedName();
            ++i;
        }
        names = this.filterPreStyles(names);
        return names;
    }

    private String[] filterPreStyles(String[] items) {
        String[] newItems = items;
        if (items == null) {
            newItems = new String[]{};
        }
        List preStyles = new DesignEngine(new DesignConfig()).getMetaData().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        int i = 0;
        while (i < preStyles.size()) {
            preStyleNames.add(((IPredefinedStyle)preStyles.get(i)).getName());
            ++i;
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        int i2 = 0;
        while (i2 < newItems.length) {
            if (preStyleNames.indexOf(newItems[i2]) == -1) {
                sytleNames.add(newItems[i2]);
            }
            ++i2;
        }
        return sytleNames.toArray(new String[0]);
    }

    public String[] getAllStyleDisplayNames() {
        List<String> styles = Arrays.asList(this.getAllStyles());
        StyleHandle[] handles = this.getAllStyleHandles();
        String[] names = new String[styles.size()];
        int i = 0;
        int j = 0;
        while (i < handles.length) {
            if (styles.contains(handles[i].getQualifiedName())) {
                names[j++] = handles[i].getDisplayLabel();
            }
            ++i;
        }
        return names;
    }

    public String getCurrentStyle() {
        if (this.itemHandle.getStyle() == null) {
            return null;
        }
        return this.itemHandle.getStyle().getQualifiedName();
    }

    public void setStyle(String styleName) {
        try {
            if (styleName == null) {
                this.itemHandle.setStyle(null);
            } else {
                this.itemHandle.setStyle(this.getStyle(styleName));
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setStyle");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setStyle", (String)e.getLocalizedMessage());
        }
    }

    private SharedStyleHandle getStyle(String styleName) {
        return this.getReportDesignHandle().findStyle(styleName);
    }

    public final Object[] getDataForColumns(String[] sExpressions, int iMaxRecords, boolean byRow) throws ChartException {
        return null;
    }

    protected int getMaxRow() {
        return PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ChartReportItemUIActivator.getDefault(), this.project).getInt("max_row");
    }

    public boolean isLivePreviewEnabled() {
        return !this.isErrorFound && PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)ChartReportItemUIActivator.getDefault(), this.project).getBoolean("enable_live") && ChartReportItemUtil.getBindingHolder((DesignElementHandle)this.itemHandle) != null;
    }

    boolean isInvokingSupported() {
        if (this.isSharedBinding() || this.isInMultiView()) {
            return false;
        }
        ReportItemHandle container = DEUtil.getBindingHolder((DesignElementHandle)this.itemHandle);
        if (container != null) {
            return container.getDataBindingReference() == null;
        }
        return true;
    }

    public DataType getDataType(String expression) {
        return ChartItemUtil.getExpressionDataType((String)expression, (ReportItemHandle)this.itemHandle);
    }

    protected String[] getAllReportItemReferences() {
        List availableList = this.itemHandle.getAvailableDataBindingReferenceList();
        ArrayList<ReportItemHandle> referenceList = new ArrayList<ReportItemHandle>();
        for (ReportItemHandle handle : availableList) {
            String extensionName;
            if (handle instanceof ExtendedItemHandle && !this.isAvailableExtensionToReferenceDataBinding(extensionName = ((ExtendedItemHandle)handle).getExtensionName())) continue;
            referenceList.add(handle);
        }
        return this.getAllReportItemReferences(referenceList);
    }

    protected boolean isAvailableExtensionToReferenceDataBinding(String extensionName) {
        return "Chart".equals(extensionName) || "Crosstab".equals(extensionName);
    }

    private String[] getAllReportItemReferences(List<ReportItemHandle> referenceList) {
        this.referMap.clear();
        if (referenceList.isEmpty()) {
            return new String[0];
        }
        Object[] references = new String[referenceList.size()];
        int i = 0;
        for (ReportItemHandle item : referenceList) {
            if (item.getName() == null) continue;
            references[i] = item.getQualifiedName();
            this.referMap.put((String)references[i], item);
            ++i;
        }
        int tmp = i;
        Arrays.sort(references, 0, tmp);
        for (ReportItemHandle item : referenceList) {
            if (item.getName() != null) continue;
            references[i++] = String.valueOf(item.getElement().getDefn().getDisplayName()) + " (ID " + item.getID() + ") - " + org.eclipse.birt.report.designer.nls.Messages.getString((String)"BindingPage.ReportItem.NoName");
        }
        Arrays.sort(references, tmp, referenceList.size());
        return references;
    }

    protected boolean isNoNameItem(String name) {
        ReportItemHandle item = this.referMap.get(name);
        return item == null || item.getName() == null;
    }

    String getReportItemReference() {
        ReportItemHandle ref = this.itemHandle.getDataBindingReference();
        if (ref == null) {
            return null;
        }
        return ref.getQualifiedName();
    }

    void setReportItemReference(String referenceName) {
        try {
            if (referenceName == null) {
                this.itemHandle.setDataBindingReference(null);
            } else {
                this.itemHandle.setDataSet(null);
                this.itemHandle.setCube(null);
                if (!referenceName.equals(this.getReportItemReference())) {
                    this.itemHandle.setDataBindingReference((ReportItemHandle)this.getReportDesignHandle().findElement(referenceName));
                }
            }
            ChartWizard.removeException((String)"ReportDataServiceProvider.setReportItemReference");
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setReportItemReference", (String)e.getLocalizedMessage());
        }
    }

    protected void setRowLimit(DataRequestSession session, int rowLimit, boolean isCubeMode) {
        PropertyHandle filterProperty = this.itemHandle.getPropertyHandle("filter");
        if (filterProperty == null || filterProperty.getListValue() == null || filterProperty.getListValue().size() == 0) {
            this.dteAdapter.setRowLimit(session, rowLimit, isCubeMode);
        } else {
            this.dteAdapter.setRowLimit(session, -1, isCubeMode);
        }
    }

    protected boolean needDefineCube(CubeHandle cube) {
        return this.dataSetReference != cube;
    }

    private boolean needDefineDataSet(DataSetHandle dataSetHandle) {
        return this.dataSetReference != dataSetHandle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDataRowExpressionEvaluator prepareRowExpressionEvaluator(Chart cm, List<String> columnExpression, int rowCount, boolean isStringType) throws ChartException {
        Object object = this.sessionLock;
        synchronized (object) {
            ClassLoader oldContextLoader;
            ClassLoader parentLoader;
            if (this.engineTask != null) {
                try {
                    this.engineTask.run();
                }
                catch (EngineException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
                }
            }
            if ((parentLoader = (oldContextLoader = Thread.currentThread().getContextClassLoader())) == null) {
                parentLoader = this.getClass().getClassLoader();
            }
            ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)this.itemHandle.getModuleHandle());
            Thread.currentThread().setContextClassLoader(newContextLoader);
            IDataRowExpressionEvaluator evaluator = null;
            try {
                CubeHandle cube = this.getBindingCubeHandle();
                if (cube != null) {
                    evaluator = this.createCubeEvaluator(cube, cm, columnExpression);
                    this.dataSetReference = cube;
                } else {
                    evaluator = this.isSharedBinding() && !ChartReportItemUtil.isOldChartUsingInternalGroup((ReportItemHandle)this.itemHandle, (Chart)cm) || this.isInheritColumnsGroups() ? (this.isSharingChart(true) ? this.createBaseEvaluator((ExtendedItemHandle)ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle), cm, columnExpression) : this.fShareBindingQueryHelper.createShareBindingEvaluator(cm, columnExpression)) : this.createBaseEvaluator(this.itemHandle, cm, columnExpression);
                    this.dataSetReference = this.getBindingDataSetHandle();
                }
                IDataRowExpressionEvaluator iDataRowExpressionEvaluator = evaluator;
                return iDataRowExpressionEvaluator;
            }
            catch (BirtException e) {
                this.logger.log((Exception)((Object)e));
                throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
            }
            catch (RuntimeException e) {
                throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextLoader);
            }
        }
    }

    private IDataRowExpressionEvaluator createBaseEvaluator(ExtendedItemHandle handle, Chart cm, List<String> columnExpression) throws ChartException {
        BaseQueryHelper cbqh = new BaseQueryHelper(handle, cm);
        QueryDefinition queryDefn = (QueryDefinition)cbqh.createBaseQuery(columnExpression);
        try {
            this.setQueryDefinitionWithDataSet(handle, queryDefn);
            this.processQueryDefinition(queryDefn);
            IQueryResults actualResultSet = this.executeDataSetQuery(queryDefn);
            if (actualResultSet != null) {
                if (ChartReportItemUtil.isOldChartUsingInternalGroup((ReportItemHandle)this.itemHandle, (Chart)cm)) {
                    return this.createSimpleExpressionEvaluator(actualResultSet);
                }
                return new BaseGroupedQueryResultSetEvaluator(actualResultSet.getResultIterator(), ChartReportItemUtil.isSetSummaryAggregation((Chart)cm), cm, this.itemHandle);
            }
        }
        catch (BirtException e) {
            throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
        }
        return null;
    }

    private IQueryResults executeDataSetQuery(QueryDefinition queryDefn) throws AdapterException, BirtException {
        DataSetHandle dataSetHandle = this.getBindingDataSetHandle();
        if (this.needDefineDataSet(dataSetHandle)) {
            DataService.getInstance().registerSession(dataSetHandle, this.session);
            this.dteAdapter.defineDataSet(dataSetHandle, this.session, true, false);
        }
        this.setRowLimit(this.session, this.getMaxRow(), false);
        IQueryResults actualResultSet = this.dteAdapter.executeQuery(this.session, (IQueryDefinition)queryDefn);
        return actualResultSet;
    }

    private void setQueryDefinitionWithDataSet(ExtendedItemHandle handle, QueryDefinition queryDefn) throws AdapterException, DataException {
        this.resetParametersForDataPreview(this.getDataSetFromHandle(), queryDefn);
        Iterator bindingIt = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)handle, (boolean)true);
        while (bindingIt != null && bindingIt.hasNext()) {
            Object computedBinding = bindingIt.next();
            IBinding binding = this.session.getModelAdaptor().adaptBinding((ComputedColumnHandle)computedBinding);
            if (binding == null || queryDefn.getBindings().containsKey(binding.getBindingName())) continue;
            queryDefn.addBinding(binding);
        }
        Iterator<FilterConditionHandle> filtersIterator = this.getFiltersIterator();
        if (filtersIterator != null) {
            while (filtersIterator.hasNext()) {
                FilterDefinition filter = this.session.getModelAdaptor().adaptFilter(filtersIterator.next());
                queryDefn.addFilter((IFilterDefinition)filter);
            }
        }
        this.handleGroup(queryDefn, handle, this.session.getModelAdaptor());
    }

    private IDataRowExpressionEvaluator createSimpleExpressionEvaluator(IQueryResults actualResultSet) throws BirtException {
        final IResultIterator resultIterator = actualResultSet.getResultIterator();
        return new DataRowExpressionEvaluatorAdapter(){

            public Object evaluate(String expression) {
                try {
                    return resultIterator.getValue(expression);
                }
                catch (BirtException birtException) {
                    return null;
                }
            }

            public Object evaluateGlobal(String expression) {
                return this.evaluate(expression);
            }

            public boolean next() {
                try {
                    return resultIterator.next();
                }
                catch (BirtException birtException) {
                    return false;
                }
            }

            public void close() {
                try {
                    resultIterator.close();
                }
                catch (BirtException birtException) {
                    return;
                }
            }

            public boolean first() {
                try {
                    return resultIterator.next();
                }
                catch (BirtException birtException) {
                    return false;
                }
            }
        };
    }

    private Iterator<FilterConditionHandle> getFiltersIterator() {
        Iterator filterIterator;
        ArrayList<FilterConditionHandle> filterList = new ArrayList<FilterConditionHandle>();
        PropertyHandle ph = null;
        if (this.getDataSet() == null && this.getReportItemReference() == null) {
            Iterator filterIterator2;
            ReportItemHandle bindingHolder = ChartReportItemUtil.getBindingHolder((DesignElementHandle)this.itemHandle);
            PropertyHandle propertyHandle = ph = bindingHolder == null ? null : bindingHolder.getPropertyHandle("filter");
            if (ph != null && (filterIterator2 = ph.iterator()) != null) {
                while (filterIterator2.hasNext()) {
                    FilterConditionHandle filter = (FilterConditionHandle)filterIterator2.next();
                    if (filter.getValue1() != null && filter.getValue1().indexOf("._outer") >= 0 || filter.getValue2() != null && filter.getValue2().indexOf("._outer") >= 0) continue;
                    filterList.add(filter);
                }
            }
        }
        if ((ph = this.itemHandle.getPropertyHandle("filter")) != null && (filterIterator = ph.iterator()) != null) {
            while (filterIterator.hasNext()) {
                FilterConditionHandle filter = (FilterConditionHandle)filterIterator.next();
                if (filter.getValue1() != null && filter.getValue1().indexOf("._outer") >= 0 || filter.getValue2() != null && filter.getValue2().indexOf("._outer") >= 0) continue;
                filterList.add(filter);
            }
        }
        return filterList.isEmpty() ? null : filterList.iterator();
    }

    protected IDataRowExpressionEvaluator createCubeEvaluator(CubeHandle cube, Chart cm, List<String> columnExpression) throws BirtException {
        boolean isSharingXtab;
        IBaseCubeQueryDefinition qd = null;
        ReportItemHandle referredHandle = ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle);
        boolean isCrosstabReference = referredHandle != null && "Crosstab".equals(((ExtendedItemHandle)referredHandle).getExtensionName());
        boolean bl = isSharingXtab = referredHandle != null && isCrosstabReference;
        if (isSharingXtab) {
            ExtendedItemHandle bindingHandle = (ExtendedItemHandle)referredHandle;
            qd = CrosstabQueryUtil.createCubeQuery((CrosstabReportItemHandle)((CrosstabReportItemHandle)bindingHandle.getReportItem()), null, (IModelAdapter)this.session.getModelAdaptor(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        } else {
            qd = new ChartCubeQueryHelper(this.itemHandle, cm, this.session.getModelAdaptor()).createCubeQuery(null);
        }
        if (qd instanceof ICubeQueryDefinition && columnExpression != null && columnExpression.size() > 0) {
            ICubeQueryDefinition queryDef = (ICubeQueryDefinition)qd;
            HashSet<String> bindingNames = new HashSet<String>();
            List bindings = queryDef.getBindings();
            int i = 0;
            while (i < bindings.size()) {
                bindingNames.add(((Binding)bindings.get(i)).getBindingName());
                ++i;
            }
            ChartExpressionUtil.ExpressionSet exprSet = new ChartExpressionUtil.ExpressionSet();
            exprSet.addAll(columnExpression);
            for (String expr : exprSet) {
                this.exprCodec.decode(expr);
                String bindingName = null;
                bindingName = this.exprCodec.isCubeBinding(false) ? this.exprCodec.getCubeBindingName(false) : this.exprCodec.getExpression();
                if (bindingNames.contains(bindingName)) continue;
                bindingNames.add(bindingName);
                Binding colBinding = new Binding(bindingName);
                colBinding.setDataType(0);
                colBinding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression((ChartExpressionUtil.ExpressionCodec)this.exprCodec, (IModelAdapter)this.session.getModelAdaptor(), (boolean)true));
                queryDef.addBinding((IBinding)colBinding);
            }
        }
        this.resetCubeQuery(qd);
        this.registerCubeHandleToDataSession(cube, isSharingXtab);
        BIRTCubeResultSetEvaluator bcrse = this.executeCubeQuery(qd, isSharingXtab, cm);
        return bcrse;
    }

    protected BIRTCubeResultSetEvaluator executeCubeQuery(IBaseCubeQueryDefinition qd, boolean isSharingXtab, Chart cm) throws BirtException {
        ICubeQueryResults cqr = this.dteAdapter.executeQuery(this.session, (ICubeQueryDefinition)qd);
        Object bcrse = null;
        bcrse = isSharingXtab ? new SharedCubeResultSetEvaluator(cqr, qd, cm) : new BIRTCubeResultSetEvaluator(cqr);
        bcrse.setSizeLimit((long)this.getMaxRow());
        return bcrse;
    }

    protected void registerCubeHandleToDataSession(CubeHandle cube, boolean isCrosstabReference) throws BirtException, AdapterException {
        if (this.needDefineCube(cube)) {
            DataService.getInstance().registerSession(cube, this.session);
            this.session.defineCube(cube);
        }
    }

    protected void resetCubeQuery(IBaseCubeQueryDefinition qd) {
        ICubeQueryDefinition cqd = (ICubeQueryDefinition)qd;
        Iterator iter = cqd.getFilters().iterator();
        while (iter.hasNext()) {
            ICubeFilterDefinition cfd = (ICubeFilterDefinition)iter.next();
            ConditionalExpression ce = (ConditionalExpression)cfd.getExpression();
            if (!this.hasOuterExpr((IBaseExpression)ce)) continue;
            iter.remove();
        }
    }

    private boolean hasOuterExpr(IBaseExpression be) {
        if (be == null) {
            return false;
        }
        if (be instanceof IScriptExpression) {
            IScriptExpression se = (IScriptExpression)be;
            return se.getText() != null && se.getText().indexOf("._outer") >= 0;
        }
        if (be instanceof IExpressionCollection) {
            IExpressionCollection ec = (IExpressionCollection)be;
            for (Object expr : ec.getExpressions()) {
                if (!(expr instanceof IBaseExpression) || !this.hasOuterExpr((IBaseExpression)expr)) continue;
                return true;
            }
        } else if (be instanceof IConditionalExpression) {
            IConditionalExpression ce = (IConditionalExpression)be;
            return this.hasOuterExpr((IBaseExpression)ce.getExpression()) || this.hasOuterExpr(ce.getOperand1()) || this.hasOuterExpr(ce.getOperand2());
        }
        return false;
    }

    boolean isInXTabMeasureCell() {
        return ChartCubeUtil.isInXTabMeasureCell((DesignElementHandle)this.itemHandle);
    }

    boolean isInXTabCell() {
        try {
            return ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.itemHandle, (boolean)false) != null;
        }
        catch (BirtException birtException) {
            return false;
        }
    }

    boolean isInXTabNonAggrCell() {
        return this.isInXTabCell() && !this.isInXTabAggrCell();
    }

    public boolean isPartChart() {
        return ChartCubeUtil.isPlotChart((DesignElementHandle)this.itemHandle) || ChartCubeUtil.isAxisChart((DesignElementHandle)this.itemHandle);
    }

    public boolean isSharedBinding() {
        return this.itemHandle.getDataBindingReference() != null || this.isInMultiView();
    }

    boolean isTableSharedBinding() {
        return this.isSharedBinding() && this.getBindingCubeHandle() == null;
    }

    public void setPredefinedExpressions(ColumnBindingInfo[] headers) {
        if (this.isSharedBinding() || this.isInheritColumnsGroups()) {
            this.fShareBindingQueryHelper.setPredefinedExpressions(headers);
        } else {
            this.context.addPredefinedQuery("category", (Object[])headers);
            this.context.addPredefinedQuery("value", (Object[])headers);
            this.context.addPredefinedQuery("optional", (Object[])headers);
        }
    }

    public ReportItemHandle getReportItemHandle() {
        if (this.isSharedBinding()) {
            if (this.isInMultiView()) {
                return (ReportItemHandle)this.itemHandle.getContainer().getContainer();
            }
            return this.itemHandle.getDataBindingReference();
        }
        if (this.isInXTabNonAggrCell() && this.isInheritCube()) {
            ExtendedItemHandle handle = this.itemHandle;
            while (handle != null) {
                if (!((handle = handle.getContainer()) instanceof ReportItemHandle) || ((ReportItemHandle)handle).getColumnBindings() == null) continue;
                return (ReportItemHandle)handle;
            }
            return null;
        }
        return this.itemHandle;
    }

    public boolean update(String type, Object value) {
        boolean isUpdated = false;
        if ("CopySeriesDefinition".equals(type)) {
            this.copySeriesDefinition(value);
        } else if ("value".equals(type) && (this.getDataCube() != null && this.isSharedBinding() || this.isInXTabNonAggrCell() && this.isInheritCube())) {
            ComputedColumnHandle cch;
            String[] levelNames;
            LinkedHashMap<String, ComputedColumnHandle> bindingMap = new LinkedHashMap<String, ComputedColumnHandle>();
            Iterator bindings = ChartReportItemUtil.getAllColumnBindingsIterator((ReportItemHandle)this.itemHandle);
            while (bindings.hasNext()) {
                ComputedColumnHandle column = (ComputedColumnHandle)bindings.next();
                bindingMap.put(column.getName(), column);
            }
            String bindingName = this.exprCodec.getBindingName((String)value);
            ComputedColumnHandle computedBinding = (ComputedColumnHandle)bindingMap.get(bindingName);
            ChartAdapter.beginIgnoreNotifications();
            String exprType = UIUtil.getDefaultScriptType();
            List aggOnList = computedBinding.getAggregateOnList();
            if (aggOnList.size() > 0) {
                levelNames = CubeUtil.splitLevelName((String)((String)aggOnList.get(0)));
                cch = ChartReportItemHelper.instance().findDimensionBinding(this.exprCodec, levelNames[0], levelNames[1], bindingMap.values(), (ReportItemHandle)this.itemHandle);
                if (cch != null) {
                    this.setCategoryExpression(exprType, cch);
                }
            }
            if (aggOnList.size() > 1) {
                levelNames = CubeUtil.splitLevelName((String)((String)aggOnList.get(1)));
                cch = ChartReportItemHelper.instance().findDimensionBinding(this.exprCodec, levelNames[0], levelNames[1], bindingMap.values(), (ReportItemHandle)this.itemHandle);
                if (cch != null) {
                    isUpdated = this.setOptionalYExpression(exprType, cch);
                }
            } else if (aggOnList.size() == 0) {
                CrosstabReportItemHandle xtabHandle = null;
                try {
                    if (this.checkState(8)) {
                        xtabHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)this.itemHandle.getContainer().getContainer()).getReportItem();
                    } else if (this.isSharedBinding()) {
                        ReportItemHandle rih = ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle);
                        if (rih != null && rih instanceof ExtendedItemHandle) {
                            xtabHandle = (CrosstabReportItemHandle)((ExtendedItemHandle)rih).getReportItem();
                        }
                    } else if (this.isInXTabNonAggrCell() && this.isInheritCube()) {
                        xtabHandle = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.itemHandle, (boolean)false).getCrosstab();
                    }
                }
                catch (ExtendedElementException e) {
                    WizardBase.displayException((Throwable)e);
                }
                catch (BirtException e) {
                    WizardBase.displayException((Throwable)e);
                }
                if (xtabHandle != null) {
                    isUpdated = this.updateExpressionForConsumingXTab(xtabHandle, exprType, bindingMap);
                }
            } else if (!this.isChartReportItemHandle(ChartItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle))) {
                for (SeriesDefinition sd : ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.context.getModel())) {
                    sd.getQuery().setDefinition("");
                    isUpdated = true;
                }
            }
            ChartAdapter.endIgnoreNotifications();
        } else if ("category".equals(type) && value instanceof String) {
            EList baseSDs = ChartUtil.getBaseSeriesDefinitions((Chart)this.context.getModel());
            for (SeriesDefinition sd : baseSDs) {
                EList dds = sd.getDesignTimeSeries().getDataDefinition();
                Query q = (Query)dds.get(0);
                if (q.getDefinition() != null && !"".equals(q.getDefinition().trim())) continue;
                q.setDefinition((String)value);
            }
        } else if ("optional".equals(type) && value instanceof String) {
            List orthSDs = ChartUtil.getAllOrthogonalSeriesDefinitions((Chart)this.context.getModel());
            for (SeriesDefinition sd : orthSDs) {
                Query q = sd.getQuery();
                if (q == null) {
                    sd.setQuery(QueryImpl.create((String)((String)value)));
                    continue;
                }
                if (q.getDefinition() != null && !"".equals(q.getDefinition().trim())) continue;
                q.setDefinition((String)value);
            }
        } else if ("UpdateCubeBindings".equals(type)) {
            isUpdated = this.updateCubeBindings();
        }
        return isUpdated;
    }

    private boolean updateExpressionForConsumingXTab(CrosstabReportItemHandle xtabHandle, String exprType, Map<String, ComputedColumnHandle> bindingMap) {
        boolean isUpdated = false;
        ArrayList<ComputedColumnHandle> rowChildren = new ArrayList<ComputedColumnHandle>();
        int i = 0;
        while (i < xtabHandle.getDimensionCount(0)) {
            DimensionViewHandle dimensionHandle = xtabHandle.getDimension(0, i);
            ComputedColumnHandle cch = ChartReportItemHelper.instance().findDimensionBinding(this.exprCodec, dimensionHandle.getCubeDimensionName(), dimensionHandle.getLevel(dimensionHandle.getLevelCount() - 1).getCubeLevel().getName(), bindingMap.values(), (ReportItemHandle)this.itemHandle);
            rowChildren.add(cch);
            ++i;
        }
        if (rowChildren.size() > 0) {
            boolean needUpdate;
            Query query = (Query)((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel()).get(0)).getDesignTimeSeries().getDataDefinition().get(0);
            String expr = query.getDefinition();
            boolean bl = needUpdate = !this.isExistentBinding(expr, bindingMap, exprType);
            if (needUpdate) {
                this.setCategoryExpression(exprType, (ComputedColumnHandle)rowChildren.get(0));
            }
        }
        ArrayList<ComputedColumnHandle> colChildren = new ArrayList<ComputedColumnHandle>();
        int i2 = 0;
        while (i2 < xtabHandle.getDimensionCount(1)) {
            DimensionViewHandle dimensionHandle = xtabHandle.getDimension(1, i2);
            ComputedColumnHandle cch = ChartReportItemHelper.instance().findDimensionBinding(this.exprCodec, dimensionHandle.getCubeDimensionName(), dimensionHandle.getLevel(dimensionHandle.getLevelCount() - 1).getCubeLevel().getName(), bindingMap.values(), (ReportItemHandle)this.itemHandle);
            colChildren.add(cch);
            ++i2;
        }
        if (colChildren.size() > 0) {
            String expr;
            if (rowChildren.size() == 0) {
                boolean needUpdate;
                Query query = (Query)((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel()).get(0)).getDesignTimeSeries().getDataDefinition().get(0);
                expr = query.getDefinition();
                boolean bl = needUpdate = !this.isExistentBinding(expr, bindingMap, exprType);
                if (needUpdate) {
                    this.setCategoryExpression(exprType, (ComputedColumnHandle)colChildren.get(0));
                }
            } else {
                boolean needUpdate;
                Query query = ((SeriesDefinition)ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.context.getModel()).get(0)).getQuery();
                expr = query.getDefinition();
                boolean bl = needUpdate = !this.isExistentBinding(expr, bindingMap, exprType);
                if (needUpdate) {
                    isUpdated = this.setOptionalYExpression(exprType, (ComputedColumnHandle)colChildren.get(0));
                }
            }
        }
        return isUpdated;
    }

    private boolean isExistentBinding(String expr, Map<String, ComputedColumnHandle> bindingMap, String exprType) {
        if (expr == null || "".equals(expr)) {
            return false;
        }
        boolean isExistent = false;
        for (ComputedColumnHandle cch : bindingMap.values()) {
            this.exprCodec.setBindingName(cch.getName(), true, exprType);
            if (expr.indexOf(this.exprCodec.encode()) < 0) continue;
            isExistent = true;
            break;
        }
        return isExistent;
    }

    private boolean setOptionalYExpression(String exprType, ComputedColumnHandle cch) {
        boolean isUpdated = false;
        Iterator iter = ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.context.getModel()).iterator();
        while (iter.hasNext()) {
            this.exprCodec.setBindingName(cch.getName(), true, exprType);
            Query query = ((SeriesDefinition)iter.next()).getQuery();
            query.setDefinition(this.exprCodec.encode());
            isUpdated = true;
        }
        return isUpdated;
    }

    private void setCategoryExpression(String exprType, ComputedColumnHandle cch) {
        Query query = (Query)((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.context.getModel()).get(0)).getDesignTimeSeries().getDataDefinition().get(0);
        this.exprCodec.setBindingName(cch.getName(), true, exprType);
        query.setDefinition(this.exprCodec.encode());
        if (this.context.getModel() instanceof ChartWithAxes) {
            Axis xAxis = ChartUIUtil.getAxisXForProcessing((ChartWithAxes)((ChartWithAxes)this.context.getModel()));
            xAxis.setType(ChartItemUtil.convertToAxisType((String)cch.getDataType()));
        }
    }

    protected boolean updateCubeBindings() {
        boolean updated = false;
        try {
            List<ComputedColumn> columnList;
            CubeHandle cubeHandle = this.itemHandle.getCube();
            if (cubeHandle != null && (columnList = ChartXTabUIUtil.generateComputedColumns(this.itemHandle, cubeHandle)).size() > 0) {
                ArrayList<String> bindingNameList = new ArrayList<String>();
                Iterator<ComputedColumn> iter = this.itemHandle.columnBindingsIterator();
                while (iter.hasNext()) {
                    ComputedColumnHandle cch = (ComputedColumnHandle)iter.next();
                    bindingNameList.add(cch.getName());
                }
                for (ComputedColumn cc : columnList) {
                    if (bindingNameList.contains(cc.getName())) continue;
                    DEUtil.addColumn((DesignElementHandle)this.itemHandle, (ComputedColumn)cc, (boolean)false);
                    updated = true;
                }
            }
        }
        catch (SemanticException e) {
            ChartWizard.showException((String)"ReportDataServiceProvider.setDataCube", (String)e.getLocalizedMessage());
        }
        return updated;
    }

    boolean hasMultiCubeDimensions() {
        CubeHandle cube = this.getBindingCubeHandle();
        return ChartCubeUtil.getDimensionCount((CubeHandle)cube) > 1;
    }

    boolean isInXTabAggrCell() {
        try {
            AggregationCellHandle cell = ChartCubeUtil.getXtabContainerCell((DesignElementHandle)this.itemHandle);
            if (cell != null) {
                return ChartCubeUtil.isAggregationCell((AggregationCellHandle)cell);
            }
        }
        catch (BirtException birtException) {}
        return false;
    }

    boolean isInheritColumnsSet() {
        PropertyHandle property = this.itemHandle.getPropertyHandle("inheritColumns");
        return property != null && property.isSet();
    }

    boolean isInheritColumnsOnly() {
        return this.itemHandle.getDataSet() == null && ChartReportItemUtil.isContainerInheritable((ReportItemHandle)this.itemHandle) && this.context.isInheritColumnsOnly();
    }

    boolean isInheritColumnsGroups() {
        return this.itemHandle.getDataSet() == null && ChartReportItemUtil.isContainerInheritable((ReportItemHandle)this.itemHandle) && !ChartReportItemUtil.isContainerGridHandle((ReportItemHandle)this.itemHandle) && !this.context.isInheritColumnsOnly();
    }

    public int getState() {
        int states = 0;
        if (this.getDataSet() != null) {
            states |= 1;
        }
        if (this.getDataCube() != null) {
            states |= 2;
        }
        if (this.getInheritedDataSet() != null) {
            states |= 0x1000;
        }
        if (this.getInheritedCube() != null) {
            states |= 0x2000;
        }
        if (this.itemHandle.getDataBindingReference() != null) {
            states |= 4;
        }
        if (this.isInMultiView()) {
            states |= 8;
        }
        if (this.isSharedBinding()) {
            states |= 0x10;
            if (this.isSharingChart(false)) {
                states |= 0x800;
            }
            if (this.isSharingChart(true)) {
                states |= 0x4000;
            }
            if (this.getBindingCubeHandle() != null) {
                states |= 0x100;
            } else if (!this.isSharingChart(false)) {
                states |= 0x80;
            }
        }
        if (this.isPartChart()) {
            states |= 0x20;
        }
        if (this.hasMultiCubeDimensions()) {
            states |= 0x40;
        }
        if (this.isInheritColumnsOnly()) {
            states |= 0x200;
        }
        if (this.isInheritColumnsGroups()) {
            states |= 0x400;
        }
        if (this.isKeepCubeHierarchyAndNotCubeTopLevelOnCategory()) {
            states |= 0x8000;
        }
        if (this.isKeepCubeHierarchyAndNotCubeTopLevelOnSeries()) {
            states |= 0x10000;
        }
        return states;
    }

    public boolean checkState(int state) {
        return (this.getState() & state) == state;
    }

    public Object checkData(String checkType, Object data) {
        if (("optional".equals(checkType) || "category".equals(checkType)) && (this.checkState(8192) || this.checkState(2) || this.checkState(256))) {
            return ChartXTabUIUtil.checkQueryExpression(checkType, data, this.context.getModel(), this.itemHandle, this);
        }
        return null;
    }

    private ListingHandle findListingInheritance() {
        DesignElementHandle container = this.itemHandle.getContainer();
        while (container != null) {
            if (container instanceof ListingHandle && ((ListingHandle)container).getDataSet() != null) {
                return (ListingHandle)container;
            }
            container = container.getContainer();
        }
        return null;
    }

    int getNumberOfSameDataDefinition(String expr) {
        String s;
        String[] expres;
        if (expr == null) {
            return 0;
        }
        int count = 0;
        Chart chart = this.context.getModel();
        String[] stringArray = expres = ChartUtil.getCategoryExpressions((Chart)chart);
        int n = expres.length;
        int n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (expr.equals(s)) {
                ++count;
            }
            ++n2;
        }
        stringArray = expres = ChartUtil.getValueSeriesExpressions((Chart)chart);
        n = expres.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (expr.equals(s)) {
                ++count;
            }
            ++n2;
        }
        stringArray = expres = ChartUtil.getYOptoinalExpressions((Chart)chart);
        n = expres.length;
        n2 = 0;
        while (n2 < n) {
            s = stringArray[n2];
            if (expr.equals(s)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    boolean isSharingChart(boolean isRecursive) {
        boolean isShare = this.isSharedBinding();
        if (isRecursive) {
            return isShare && this.isChartReportItemHandle(ChartReportItemUtil.getReportItemReference((ReportItemHandle)this.itemHandle));
        }
        return isShare && this.isChartReportItemHandle(this.itemHandle.getDataBindingReference());
    }

    public boolean isChartReportItemHandle(ReportItemHandle referredHandle) {
        return ChartReportItemUtil.isChartReportItemHandle((ReportItemHandle)referredHandle);
    }

    public ExtendedItemHandle getChartReferenceItemHandle() {
        return ChartReportItemUtil.getChartReferenceItemHandle((ReportItemHandle)this.itemHandle);
    }

    protected void copySeriesDefinition(Object target) {
        ExtendedItemHandle refHandle;
        Chart targetCM = this.context.getModel();
        if (target != null && target instanceof Chart) {
            targetCM = (Chart)target;
        }
        if ((refHandle = this.getChartReferenceItemHandle()) != null) {
            Chart srcChart = ChartReportItemUtil.getChartFromHandle((ExtendedItemHandle)refHandle);
            ChartReportItemUtil.copyChartSeriesDefinition((Chart)srcChart, (Chart)targetCM);
            ChartReportItemUtil.copyChartSampleData((Chart)srcChart, (Chart)targetCM);
        }
    }

    public String[] getSeriesExpressionsFrom(Object obj, String type) {
        if (!(obj instanceof Chart)) {
            return new String[0];
        }
        if ("category".equals(type)) {
            return ChartUtil.getCategoryExpressions((Chart)((Chart)obj));
        }
        if ("optional".equals(type)) {
            return ChartUtil.getYOptoinalExpressions((Chart)((Chart)obj));
        }
        if ("value".equals(type)) {
            return ChartUtil.getValueSeriesExpressions((Chart)((Chart)obj));
        }
        return new String[0];
    }

    protected boolean isKeepCubeHierarchyAndNotCubeTopLevelOnCategory() {
        return ChartReportItemUtil.isKeepCubeHierarchyAndNotCubeTopLevelOnCategory((Chart)this.context.getModel(), (CubeHandle)this.getBindingCubeHandle(), (ReportItemHandle)this.itemHandle);
    }

    protected boolean isKeepCubeHierarchyAndNotCubeTopLevelOnSeries() {
        return ChartReportItemUtil.isKeepCubeHierarchyAndNotCubeTopLevelOnSeries((Chart)this.context.getModel(), (CubeHandle)this.getBindingCubeHandle(), (ReportItemHandle)this.itemHandle);
    }

    public CubeHandle getBindingCubeHandle() {
        return ChartReportItemHelper.instance().getBindingCubeHandle((ReportItemHandle)this.itemHandle);
    }

    public DataSetHandle getBindingDataSetHandle() {
        return ChartReportItemHelper.instance().getBindingDataSetHandle((ReportItemHandle)this.itemHandle);
    }

    class BaseQueryHelper
    extends AbstractChartBaseQueryGenerator {
        public BaseQueryHelper(ExtendedItemHandle handle, Chart chart) {
            super((ReportItemHandle)handle, chart, false, ReportDataServiceProvider.this.session.getModelAdaptor());
        }

        public IDataQueryDefinition createBaseQuery(List<String> columnExpression) throws ChartException {
            QueryDefinition queryDefn = new QueryDefinition();
            int maxRow = ReportDataServiceProvider.this.getMaxRow();
            queryDefn.setMaxRows(maxRow);
            DataSetHandle dsHandle = ReportDataServiceProvider.this.getDataSetFromHandle();
            queryDefn.setDataSetName(dsHandle == null ? null : dsHandle.getQualifiedName());
            int i = 0;
            while (i < columnExpression.size()) {
                String expr = columnExpression.get(i);
                this.exprCodec.decode(expr);
                String name = this.exprCodec.getExpression();
                if (!this.fNameSet.contains(name)) {
                    Binding colBinding = new Binding(name);
                    colBinding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression((ChartExpressionUtil.ExpressionCodec)this.exprCodec, (IModelAdapter)this.modelAdapter, (boolean)false));
                    try {
                        queryDefn.addBinding((IBinding)colBinding);
                    }
                    catch (DataException e) {
                        throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                    }
                    this.fNameSet.add(name);
                }
                ++i;
            }
            this.generateExtraBindings((BaseQueryDefinition)queryDefn);
            return queryDefn;
        }

        protected void addValueSeriesAggregateBindingForGrouping(BaseQueryDefinition query, EList<SeriesDefinition> seriesDefinitions, GroupDefinition innerMostGroupDef, Map<String, String[]> valueExprMap, SeriesDefinition baseSD) throws ChartException {
            for (SeriesDefinition orthSD : seriesDefinitions) {
                Series series = orthSD.getDesignTimeSeries();
                List qlist = ChartEngine.instance().getDataSetProcessor(series.getClass()).getDataDefinitionsForGrouping(series);
                for (Query qry : series.getDataDefinition()) {
                    String aggName;
                    String expr = qry.getDefinition();
                    if (expr == null || "".equals(expr) || (aggName = ChartUtil.getAggregateFuncExpr((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)qry)) == null || "".equals(aggName)) continue;
                    String name = ChartUtil.generateBindingNameOfValueSeries((Query)qry, (SeriesDefinition)orthSD, (SeriesDefinition)baseSD);
                    if (this.fNameSet.contains(name)) {
                        query.getBindings().remove(name);
                    }
                    this.fNameSet.add(name);
                    Binding colBinding = new Binding(name);
                    colBinding.setDataType(0);
                    if (qlist.contains(qry)) {
                        try {
                            this.setBindingExpressionDueToAggregation(colBinding, expr, aggName);
                        }
                        catch (DataException e1) {
                            throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e1);
                        }
                        if (innerMostGroupDef != null) {
                            try {
                                colBinding.addAggregateOn(innerMostGroupDef.getName());
                            }
                            catch (DataException e) {
                                throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                            }
                        }
                        colBinding.setAggrFunction(ChartReportItemUtil.convertToDtEAggFunction((String)aggName));
                        IAggregateFunction aFunc = PluginSettings.instance().getAggregateFunction(aggName);
                        if (aFunc.getParametersCount() > 0) {
                            String[] parameters = ChartUtil.getAggFunParameters((SeriesDefinition)orthSD, (SeriesDefinition)baseSD, (Query)qry);
                            int i = 0;
                            while (i < parameters.length && i < aFunc.getParametersCount()) {
                                String param = parameters[i];
                                colBinding.addArgument((IBaseExpression)new ScriptExpression(param));
                                ++i;
                            }
                        }
                    } else {
                        this.exprCodec.decode(expr);
                        colBinding.setExpression((IBaseExpression)ChartReportItemUtil.adaptExpression((ChartExpressionUtil.ExpressionCodec)this.exprCodec, (IModelAdapter)this.modelAdapter, (boolean)false));
                    }
                    String newExpr = this.getExpressionForEvaluator(name);
                    try {
                        query.addBinding((IBinding)colBinding);
                    }
                    catch (DataException e) {
                        throw new ChartException("org.eclipse.birt.chart.reportitem", 19, (Throwable)e);
                    }
                    valueExprMap.put(expr, new String[]{expr, newExpr});
                }
            }
        }

        public IDataQueryDefinition createBaseQuery(IDataQueryDefinition parent) {
            throw new UnsupportedOperationException("Don't be implemented in the class.");
        }
    }

    protected static class ChartDummyEngineTask
    extends DummyEngineTask {
        public ChartDummyEngineTask(ReportEngine engine, IReportRunnable runnable, ModuleHandle moduleHandle) {
            super(engine, runnable, moduleHandle);
        }

        public void run() throws EngineException {
            this.parameterChanged = true;
            this.usingParameterValues();
            this.initReportVariable();
            this.loadDesign();
        }
    }

    static class ColumnNameComprator
    implements Comparator<ColumnBindingInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;

        ColumnNameComprator() {
        }

        @Override
        public int compare(ColumnBindingInfo src, ColumnBindingInfo target) {
            return src.getName().compareTo(target.getName());
        }
    }

    class ShareBindingQueryHelper {
        protected final ChartExpressionUtil.ExpressionCodec sbqhExprCodec = ChartModelHelper.instance().createExpressionCodec();

        ShareBindingQueryHelper() {
        }

        private void setPredefinedExpressions(ColumnBindingInfo[] headers) {
            Object[] expressionsArray = this.getPredefinedExpressionsForSharing(headers);
            ReportDataServiceProvider.this.context.addPredefinedQuery("category", (Object[])expressionsArray[0]);
            ReportDataServiceProvider.this.context.addPredefinedQuery("optional", (Object[])expressionsArray[1]);
            ReportDataServiceProvider.this.context.addPredefinedQuery("value", (Object[])expressionsArray[2]);
        }

        /*
         * WARNING - void declaration
         */
        private Object[] getPredefinedExpressionsForSharing(ColumnBindingInfo[] headers) {
            LinkedList<ColumnBindingInfo> commons = new LinkedList<ColumnBindingInfo>();
            LinkedList<ColumnBindingInfo> aggs = new LinkedList<ColumnBindingInfo>();
            LinkedList<ColumnBindingInfo> groups = new LinkedList<ColumnBindingInfo>();
            int i = 0;
            while (i < headers.length) {
                int type = headers[i].getColumnType();
                switch (type) {
                    case 0: {
                        commons.add(headers[i]);
                        break;
                    }
                    case 2: {
                        aggs.add(headers[i]);
                        break;
                    }
                    case 1: {
                        groups.add(headers[i]);
                    }
                }
                ++i;
            }
            LinkedList<ColumnBindingInfo> groupsWithAgg = new LinkedList<ColumnBindingInfo>();
            LinkedList groupsWithoutAgg = new LinkedList(groups);
            Iterator iter = groupsWithoutAgg.iterator();
            block6: while (iter.hasNext()) {
                ColumnBindingInfo cbiGroup = (ColumnBindingInfo)iter.next();
                String groupName = cbiGroup.getName();
                for (ColumnBindingInfo columnBindingInfo : aggs) {
                    if (!groupName.equals(((ComputedColumnHandle)columnBindingInfo.getObjectHandle()).getAggregateOn())) continue;
                    iter.remove();
                    groupsWithAgg.add(cbiGroup);
                    continue block6;
                }
            }
            ColumnBindingInfo[] categorys = new ColumnBindingInfo[groups.size() + commons.size()];
            int index = 0;
            for (ColumnBindingInfo cbi : groups) {
                categorys[index++] = cbi;
            }
            for (ColumnBindingInfo cbi : commons) {
                categorys[index++] = cbi;
            }
            ColumnBindingInfo[] optionals = null;
            if (ReportDataServiceProvider.this.isInheritColumnsGroups() && groups.size() > 0) {
                void var10_18;
                LinkedList<ColumnBindingInfo> linkedList = new LinkedList<ColumnBindingInfo>();
                ExtendedItemHandle reh = ReportDataServiceProvider.this.itemHandle;
                block10: while (reh != null) {
                    if (reh.getContainer() instanceof GroupHandle) {
                        reh = reh.getContainer();
                        for (ColumnBindingInfo cbi : groups) {
                            linkedList.add(cbi);
                            if (reh.getName().equals(cbi.getName())) break block10;
                        }
                        break;
                    }
                    if (reh.getContainer() instanceof RowHandle && reh.getContainer() != null && !(reh.getContainer().getContainer() instanceof GroupHandle)) {
                        ExtendedItemHandle deh = reh;
                        while (deh != null) {
                            if (deh.getContainer() instanceof ListingHandle) {
                                deh = deh.getContainer();
                                break;
                            }
                            deh = deh.getContainer();
                        }
                        if (deh == null || !(deh instanceof ListingHandle)) break;
                        if (((ListingHandle)deh).getDetail().findPosn(reh.getContainer()) >= 0) {
                            LinkedList<ColumnBindingInfo> linkedList2 = groups;
                            break;
                        }
                        if (((ListingHandle)deh).getHeader().findPosn(reh.getContainer()) >= 0) {
                            linkedList.add((ColumnBindingInfo)groups.get(0));
                            break;
                        }
                        if (((ListingHandle)deh).getFooter().findPosn(reh.getContainer()) < 0) break;
                        linkedList.add((ColumnBindingInfo)groups.get(0));
                        break;
                    }
                    if (reh.getContainer() instanceof ListingHandle) {
                        reh = null;
                        break;
                    }
                    reh = reh.getContainer();
                }
                optionals = new ColumnBindingInfo[var10_18.size()];
                int i2 = 0;
                for (ColumnBindingInfo cbi : var10_18) {
                    optionals[i2++] = cbi;
                }
            } else {
                int n = groups.size() > 0 ? 1 : 0;
                optionals = new ColumnBindingInfo[n];
                if (groups.size() > 0) {
                    optionals[0] = (ColumnBindingInfo)groups.get(0);
                }
            }
            ColumnBindingInfo[] columnBindingInfoArray = new ColumnBindingInfo[aggs.size() + commons.size()];
            index = 0;
            for (ColumnBindingInfo cbi : aggs) {
                columnBindingInfoArray[index++] = cbi;
            }
            for (ColumnBindingInfo cbi : commons) {
                columnBindingInfoArray[index++] = cbi;
            }
            return new Object[]{categorys, optionals, columnBindingInfoArray};
        }

        private IDataRowExpressionEvaluator createShareBindingEvaluator(Chart cm, List<String> columnExpression) throws BirtException, AdapterException, DataException, ChartException {
            IQueryResults actualResultSet;
            QueryDefinition queryDefn = new QueryDefinition();
            int maxRow = ReportDataServiceProvider.this.getMaxRow();
            queryDefn.setMaxRows(maxRow);
            final HashMap<String, String> bindingExprsMap = new HashMap<String, String>();
            Iterator iterator = ChartReportItemUtil.getColumnDataBindings((ReportItemHandle)ReportDataServiceProvider.this.itemHandle);
            ArrayList<ComputedColumnHandle> columnList = new ArrayList<ComputedColumnHandle>();
            while (iterator.hasNext()) {
                columnList.add((ComputedColumnHandle)iterator.next());
            }
            this.generateShareBindingsWithTable(this.getPreviewHeadersInfo(columnList), queryDefn, ReportDataServiceProvider.this.session, bindingExprsMap);
            this.addCustomExpressions(queryDefn, cm, columnExpression, bindingExprsMap);
            Iterator filtersIterator = ReportDataServiceProvider.this.getPropertyIterator(ReportDataServiceProvider.this.itemHandle.getPropertyHandle("filter"));
            if (filtersIterator != null) {
                while (filtersIterator.hasNext()) {
                    FilterDefinition filter = ReportDataServiceProvider.this.session.getModelAdaptor().adaptFilter((FilterConditionHandle)filtersIterator.next());
                    queryDefn.addFilter((IFilterDefinition)filter);
                }
            }
            if ((actualResultSet = this.executeSharedQuery(queryDefn)) != null) {
                return new BaseGroupedQueryResultSetEvaluator(actualResultSet.getResultIterator(), ChartReportItemUtil.isSetSummaryAggregation((Chart)cm), cm, ReportDataServiceProvider.this.itemHandle){

                    public Object evaluate(String expression) {
                        try {
                            String newExpr = (String)bindingExprsMap.get(expression);
                            if (newExpr != null) {
                                return this.fResultIterator.getValue(newExpr);
                            }
                            return this.fResultIterator.getValue(expression);
                        }
                        catch (BirtException e) {
                            sLogger.log((Exception)((Object)e));
                            return null;
                        }
                    }
                };
            }
            return null;
        }

        private IQueryResults executeSharedQuery(QueryDefinition queryDefn) throws AdapterException, BirtException {
            DataSetHandle dataSetHandle = ReportDataServiceProvider.this.getBindingDataSetHandle();
            if (ReportDataServiceProvider.this.needDefineDataSet(dataSetHandle)) {
                DataService.getInstance().registerSession(dataSetHandle, ReportDataServiceProvider.this.session);
                ReportDataServiceProvider.this.dteAdapter.defineDataSet(dataSetHandle, ReportDataServiceProvider.this.session, true, false);
            }
            ReportDataServiceProvider.this.setRowLimit(ReportDataServiceProvider.this.session, ReportDataServiceProvider.this.getMaxRow(), false);
            IQueryResults actualResultSet = ReportDataServiceProvider.this.dteAdapter.executeQuery(ReportDataServiceProvider.this.session, (IQueryDefinition)queryDefn);
            return actualResultSet;
        }

        private void addCustomExpressions(QueryDefinition queryDefn, Chart cm, List<String> columnExpression, Map<String, String> bindingExprsMap) throws DataException {
            List queryList = ChartBaseQueryHelper.getAllQueryExpressionDefinitions((Chart)cm);
            HashSet<String> exprSet = new HashSet<String>();
            for (Query query : queryList) {
                String expr = query.getDefinition();
                if (expr == null) continue;
                exprSet.add(expr);
            }
            exprSet.addAll(columnExpression);
            for (String expr : exprSet) {
                if (expr.length() <= 0 || bindingExprsMap.containsKey(expr)) continue;
                this.sbqhExprCodec.decode(expr);
                String name = StructureFactory.newComputedColumn((DesignElementHandle)ReportDataServiceProvider.this.itemHandle, (String)ChartUtil.escapeSpecialCharacters((String)this.sbqhExprCodec.getExpression())).getName();
                queryDefn.addBinding((IBinding)new Binding(name, (IBaseExpression)ChartReportItemUtil.adaptExpression((ChartExpressionUtil.ExpressionCodec)this.sbqhExprCodec, (IModelAdapter)ReportDataServiceProvider.this.session.getModelAdaptor(), (boolean)false)));
                bindingExprsMap.put(expr, name);
            }
        }

        private final ColumnBindingInfo[] getPreviewHeadersInfo(List<ComputedColumnHandle> columnList) throws ChartException {
            if (columnList == null || columnList.size() == 0) {
                return new ColumnBindingInfo[0];
            }
            ColumnBindingInfo[] columnHeaders = null;
            List<GroupHandle> groupList = this.getGroupsOfSharedBinding();
            columnHeaders = new ColumnBindingInfo[columnList.size() + groupList.size()];
            int index = 0;
            int i = 0;
            while (i < groupList.size()) {
                GroupHandle gh = groupList.get(i);
                String groupName = gh.getName();
                Expression expr = (Expression)gh.getExpressionProperty("keyExpr").getValue();
                ReportDataServiceProvider.this.exprCodec.setExpression(expr.getStringExpression());
                ReportDataServiceProvider.this.exprCodec.setType(expr.getType());
                String groupKeyExpr = ReportDataServiceProvider.this.exprCodec.encode();
                String tooltip = String.valueOf(Messages.getString("ReportDataServiceProvider.Tooltip.GroupExpression")) + ReportDataServiceProvider.this.exprCodec.getExpression();
                columnHeaders[index++] = new ColumnBindingInfo(groupName, groupKeyExpr, 1, "icons/obj16/group.gif", tooltip, (Object)gh);
                Iterator<ComputedColumnHandle> iter = columnList.iterator();
                while (iter.hasNext()) {
                    ComputedColumnHandle cch = iter.next();
                    String aggOn = cch.getAggregateOn();
                    if (!groupName.equals(aggOn)) continue;
                    iter.remove();
                    tooltip = String.valueOf(Messages.getString("ReportDataServiceProvider.Tooltip.Aggregate")) + cch.getAggregateFunction() + "\n" + Messages.getString("ReportDataServiceProvider.Tooltip.OnGroup") + groupName;
                    columnHeaders[index] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), 2, "icons/obj16/sigma.gif", tooltip, (Object)cch);
                    columnHeaders[index].setChartAggExpression(ChartReportItemUtil.convertToChartAggExpression((String)cch.getAggregateFunction()));
                    ++index;
                }
                ++i;
            }
            Iterator<ComputedColumnHandle> iter = columnList.iterator();
            while (iter.hasNext()) {
                ComputedColumnHandle cch = iter.next();
                if (cch.getAggregateFunction() == null) continue;
                iter.remove();
                String tooltip = String.valueOf(Messages.getString("ReportDataServiceProvider.Tooltip.Aggregate")) + cch.getAggregateFunction() + "\n" + Messages.getString("ReportDataServiceProvider.Tooltip.OnGroup");
                columnHeaders[index] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), 2, "icons/obj16/sigma.gif", tooltip, (Object)cch);
                columnHeaders[index].setChartAggExpression(ChartReportItemUtil.convertToChartAggExpression((String)cch.getAggregateFunction()));
                ++index;
            }
            for (ComputedColumnHandle cch : columnList) {
                columnHeaders[index++] = new ColumnBindingInfo(cch.getName(), ExpressionUtil.createJSRowExpression((String)cch.getName()), 0, null, null, (Object)cch);
            }
            return columnHeaders;
        }

        private List<GroupHandle> getGroupsOfSharedBinding() {
            ArrayList<GroupHandle> groupList = new ArrayList<GroupHandle>();
            ListingHandle table = null;
            if (ReportDataServiceProvider.this.isInheritColumnsGroups()) {
                table = ReportDataServiceProvider.this.findListingInheritance();
            } else {
                ReportItemHandle handle = ReportDataServiceProvider.this.getReportItemHandle();
                table = this.getSharedListingHandle(handle);
            }
            if (table != null) {
                SlotHandle groups = table.getGroups();
                Iterator iter = groups.iterator();
                while (iter.hasNext()) {
                    groupList.add((GroupHandle)iter.next());
                }
            }
            return groupList;
        }

        private ListingHandle getSharedListingHandle(ReportItemHandle aItemHandle) {
            if (aItemHandle instanceof ListingHandle) {
                return (ListingHandle)aItemHandle;
            }
            ReportItemHandle handle = aItemHandle.getDataBindingReference();
            if (handle != null) {
                return this.getSharedListingHandle(handle);
            }
            if (aItemHandle.getContainer() instanceof MultiViewsHandle) {
                return this.getSharedListingHandle((ReportItemHandle)aItemHandle.getContainer().getContainer());
            }
            return null;
        }

        private List<Object[]> getPreviewRowData(ColumnBindingInfo[] headers, int rowCount, boolean isStringType) throws ChartException {
            ArrayList<Object[]> dataList = new ArrayList<Object[]>();
            ClassLoader oldContextLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader parentLoader = oldContextLoader;
            if (parentLoader == null) {
                parentLoader = this.getClass().getClassLoader();
            }
            ClassLoader newContextLoader = DataSetProvider.getCustomScriptClassLoader((ClassLoader)parentLoader, (ModuleHandle)ReportDataServiceProvider.this.itemHandle.getModuleHandle());
            Thread.currentThread().setContextClassLoader(newContextLoader);
            try {
                try {
                    IQueryResults actualResultSet;
                    QueryDefinition queryDefn = new QueryDefinition();
                    queryDefn.setMaxRows(ReportDataServiceProvider.this.getMaxRow());
                    List<String> columns = this.generateShareBindingsWithTable(headers, queryDefn, ReportDataServiceProvider.this.session, new HashMap<String, String>());
                    Iterator filtersIterator = ReportDataServiceProvider.this.getPropertyIterator(ReportDataServiceProvider.this.itemHandle.getPropertyHandle("filter"));
                    if (filtersIterator != null) {
                        while (filtersIterator.hasNext()) {
                            FilterDefinition filter = ReportDataServiceProvider.this.session.getModelAdaptor().adaptFilter((FilterConditionHandle)filtersIterator.next());
                            queryDefn.addFilter((IFilterDefinition)filter);
                        }
                    }
                    if ((actualResultSet = this.executeSharedQuery(queryDefn)) != null) {
                        int columnCount = columns.size();
                        IResultIterator iter = actualResultSet.getResultIterator();
                        while (iter.next()) {
                            int n;
                            Object[] record;
                            if (isStringType) {
                                record = new String[columnCount];
                                n = 0;
                                while (n < columnCount) {
                                    record[n] = ReportDataServiceProvider.this.valueAsString(iter.getValue(columns.get(n)));
                                    ++n;
                                }
                                dataList.add(record);
                                continue;
                            }
                            record = new Object[columnCount];
                            n = 0;
                            while (n < columnCount) {
                                record[n] = iter.getValue(columns.get(n));
                                ++n;
                            }
                            dataList.add(record);
                        }
                        actualResultSet.close();
                    }
                }
                catch (BirtException e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 19, (Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextLoader);
            }
            return dataList;
        }

        private List<String> generateShareBindingsWithTable(ColumnBindingInfo[] headers, QueryDefinition queryDefn, DataRequestSession aSession, Map<String, String> bindingExprsMap) throws AdapterException, DataException {
            ArrayList<String> columns = new ArrayList<String>();
            ReportItemHandle reportItemHandle = ReportDataServiceProvider.this.getReportItemHandle();
            if (ReportDataServiceProvider.this.isInheritColumnsGroups()) {
                reportItemHandle = ReportDataServiceProvider.this.findListingInheritance();
            }
            queryDefn.setDataSetName(reportItemHandle.getDataSet().getQualifiedName());
            IModelAdapter modelAdapter = aSession.getModelAdaptor();
            int i = 0;
            while (i < headers.length) {
                ColumnBindingInfo chi = headers[i];
                int type = chi.getColumnType();
                switch (type) {
                    case 0: 
                    case 2: {
                        IBinding binding = modelAdapter.adaptBinding((ComputedColumnHandle)chi.getObjectHandle());
                        queryDefn.addBinding(binding);
                        columns.add(binding.getBindingName());
                        bindingExprsMap.put(chi.getExpression(), binding.getBindingName());
                        break;
                    }
                    case 1: {
                        GroupDefinition gd = modelAdapter.adaptGroup((GroupHandle)chi.getObjectHandle());
                        queryDefn.addGroup(gd);
                        String name = StructureFactory.newComputedColumn((DesignElementHandle)reportItemHandle, (String)gd.getName()).getName();
                        IBinding binding = new Binding(name);
                        binding.setExpression((IBaseExpression)modelAdapter.adaptExpression(ChartReportItemUtil.getExpression((GroupHandle)((GroupHandle)chi.getObjectHandle()))));
                        queryDefn.addBinding(binding);
                        columns.add(name);
                        bindingExprsMap.put(((ScriptExpression)binding.getExpression()).getText(), binding.getBindingName());
                    }
                }
                ++i;
            }
            if (reportItemHandle instanceof ListingHandle) {
                queryDefn.getSorts().addAll(ChartBaseQueryHelper.createSorts((Iterator)((ListingHandle)reportItemHandle).sortsIterator(), (IModelAdapter)modelAdapter));
            }
            return columns;
        }
    }
}

