/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class LessThanOrEqualFunction
extends Function {
    @Text(value="Cannot apply less than or equal operator to {0} and {1} types.")
    private static LocalizableText cannotApplyMessage;

    static {
        LocalizableText.init(LessThanOrEqualFunction.class);
    }

    public static LessThanOrEqualFunction create(Function a, Function b) {
        LessThanOrEqualFunction function = new LessThanOrEqualFunction();
        function.init(a, b);
        return function;
    }

    @Override
    public String name() {
        return "<=";
    }

    @Override
    public boolean operator() {
        return true;
    }

    @Override
    public int precedence() {
        return 5;
    }

    @Override
    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            @Override
            protected Object evaluate() {
                Object b;
                Object a = this.operand(0);
                if (a instanceof Value) {
                    a = ((Value)a).content();
                }
                if ((b = this.operand(1)) instanceof Value) {
                    b = ((Value)b).content();
                }
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                if (a instanceof BigDecimal || b instanceof BigDecimal) {
                    BigDecimal y;
                    BigDecimal x = this.cast(a, BigDecimal.class);
                    if (x.compareTo(y = this.cast(b, BigDecimal.class)) <= 0) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof Float || a instanceof Double || b instanceof Float || b instanceof Double) {
                    Double x = this.cast(a, Double.class);
                    Double y = this.cast(b, Double.class);
                    if (x <= y) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof BigInteger || b instanceof BigInteger) {
                    BigInteger y;
                    BigInteger x = this.cast(a, BigInteger.class);
                    if (x.compareTo(y = this.cast(b, BigInteger.class)) <= 0) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof Byte || a instanceof Short || a instanceof Character || a instanceof Integer || a instanceof Long || b instanceof Byte || b instanceof Short || b instanceof Character || b instanceof Integer || b instanceof Long) {
                    Long x = this.cast(a, Long.class);
                    Long y = this.cast(b, Long.class);
                    if (x <= y) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof String || b instanceof String) {
                    String y;
                    String x = this.cast(a, String.class);
                    if (x.compareTo(y = this.cast(b, String.class)) <= 0) {
                        return true;
                    }
                    return false;
                }
                if (a instanceof Comparable) {
                    if (((Comparable)a).compareTo(b) <= 0) {
                        return true;
                    }
                    return false;
                }
                if (b instanceof Comparable) {
                    if (((Comparable)b).compareTo(a) >= 0) {
                        return true;
                    }
                    return false;
                }
                throw new FunctionException(cannotApplyMessage.format(a.getClass().getName(), b.getClass().getName()));
            }
        };
    }
}

