/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.macbundler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.macbundler.BundleDescription;
import org.eclipse.jdt.internal.ui.macbundler.BundleWizardBasePage;
import org.eclipse.jdt.internal.ui.macbundler.MacBundleWizard;
import org.eclipse.jdt.internal.ui.macbundler.Util;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BundleWizardPage1
extends BundleWizardBasePage {
    static String[] JVMS = new String[]{"1.3+", "1.3*", "1.4.2", "1.4+", "1.4*", "1.5+", "1.5*", "1.6+", "1.6*"};
    ILaunchConfiguration[] fConfigurations = new ILaunchConfiguration[0];
    Combo fLocation;
    Combo fLaunchConfigs;
    Combo fJVMVersion;
    Text fAppName;
    Text fMainClass;
    Text fArguments;
    Text fIconFileName;
    Button fUseSWT;

    public BundleWizardPage1(BundleDescription bd) {
        super("page1", bd);
    }

    public void createContents(Composite c) {
        final Shell shell = c.getShell();
        Composite c1 = BundleWizardPage1.createComposite(c, 2);
        BundleWizardPage1.createLabel(c1, Util.getString("page1.launchConfig.label"), 4);
        this.fLaunchConfigs = new Combo(c1, 8);
        this.fillCombo(this.fLaunchConfigs);
        this.fLaunchConfigs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int ix = BundleWizardPage1.this.fLaunchConfigs.getSelectionIndex();
                if (ix > 0 && ix < BundleWizardPage1.this.fConfigurations.length) {
                    BundleWizardPage1.this.fBundleDescription.clear();
                    BundleWizardPage1.this.fBundleDescription.inititialize(BundleWizardPage1.this.fConfigurations[ix]);
                }
            }
        });
        Group c2 = BundleWizardPage1.createGroup(c, "Main", 2);
        BundleWizardPage1.createLabel((Composite)c2, Util.getString("page1.mainClass.label"), 4);
        Composite c7a = BundleWizardPage1.createHBox((Composite)c2);
        this.fMainClass = this.createText(c7a, "MainClass", 1);
        Button b1 = this.createButton(c7a, 0, Util.getString("page1.mainClass.chooseButton.label"));
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox mb = new MessageBox(shell, 34);
                mb.setMessage(Util.getString("page1.mainClass.dialog.message"));
                mb.setText(Util.getString("page1.mainClass.dialog.title"));
                mb.open();
            }
        });
        BundleWizardPage1.createLabel((Composite)c2, Util.getString("page1.arguments.label"), 2);
        this.fArguments = this.createText((Composite)c2, "Arguments", 2);
        Group c5 = BundleWizardPage1.createGroup(c, "Destination", 2);
        BundleWizardPage1.createLabel((Composite)c5, Util.getString("page1.appName.label"), 4);
        this.fAppName = this.createText((Composite)c5, "AppName", 1);
        BundleWizardPage1.createLabel((Composite)c5, Util.getString("page1.appFolder.label"), 4);
        Composite c3a = BundleWizardPage1.createHBox((Composite)c5);
        this.fLocation = this.createCombo(c3a, "DestinationDirectory");
        final Button browse = this.createButton(c3a, 0, Util.getString("page1.appFolder.browseButton.label"));
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(browse.getShell(), 8192);
                dd.setMessage(Util.getString("page1.appFolder.browseDialog.message"));
                dd.setText(Util.getString("page1.appFolder.browseDialog.title"));
                String name = dd.open();
                if (name != null) {
                    BundleWizardPage1.this.fLocation.setText(name);
                }
            }
        });
        Group g6 = BundleWizardPage1.createGroup(c, "Options", 2);
        BundleWizardPage1.createLabel((Composite)g6, Util.getString("page1.jvm.label"), 4);
        Composite c8 = BundleWizardPage1.createComposite((Composite)g6, 4);
        this.fJVMVersion = new Combo(c8, 8);
        int i = 0;
        while (i < JVMS.length) {
            this.fJVMVersion.add(JVMS[i]);
            ++i;
        }
        this.fJVMVersion.setText(JVMS[4]);
        this.hookField(this.fJVMVersion, "JVMVersion");
        BundleWizardPage1.createLabel(c8, "      ", 4);
        BundleWizardPage1.createLabel(c8, Util.getString("page1.useSWT.label"), 4);
        this.fUseSWT = this.createButton(c8, 32, null);
        this.hookButton(this.fUseSWT, "UsesSWT");
        BundleWizardPage1.createLabel((Composite)g6, Util.getString("page1.appIcon.label"), 4);
        Composite c7 = BundleWizardPage1.createComposite((Composite)g6, 2);
        this.fIconFileName = this.createText(c7, "IconFile", 1);
        final Button b = this.createButton(c7, 0, Util.getString("page1.appIcon.chooseButton.label"));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(b.getShell(), 4096);
                fd.setText(Util.getString("page1.appIcon.chooseDialog.title"));
                fd.setFilterExtensions(new String[]{"icns"});
                String name = fd.open();
                if (name != null) {
                    BundleWizardPage1.this.fIconFileName.setText(name);
                }
            }
        });
    }

    void enterPage() {
        super.enterPage();
        this.initCombo(this.fLaunchConfigs);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fAppName != null) {
            this.fAppName.setText(this.fBundleDescription.get("AppName", ""));
        }
        if (this.fMainClass != null) {
            this.fMainClass.setText(this.fBundleDescription.get("MainClass", ""));
        }
        if (this.fJVMVersion != null) {
            this.fJVMVersion.setText(this.fBundleDescription.get("JVMVersion", ""));
        }
        if (this.fUseSWT != null) {
            this.fUseSWT.setSelection(this.fBundleDescription.get("UsesSWT", false));
        }
    }

    public boolean isPageComplete() {
        return this.fAppName != null && this.fAppName.getText().length() > 0 && this.fLocation.getText().length() > 0;
    }

    private void collectLaunchConfigs() {
        ArrayList<ILaunchConfiguration> configs = new ArrayList<ILaunchConfiguration>();
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        try {
            ILaunchConfiguration[] configurations = manager.getLaunchConfigurations(type);
            int i = 0;
            while (i < configurations.length) {
                ILaunchConfiguration configuration = configurations[i];
                if (BundleDescription.verify(configuration)) {
                    configs.add(configuration);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        this.fConfigurations = configs.toArray(new ILaunchConfiguration[configs.size()]);
        Arrays.sort(this.fConfigurations, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                ILaunchConfiguration lc1 = (ILaunchConfiguration)o1;
                ILaunchConfiguration lc2 = (ILaunchConfiguration)o2;
                return lc1.getName().compareTo(lc2.getName());
            }

            @Override
            public boolean equals(Object obj) {
                return false;
            }
        });
    }

    private void fillCombo(Combo c) {
        this.collectLaunchConfigs();
        int i = 0;
        while (i < this.fConfigurations.length) {
            ILaunchConfiguration configuration = this.fConfigurations[i];
            c.add(configuration.getName());
            ++i;
        }
    }

    private void initCombo(Combo c) {
        IJavaProject project;
        IStructuredSelection sel = ((MacBundleWizard)this.getWizard()).getSelection();
        Object o = sel.getFirstElement();
        if (o instanceof IJavaElement && (project = ((IJavaElement)o).getJavaProject()) != null) {
            int i = 0;
            while (i < this.fConfigurations.length) {
                ILaunchConfiguration configuration = this.fConfigurations[i];
                if (BundleDescription.matches(configuration, project)) {
                    c.setText(configuration.getName());
                    this.fBundleDescription.inititialize(configuration);
                    return;
                }
                ++i;
            }
        }
    }
}

