/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.resref.core;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.common.resref.core.ResourceReferenceListListener;
import org.jboss.tools.common.resref.core.ResourceReferencePlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class ResourceReferenceList {
    private static final String CODING = "UTF-16";
    ResourceReferenceListListener[] listeners = new ResourceReferenceListListener[0];
    TreeMap allExternalResources = null;

    protected abstract QualifiedName getPropertyName();

    public void addChangeListener(ResourceReferenceListListener listener) {
        int i = this.getListenerIndex(listener);
        if (i >= 0) {
            return;
        }
        ResourceReferenceListListener[] ls = new ResourceReferenceListListener[this.listeners.length + 1];
        System.arraycopy(this.listeners, 0, ls, 0, this.listeners.length);
        ls[this.listeners.length] = listener;
        this.listeners = ls;
    }

    public void removeChangeListener(ResourceReferenceListListener listener) {
        int i = this.getListenerIndex(listener);
        if (i < 0) {
            return;
        }
        ResourceReferenceListListener[] ls = new ResourceReferenceListListener[this.listeners.length - 1];
        if (i > 0) {
            System.arraycopy(this.listeners, 0, ls, 0, i);
        }
        if (i < ls.length) {
            System.arraycopy(this.listeners, i + 1, ls, i, ls.length - i);
        }
        this.listeners = ls;
    }

    private int getListenerIndex(ResourceReferenceListListener listener) {
        int i = 0;
        while (i < this.listeners.length) {
            if (this.listeners[i] == listener) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public ResourceReference[] getAllResources(IFile file) {
        ResourceReference ref;
        int i;
        String[] dcss;
        HashSet<String> locations = new HashSet<String>();
        ArrayList<ResourceReference> css = new ArrayList<ResourceReference>();
        if (file.getProject() != null) {
            String[] dcss2 = this.getDeclaredResources((IResource)file.getProject());
            int i2 = 0;
            while (i2 < dcss2.length) {
                ResourceReference ref2 = new ResourceReference(dcss2[i2], 2);
                locations.add(dcss2[i2]);
                css.add(ref2);
                ++i2;
            }
        }
        IContainer parent = file.getParent();
        int depth = 0;
        while (parent instanceof IFolder) {
            dcss = this.getDeclaredResources((IResource)parent);
            i = 0;
            while (i < dcss.length) {
                if (!locations.contains(dcss[i])) {
                    ref = new ResourceReference(dcss[i], 1);
                    ref.setDepth(depth);
                    locations.add(dcss[i]);
                    css.add(ref);
                }
                ++i;
            }
            parent = parent.getParent();
            ++depth;
        }
        dcss = this.getDeclaredResources((IResource)file);
        i = 0;
        while (i < dcss.length) {
            if (!locations.contains(dcss[i])) {
                ref = new ResourceReference(dcss[i], 0);
                locations.add(dcss[i]);
                css.add(ref);
            }
            ++i;
        }
        return css.toArray(new ResourceReference[css.size()]);
    }

    private String[] getDeclaredResources(IResource resource) {
        IPath path;
        String nodeString;
        Preferences node;
        String s = null;
        ProjectScope projectScope = new ProjectScope(resource.getProject());
        IEclipsePreferences root = projectScope.getNode("org.jboss.tools.common.resref.core");
        if (root != null && (node = root.node(nodeString = (path = resource.getProjectRelativePath()).toString())) != null) {
            s = node.get(this.getPropertyName().getLocalName(), "");
        }
        if (s == null || s.length() == 0) {
            String old = null;
            try {
                old = resource.getPersistentProperty(this.getPropertyName());
            }
            catch (CoreException coreException) {}
            if (old == null || old.length() == 0) {
                return new String[0];
            }
            return ResourceReferenceList.decodeResourceString(old);
        }
        return ResourceReferenceList.decodeResourceString(s);
    }

    private static String[] decodeResourceString(String resource) {
        String[] results = resource.split("[,;]");
        String[] returnValues = new String[results.length];
        try {
            int i = 0;
            while (i < results.length) {
                returnValues[i] = URLDecoder.decode(results[i].trim(), CODING);
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            ResourceReferencePlugin.getPluginLog().logError((Throwable)e);
            return results;
        }
        return returnValues;
    }

    public void setAllResources(IFile file, ResourceReference[] entries) {
        IFile changed = null;
        boolean b = this.setDeclaredResources((IResource)file, entries, 0, 0);
        if (b) {
            changed = file;
        }
        IContainer parent = file.getParent();
        int depth = 0;
        while (parent instanceof IFolder) {
            b = this.setDeclaredResources((IResource)parent, entries, 1, depth);
            if (b) {
                changed = parent;
            }
            parent = parent.getParent();
            ++depth;
        }
        if (file.getProject() != null) {
            int scope = 2;
            if (file.getParent() == file.getProject()) {
                scope = 10;
            }
            if (b = this.setDeclaredResources((IResource)file.getProject(), entries, scope, 0)) {
                changed = file.getProject();
            }
        }
        if (changed != null) {
            this.fire(changed.getFullPath());
        }
    }

    private boolean setDeclaredResources(IResource resource, ResourceReference[] entries, int scope, int depth) {
        ProjectScope projectScope = new ProjectScope(resource.getProject());
        IEclipsePreferences root = projectScope.getNode("org.jboss.tools.common.resref.core");
        if (root != null) {
            String newValue;
            IPath path = resource.getProjectRelativePath();
            String nodeString = path.toString();
            Preferences node = root.node(nodeString);
            String oldValue = node.get(this.getPropertyName().getLocalName(), "");
            if (oldValue.equals(newValue = this.encodeDeclaredResources(entries, scope, depth))) {
                return false;
            }
            node.put(this.getPropertyName().getLocalName(), newValue);
            try {
                root.flush();
            }
            catch (BackingStoreException e) {
                ResourceReferencePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return true;
    }

    private String encodeDeclaredResources(ResourceReference[] entries, int scope, int depth) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < entries.length) {
            int s = entries[i].getScope();
            if (!(scope < 10 && s != scope || scope == 10 && s == 0 || scope == 1 && entries[i].getDepth() != depth)) {
                if (sb.length() > 0) {
                    sb.append(';');
                }
                try {
                    sb.append(URLEncoder.encode(entries[i].getLocationAndProperties(), CODING));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return sb.toString();
    }

    void fire(IPath path) {
        ResourceReferenceListListener[] ls = this.listeners;
        int i = 0;
        while (i < ls.length) {
            IPath listenedPath = ls[i].getPath();
            if (listenedPath != null && path.isPrefixOf(listenedPath)) {
                ls[i].changed(this);
            }
            ++i;
        }
    }

    private TreeMap getAllExternalResources() {
        if (this.allExternalResources == null) {
            this.allExternalResources = new TreeMap();
            String s = null;
            IEclipsePreferences root = InstanceScope.INSTANCE.getNode("org.jboss.tools.common.model");
            if (root != null) {
                Preferences node = root.node("org.jboss.tools.common.resref.core");
                s = node.get(this.getPropertyName().getLocalName(), "");
            }
            if (s != null && s.length() > 0) {
                this.parseExternalResources(s);
            } else {
                String old = null;
                try {
                    old = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(this.getPropertyName());
                }
                catch (CoreException coreException) {}
                if (old != null && old.length() > 0) {
                    this.parseExternalResources(old);
                }
            }
        }
        return this.allExternalResources;
    }

    private void parseExternalResources(String s) {
        StringTokenizer st = new StringTokenizer(s, "#");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            int e = t.indexOf(61);
            String path = t.substring(0, e);
            String list = t.substring(e + 1);
            if (!new File(path).exists()) continue;
            this.allExternalResources.put(path, list);
        }
    }

    private void setAllExternalResources() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.allExternalResources.keySet().iterator();
        while (it.hasNext()) {
            String path = it.next().toString();
            String list = (String)this.allExternalResources.get(path);
            if (path == null || list == null || !new File(path).exists()) continue;
            if (sb.length() > 0) {
                sb.append('#');
            }
            sb.append(path).append('=').append(list);
        }
        IEclipsePreferences root = InstanceScope.INSTANCE.getNode("org.jboss.tools.common.model");
        if (root != null) {
            Preferences node = root.node("org.jboss.tools.common.resref.core");
            node.put(this.getPropertyName().getLocalName(), sb.toString());
            try {
                root.flush();
            }
            catch (BackingStoreException e) {
                ResourceReferencePlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public ResourceReference[] getAllResources(IPath path) {
        ResourceReference ref;
        int i;
        String[] dcss;
        HashSet<String> locations = new HashSet<String>();
        ArrayList<ResourceReference> css = new ArrayList<ResourceReference>();
        IPath parent = path.removeLastSegments(1);
        int depth = 0;
        boolean isGlobal = path.equals((Object)Platform.getLocation());
        int setScope = isGlobal ? 3 : 0;
        while (parent != null && parent.segmentCount() > 1) {
            dcss = this.getDeclaredResources(path);
            i = 0;
            while (i < dcss.length) {
                if (!locations.contains(dcss[i])) {
                    ref = new ResourceReference(dcss[i], isGlobal ? 3 : 1);
                    if (isGlobal) {
                        ref.setGlobal(true);
                    }
                    ref.setDepth(depth);
                    locations.add(dcss[i]);
                    css.add(ref);
                }
                ++i;
            }
            parent = parent.removeLastSegments(1);
            ++depth;
        }
        dcss = this.getDeclaredResources(path);
        i = 0;
        while (i < dcss.length) {
            if (!locations.contains(dcss[i])) {
                ref = new ResourceReference(dcss[i], setScope);
                if (setScope == 3) {
                    ref.setGlobal(true);
                }
                locations.add(dcss[i]);
                css.add(ref);
            }
            ++i;
        }
        return css.toArray(new ResourceReference[css.size()]);
    }

    private String[] getDeclaredResources(IPath path) {
        String s = (String)this.getAllExternalResources().get(path.toString());
        if (s == null || s.length() == 0) {
            return new String[0];
        }
        return ResourceReferenceList.decodeResourceString(s);
    }

    public void setAllResources(IPath path, ResourceReference[] entries) {
        IPath changed = null;
        boolean b = false;
        int checkScope = path.equals((Object)Platform.getLocation()) ? 3 : 0;
        b = this.setDeclaredResources(path, entries, checkScope, 0);
        if (b) {
            changed = path;
        }
        IPath parent = path.removeLastSegments(1);
        int depth = 0;
        while (parent != null && parent.segmentCount() > 1) {
            b = this.setDeclaredResources(parent, entries, 1, depth);
            if (b) {
                changed = parent;
            }
            parent = parent.removeLastSegments(1);
            ++depth;
        }
        if (changed != null) {
            this.setAllExternalResources();
            this.fire(changed);
        }
    }

    private boolean setDeclaredResources(IPath path, ResourceReference[] entries, int scope, int depth) {
        String newValue;
        String oldValue = (String)this.getAllExternalResources().get(path.toString());
        if (oldValue == null) {
            oldValue = "";
        }
        if (oldValue.equals(newValue = this.encodeDeclaredResources(entries, scope, depth))) {
            return false;
        }
        if (newValue == null || newValue.length() == 0) {
            this.getAllExternalResources().remove(path.toString());
        } else {
            this.getAllExternalResources().put(path.toString(), newValue);
        }
        return true;
    }
}

