/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.pattern;

import org.eclipse.graphiti.features.ICustomUndoableFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.pattern.FeatureForPatternDelegate;
import org.eclipse.graphiti.pattern.ICustomUndoablePattern;
import org.eclipse.graphiti.pattern.IFeatureForPattern;
import org.eclipse.graphiti.pattern.IPattern;

public class CreateFeatureForPattern
extends AbstractCreateFeature
implements ICustomUndoableFeature {
    private IFeatureForPattern delegate;

    public CreateFeatureForPattern(IFeatureProvider featureProvider, IPattern pattern) {
        super(featureProvider, pattern.getCreateName(), pattern.getCreateDescription());
        this.delegate = new FeatureForPatternDelegate(pattern);
    }

    public boolean canCreate(ICreateContext context) {
        IPattern pattern = this.delegate.getPattern();
        boolean ret = pattern.canCreate(context);
        return ret;
    }

    public Object[] create(ICreateContext context) {
        return this.delegate.getPattern().create(context);
    }

    public String getCreateImageId() {
        return this.delegate.getPattern().getCreateImageId();
    }

    public String getCreateLargeImageId() {
        return this.delegate.getPattern().getCreateLargeImageId();
    }

    public IPattern getPattern() {
        return this.delegate.getPattern();
    }

    public boolean canUndo(IContext context) {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomUndoablePattern) {
            return ((ICustomUndoablePattern)((Object)pattern)).canUndo((IFeature)this, context);
        }
        return super.canUndo(context);
    }

    public void undo(IContext context) {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomUndoablePattern) {
            ((ICustomUndoablePattern)((Object)pattern)).undo((IFeature)this, context);
        }
    }

    public boolean canRedo(IContext context) {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomUndoablePattern) {
            return ((ICustomUndoablePattern)((Object)pattern)).canRedo((IFeature)this, context);
        }
        return true;
    }

    public void redo(IContext context) {
        IPattern pattern = this.delegate.getPattern();
        if (pattern instanceof ICustomUndoablePattern) {
            ((ICustomUndoablePattern)((Object)pattern)).redo((IFeature)this, context);
        }
    }
}

