/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.pattern;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IFeatureProviderHolder;
import org.eclipse.graphiti.features.IMappingProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.platform.IDiagramEditor;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.IColorConstant;

public abstract class AbstractBasePattern
implements IFeatureProviderHolder {
    private IFeatureProvider featureProvider;

    public PictogramElement add(IAddContext context) {
        return null;
    }

    public boolean canAdd(IAddContext context) {
        return false;
    }

    public IFeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public void setFeatureProvider(IFeatureProvider featureProvider) {
        this.featureProvider = featureProvider;
    }

    protected Object getBusinessObjectForPictogramElement(PictogramElement pe) {
        return this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
    }

    protected IDiagramEditor getDiagramEditor() {
        return this.getFeatureProvider().getDiagramTypeProvider().getDiagramEditor();
    }

    protected IDiagramBehavior getDiagramBehavior() {
        return this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior();
    }

    protected IMappingProvider getMappingProvider() {
        return this.getFeatureProvider();
    }

    protected void link(PictogramElement pe, Object businessObject) {
        this.link(pe, new Object[]{businessObject});
    }

    protected void link(PictogramElement pe, Object[] businessObjects) {
        this.getMappingProvider().link(pe, businessObjects);
    }

    protected Diagram getDiagram() {
        return this.getFeatureProvider().getDiagramTypeProvider().getDiagram();
    }

    protected Color manageColor(IColorConstant colorConstant) {
        return Graphiti.getGaService().manageColor(this.getDiagram(), colorConstant);
    }

    protected Color manageColor(int red, int green, int blue) {
        return Graphiti.getGaService().manageColor(this.getDiagram(), red, green, blue);
    }

    protected Font manageFont(String name, int size) {
        return Graphiti.getGaService().manageFont(this.getDiagram(), name, size);
    }

    protected Font manageFont(String name, int size, boolean isItalic, boolean isBold) {
        return Graphiti.getGaService().manageFont(this.getDiagram(), name, size, isItalic, isBold);
    }
}

