/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.action.EditCubeAction;
import org.eclipse.birt.report.designer.ui.cubebuilder.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.util.UIHelper;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class CubeSubFolderNodeProvider
extends DefaultNodeProvider {
    public Image getNodeIcon(Object model) {
        PropertyHandle property = (PropertyHandle)model;
        String name = property.getPropertyDefn().getName();
        if (name.equals("dimensions")) {
            return UIHelper.getImage("icons/obj16/dimensions.gif");
        }
        if (name.equals("measureGroups")) {
            return UIHelper.getImage("icons/obj16/measuregroups.gif");
        }
        return super.getNodeIcon(model);
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object getParent(Object model) {
        PropertyHandle property = (PropertyHandle)model;
        return property.getElementHandle();
    }

    public String getNodeDisplayName(Object model) {
        PropertyHandle property = (PropertyHandle)model;
        String name = property.getPropertyDefn().getName();
        if (name.equals("dimensions")) {
            return Messages.getString("Cube.Groups");
        }
        if (name.equals("measureGroups")) {
            return Messages.getString("Cube.MeasureGroup");
        }
        return null;
    }

    public Object[] getChildren(Object object) {
        PropertyHandle property = (PropertyHandle)object;
        String name = property.getPropertyDefn().getName();
        if (name.equals("dimensions")) {
            CubeHandle cube = (CubeHandle)property.getElementHandle();
            return cube.getContents("dimensions").toArray();
        }
        if (name.equals("measureGroups")) {
            CubeHandle cube = (CubeHandle)property.getElementHandle();
            return cube.getContents("measureGroups").toArray();
        }
        return new Object[0];
    }

    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
        PropertyHandle property = (PropertyHandle)object;
        String name = property.getPropertyDefn().getName();
        EditCubeAction action = null;
        if (name.equals("dimensions")) {
            action = new EditCubeAction(property, Messages.getString("CubeModel.group.edit"));
        } else if (name.equals("measureGroups")) {
            action = new EditCubeAction(property, Messages.getString("CubeModel.summaryfield.edit"));
        }
        if (action != null) {
            menu.add((IAction)action);
        }
        super.createContextMenu(sourceViewer, object, menu);
    }
}

