/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.project.examples.wizard;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardLocationPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.jboss.tools.maven.project.examples.MavenProjectExamplesActivator;
import org.jboss.tools.maven.project.examples.Messages;
import org.jboss.tools.project.examples.ProjectExamplesActivator;
import org.jboss.tools.project.examples.model.ArchetypeModel;
import org.jboss.tools.project.examples.model.ProjectExample;
import org.jboss.tools.project.examples.model.ProjectExampleWorkingCopy;
import org.jboss.tools.project.examples.wizard.IProjectExamplesWizardPage;
import org.jboss.tools.project.examples.wizard.NewProjectExamplesWizard2;
import org.jboss.tools.project.examples.wizard.WizardContext;

public class ArchetypeExamplesWizardFirstPage
extends MavenProjectWizardLocationPage
implements IProjectExamplesWizardPage {
    private static final String WORKING_SETS = "workingSets";
    private Label projectNameLabel;
    private Combo projectNameCombo;
    private Label packageLabel;
    private Combo packageCombo;
    private boolean initialized;
    private ProjectExample projectExample;
    private WizardContext context;
    private IRuntimeLifecycleListener listener;
    private Button isWorkspace;
    private Combo outputDirectoryCombo;
    private ArchetypeModel archetypeModel;

    public ArchetypeExamplesWizardFirstPage() {
        super(new ProjectImportConfiguration(), "", "", new ArrayList());
    }

    public ArchetypeExamplesWizardFirstPage(ProjectImportConfiguration configuration, ProjectExample projectDescription, List<IWorkingSet> workingSet) {
        super(configuration, projectDescription.getShortDescription(), Messages.ArchetypeExamplesWizardFirstPage_Title, workingSet);
        this.projectExample = projectDescription;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.setUseDefaultWorkspaceLocation(ProjectExamplesActivator.getDefault().getPreferenceStore().getBoolean("projectExamplesDefaultLocation"));
        this.setLocationCombo(ProjectExamplesActivator.getDefault().getPreferenceStore().getString("projectExamplesOutputDirectory"));
    }

    protected void createAdditionalControls(Composite container) {
        GridData gridData = new GridData(4, 128, true, false, 2, 1);
        this.projectNameLabel = new Label(container, 0);
        this.projectNameLabel.setText(Messages.ArchetypeExamplesWizardFirstPage_ProjectName_Label);
        this.projectNameCombo = new Combo(container, 2048);
        this.projectNameCombo.setLayoutData((Object)gridData);
        this.addFieldWithHistory("projectNameCombo", this.projectNameCombo);
        this.projectNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ArchetypeExamplesWizardFirstPage.this.initialized || ArchetypeExamplesWizardFirstPage.this.isCurrentPage()) {
                    ArchetypeExamplesWizardFirstPage.this.context.setProperty("projectName", (Object)ArchetypeExamplesWizardFirstPage.this.getProjectName());
                }
                ArchetypeExamplesWizardFirstPage.this.validate();
            }
        });
        this.packageLabel = new Label(container, 0);
        this.packageLabel.setText(Messages.ArchetypeExamplesWizardFirstPage_Package_Label);
        this.packageCombo = new Combo(container, 2048);
        this.packageCombo.setLayoutData((Object)gridData);
        this.packageCombo.setData("name", (Object)"packageCombo");
        this.addFieldWithHistory("packageCombo", this.packageCombo);
        this.packageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ArchetypeExamplesWizardFirstPage.this.initialized || ArchetypeExamplesWizardFirstPage.this.isCurrentPage()) {
                    ArchetypeExamplesWizardFirstPage.this.context.setProperty("package", (Object)ArchetypeExamplesWizardFirstPage.this.packageCombo.getText());
                }
                ArchetypeExamplesWizardFirstPage.this.validate();
            }
        });
        Label emptyLabel = new Label(container, 0);
        emptyLabel.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
    }

    protected void validate() {
        String location;
        if (!this.initialized) {
            return;
        }
        super.validate();
        if (!this.isPageComplete()) {
            return;
        }
        if (this.outputDirectoryCombo != null && this.isWorkspace != null && !this.isWorkspace.getSelection() && !this.validateLocation(location = this.outputDirectoryCombo.getText())) {
            return;
        }
        String errorMessage = this.validateInputs();
        this.setErrorMessage(errorMessage);
        this.setMessage(null);
        this.setPageComplete(errorMessage == null);
    }

    private String validateInputs() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String name = this.getProjectName();
        if (name.trim().length() == 0) {
            return Messages.ArchetypeExamplesWizardFirstPage_ProjectName_Cant_Be_Empty;
        }
        String resolvedName = this.getImportConfiguration().getProjectName(this.getModel());
        IStatus nameStatus = workspace.validateName(resolvedName, 4);
        if (!nameStatus.isOK()) {
            return nameStatus.getMessage();
        }
        IProject handle = workspace.getRoot().getProject(resolvedName);
        if (handle.exists()) {
            return NLS.bind((String)Messages.ArchetypeExamplesWizardFirstPage_Existing_Project, (Object)resolvedName);
        }
        String packageName = this.packageCombo.getText();
        if (packageName.trim().length() != 0 && !Pattern.matches("[A-Za-z_$][A-Za-z_$\\d]*(?:\\.[A-Za-z_$][A-Za-z_$\\d]*)*", packageName)) {
            return Messages.ArchetypeExamplesWizardFirstPage_Error_Package;
        }
        return null;
    }

    public String getProjectName() {
        return this.projectNameCombo == null ? null : this.projectNameCombo.getText();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.initialized) {
            this.initDefaultValues();
        }
    }

    private void initDefaultValues() {
        if (this.projectExample == null || this.projectNameCombo == null) {
            return;
        }
        if (this.archetypeModel != null) {
            String packageName;
            IProject p;
            String projectName = this.archetypeModel.getArtifactId();
            if (StringUtils.isNotBlank((String)projectName) && !(p = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
                this.projectNameCombo.setText(projectName);
            }
            if (StringUtils.isBlank((String)(packageName = this.archetypeModel.getJavaPackage())) && this.packageCombo.getItemCount() > 0) {
                packageName = this.packageCombo.getItem(0);
            }
            if (packageName != null) {
                this.packageCombo.setText(packageName);
            }
        }
        this.initialized = true;
        this.validate();
    }

    public void setUseDefaultWorkspaceLocation(boolean value) {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("useDefaultWorkspaceLocationButton");
            field.setAccessible(true);
            Object useDefaultWorkspaceLocation = field.get((Object)this);
            if (useDefaultWorkspaceLocation instanceof Button) {
                this.isWorkspace = (Button)useDefaultWorkspaceLocation;
                this.isWorkspace.setSelection(value);
                this.isWorkspace.notifyListeners(13, new Event());
                this.isWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ArchetypeExamplesWizardFirstPage.this.validate();
                        if (ArchetypeExamplesWizardFirstPage.this.isPageComplete()) {
                            ProjectExamplesActivator.getDefault().getPreferenceStore().setValue("projectExamplesDefaultLocation", ArchetypeExamplesWizardFirstPage.this.isWorkspace.getSelection());
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            MavenProjectExamplesActivator.log(e);
        }
    }

    public void setLocationCombo(String defaultLocation) {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("locationCombo");
            field.setAccessible(true);
            Object locationComboField = field.get((Object)this);
            if (locationComboField instanceof Combo) {
                this.outputDirectoryCombo = (Combo)locationComboField;
                this.outputDirectoryCombo.setText(defaultLocation);
                this.outputDirectoryCombo.notifyListeners(13, new Event());
                this.outputDirectoryCombo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        ArchetypeExamplesWizardFirstPage.this.validate();
                        if (ArchetypeExamplesWizardFirstPage.this.isPageComplete()) {
                            ProjectExamplesActivator.getDefault().getPreferenceStore().setValue("projectExamplesOutputDirectory", ArchetypeExamplesWizardFirstPage.this.outputDirectoryCombo.getText());
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            MavenProjectExamplesActivator.log(e);
        }
    }

    private boolean validateLocation(String location) {
        IPath projectPath = Path.fromOSString((String)location);
        if (!projectPath.toFile().exists() && !this.canCreate(projectPath.toFile())) {
            this.setErrorMessage("Cannot create project content at the given external location.");
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    private boolean canCreate(File file) {
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return false;
        }
        return file.canWrite();
    }

    public boolean finishPage() {
        return true;
    }

    public String getProjectExampleType() {
        return "mavenArchetype";
    }

    public void setProjectExample(ProjectExampleWorkingCopy projectExample) {
        this.projectExample = projectExample;
        if (projectExample != null) {
            if (projectExample.getShortDescription() != null) {
                this.setTitle(projectExample.getShortDescription());
            }
            if (projectExample.getHeadLine() != null) {
                this.setDescription(ProjectExamplesActivator.getShortDescription((String)projectExample.getHeadLine()));
            }
            this.archetypeModel = (ArchetypeModel)this.context.getProperty("archetypeModel");
            if (this.archetypeModel == null) {
                this.archetypeModel = projectExample.getArchetypeModel();
            }
            this.initDefaultValues();
        }
    }

    public IWizardPage getNextPage() {
        ProjectExample projectExample;
        IWizard wizard = this.getWizard();
        if (wizard instanceof NewProjectExamplesWizard2 && (projectExample = ((NewProjectExamplesWizard2)wizard).getSelectedProjectExample()) != null && projectExample.getImportType() != null) {
            List pages = ((NewProjectExamplesWizard2)wizard).getContributedPages("extra");
            for (IProjectExamplesWizardPage page : pages) {
                if (page == this || !projectExample.getImportType().equals(page.getProjectExampleType())) continue;
                return page;
            }
        }
        return super.getNextPage();
    }

    public IWizardPage getPreviousPage() {
        ProjectExample projectExample;
        IWizard wizard = this.getWizard();
        if (wizard instanceof NewProjectExamplesWizard2 && (projectExample = ((NewProjectExamplesWizard2)wizard).getSelectedProjectExample()) != null && projectExample.getImportType() != null) {
            List pages = ((NewProjectExamplesWizard2)wizard).getContributedPages("requirement");
            for (IProjectExamplesWizardPage page : pages) {
                if (!projectExample.getImportType().equals(page.getProjectExampleType())) continue;
                return page;
            }
        }
        return super.getPreviousPage();
    }

    public Map<String, Object> getPropertiesMap() {
        try {
            Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(WORKING_SETS);
            field.setAccessible(true);
            Object object = field.get((Object)this);
            if (object instanceof List) {
                HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
                propertiesMap.put(WORKING_SETS, object);
                return propertiesMap;
            }
        }
        catch (Exception e) {
            MavenProjectExamplesActivator.log(e);
        }
        return null;
    }

    public void onWizardContextChange(String key, Object value) {
        if ("projectName".equals(key)) {
            String artifactId = value == null ? "" : value.toString();
            this.setProjectName(artifactId);
        } else if ("package".equals(key)) {
            String packageName = value == null ? "" : value.toString();
            this.setPackageName(packageName);
        }
    }

    public void setProjectName(String projectName) {
        if (this.projectNameCombo != null && !this.projectNameCombo.getText().equals(projectName)) {
            this.projectNameCombo.setText(projectName);
        }
    }

    public void setPackageName(String packageName) {
        if (this.packageCombo != null && !this.packageCombo.getText().equals(packageName)) {
            this.packageCombo.setText(packageName);
        }
    }

    public void setWizardContext(WizardContext context) {
        this.context = context;
    }

    public ProjectImportConfiguration getImportConfiguration() {
        ProjectImportConfiguration importConfiguration = (ProjectImportConfiguration)this.context.getProperty("importProjectConfiguration");
        return importConfiguration;
    }

    private Model getModel() {
        return (Model)this.context.getProperty("mavenModel");
    }

    public String getPageType() {
        return "extra";
    }
}

